/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;
import org.limewire.util.ByteOrder;

class AltLocValueImpl
extends AbstractAltLocValue {
    private static final long serialVersionUID = -6975718782217170657L;
    private final byte[] guid;
    private final int port;
    private final long fileSize;
    private final byte[] ttroot;
    private final boolean firewalled;
    private final byte[] data;
    private final boolean supportsTLS;

    protected AltLocValueImpl(Version version, byte[] byArray, int n, long l, byte[] byArray2, boolean bl, boolean bl2) {
        super(version);
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException("Illegal GUID");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Illegal port: " + n);
        }
        if (version.compareTo(AbstractAltLocValue.VERSION_ONE) >= 0) {
            if (l < 0L) {
                throw new IllegalArgumentException("Illegal fileSize: " + l);
            }
            if (byArray2 != null && byArray2.length != 24) {
                throw new IllegalArgumentException("Illegal ttroot length: " + byArray2.length);
            }
        }
        this.guid = byArray;
        this.port = n;
        this.fileSize = l;
        this.ttroot = byArray2;
        this.firewalled = bl;
        this.supportsTLS = bl2;
        this.data = AbstractAltLocValue.serialize(this);
    }

    public AltLocValueImpl(Version version, byte[] byArray) throws DHTValueException {
        super(version);
        if (version == null) {
            throw new DHTValueException("Version is null");
        }
        if (byArray == null) {
            throw new DHTValueException("Data is null");
        }
        this.data = byArray;
        try {
            GGEP gGEP = new GGEP(byArray, 0);
            this.guid = gGEP.getBytes("client-id");
            if (this.guid.length != 16) {
                throw new DHTValueException("Illegal GUID length: " + this.guid.length);
            }
            byte[] byArray2 = gGEP.getBytes("port");
            this.port = ByteOrder.beb2short(byArray2, 0) & 0xFFFF;
            if (!NetworkUtils.isValidPort(this.port)) {
                throw new DHTValueException("Illegal port: " + this.port);
            }
            byte[] byArray3 = gGEP.getBytes("firewalled");
            if (byArray3.length != 1) {
                throw new DHTValueException("Illegal Firewalled length: " + byArray3.length);
            }
            this.firewalled = byArray3[0] != 0;
            this.supportsTLS = gGEP.hasKey("tls");
            if (version.compareTo(AbstractAltLocValue.VERSION_ONE) >= 0) {
                this.fileSize = gGEP.getLong("length");
                if (gGEP.hasKey("ttroot")) {
                    byte[] byArray4 = gGEP.getBytes("ttroot");
                    if (byArray4.length != 24) {
                        throw new DHTValueException("Illegal ttroot length: " + byArray4.length);
                    }
                    this.ttroot = byArray4;
                } else {
                    this.ttroot = null;
                }
            } else {
                this.fileSize = -1L;
                this.ttroot = null;
            }
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new DHTValueException(badGGEPPropertyException);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            throw new DHTValueException(badGGEPBlockException);
        }
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getGUID() {
        return this.guid;
    }

    public boolean isFirewalled() {
        return this.firewalled;
    }

    public boolean supportsTLS() {
        return this.supportsTLS;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public byte[] getRootHash() {
        return this.ttroot;
    }

    public byte[] getValue() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        return byArray;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }
}

