/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.IpPort;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PushProxiesValueForSelf
extends AbstractPushProxiesValue {
    private static final long serialVersionUID = -3222117316287224578L;
    private final PushEndpoint self;
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    public PushProxiesValueForSelf(NetworkManager networkManager, PushEndpointFactory pushEndpointFactory, ApplicationServices applicationServices) {
        super(AbstractPushProxiesValue.VERSION);
        this.networkManager = networkManager;
        this.self = pushEndpointFactory.createForSelf();
        this.applicationServices = applicationServices;
    }

    public boolean isEmpty() {
        return false;
    }

    @Override
    public DHTValueType getValueType() {
        return AbstractPushProxiesValue.PUSH_PROXIES;
    }

    @Override
    public Version getVersion() {
        return AbstractPushProxiesValue.VERSION;
    }

    @Override
    public byte[] getValue() {
        return AbstractPushProxiesValue.serialize(this);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getValue());
    }

    @Override
    public byte[] getGUID() {
        return this.applicationServices.getMyGUID();
    }

    @Override
    public byte getFeatures() {
        return this.self.getFeatures();
    }

    @Override
    public int getFwtVersion() {
        return this.self.supportsFWTVersion();
    }

    @Override
    public int getPort() {
        return this.networkManager.getPort();
    }

    @Override
    public Set<? extends IpPort> getPushProxies() {
        return this.self.getProxies();
    }

    @Override
    public BitNumbers getTLSInfo() {
        return AbstractPushProxiesValue.getNumbersFromProxies(this.getPushProxies());
    }
}

