/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.util;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.limewire.mojito.KUID;

public class KUIDUtils {
    private KUIDUtils() {
    }

    public static KUID toKUID(URN uRN) {
        if (!uRN.isSHA1()) {
            throw new IllegalArgumentException("Expected a SHA-1 URN: " + uRN);
        }
        return KUID.createWithBytes(uRN.getBytes());
    }

    public static URN toURN(KUID kUID) {
        try {
            return URN.createSHA1UrnFromBytes(kUID.getBytes());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static KUID toKUID(GUID gUID) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(gUID.bytes());
            byte[] byArray = messageDigest.digest();
            return KUID.createWithBytes(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }
}

