/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.AsyncDimeRecordReader;
import com.limegroup.gnutella.dime.DIMEException;
import com.limegroup.gnutella.dime.DIMERecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.statemachine.ReadState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncDimeParser
extends ReadState {
    private static final Log LOG = LogFactory.getLog(AsyncDimeParser.class);
    private boolean lastRead = false;
    private List<DIMERecord> records = new LinkedList<DIMERecord>();
    private long amountRead = 0L;
    private AsyncDimeRecordReader reader;

    @Override
    protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        do {
            DIMERecord dIMERecord;
            if (this.lastRead) {
                throw new IOException("already read last message.");
            }
            if (this.reader == null) {
                this.reader = new AsyncDimeRecordReader();
            }
            try {
                if (this.reader.process(readableByteChannel, byteBuffer)) {
                    return true;
                }
            }
            catch (DIMEException dIMEException) {
                LOG.warn("Error processing DIME", dIMEException);
                this.amountRead += this.reader.getAmountProcessed();
                return false;
            }
            this.amountRead += this.reader.getAmountProcessed();
            try {
                dIMERecord = this.reader.getRecord();
            }
            catch (DIMEException dIMEException) {
                LOG.warn("Error constructing DIME record", dIMEException);
                return false;
            }
            if (dIMERecord.isLastRecord()) {
                this.lastRead = true;
            }
            if (this.records.isEmpty() && !dIMERecord.isFirstRecord()) {
                throw new IOException("middle of stream.");
            }
            if (!this.records.isEmpty() && dIMERecord.isFirstRecord()) {
                throw new IOException("two first records.");
            }
            this.records.add(dIMERecord);
            this.reader = null;
        } while (!this.lastRead);
        return false;
    }

    public List<DIMERecord> getRecords() {
        return this.records;
    }

    @Override
    public long getAmountProcessed() {
        return this.amountRead;
    }
}

