/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.downloader.ChunkDiskJob;
import com.limegroup.gnutella.downloader.DelayedWrite;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.ByteArrayCache;
import org.limewire.collection.PowerOf2ByteArrayCache;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ManagedThread;

@Singleton
public class DiskController {
    private final Log LOG = LogFactory.getLog(DiskController.class);
    private final ThreadPoolExecutor QUEUE = ExecutorsHelper.newSingleThreadExecutor(new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            ManagedThread managedThread = new ManagedThread(runnable, "BlockingVF");
            managedThread.setDaemon(true);
            managedThread.setPriority(6);
            return managedThread;
        }
    });
    private final List<DelayedWrite> DELAYED = new LinkedList<DelayedWrite>();
    private final ByteArrayCache CACHE = new ByteArrayCache(512, 2048);
    private final PowerOf2ByteArrayCache CHUNK_CACHE = new PowerOf2ByteArrayCache();
    private int chunksScheduled = 0;
    private final Object SCHEDULE_LOCK = new Object();

    @Inject
    public DiskController(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.scheduleWithFixedDelay(new CacheCleaner(), 600000L, 600000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayedWrite(DelayedWrite delayedWrite) {
        ByteArrayCache byteArrayCache = this.CACHE;
        synchronized (byteArrayCache) {
            this.DELAYED.add(delayedWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWriteNow() {
        ByteArrayCache byteArrayCache = this.CACHE;
        synchronized (byteArrayCache) {
            return this.DELAYED.isEmpty();
        }
    }

    public byte[] getWriteChunk() {
        return this.CACHE.getQuick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiskJob(final ChunkDiskJob chunkDiskJob) {
        Object object = this.SCHEDULE_LOCK;
        synchronized (object) {
            ++this.chunksScheduled;
            this.QUEUE.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        chunkDiskJob.runChunkJob(chunkDiskJob.getChunk());
                    }
                    finally {
                        Object object = DiskController.this.SCHEDULE_LOCK;
                        synchronized (object) {
                            DiskController.this.chunksScheduled--;
                        }
                        DiskController.this.releaseChunk(chunkDiskJob.getChunk(), true);
                        chunkDiskJob.finish();
                    }
                }
            });
        }
    }

    public void addDiskJobWithoutChunk(Runnable runnable) {
        this.QUEUE.execute(runnable);
    }

    public byte[] getPowerOf2Chunk(int n) {
        return this.CHUNK_CACHE.get(n);
    }

    private void releaseChunk(byte[] byArray, boolean bl) {
        this.CACHE.release(byArray);
        if (bl) {
            this.runDelayedWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelayedWrites() {
        Object object = this.SCHEDULE_LOCK;
        synchronized (object) {
            if (this.chunksScheduled > 0) {
                return;
            }
        }
        while (this.CACHE.isBufferAvailable()) {
            ByteArrayCache byteArrayCache = this.CACHE;
            synchronized (byteArrayCache) {
                if (this.DELAYED.isEmpty()) {
                    this.LOG.debug("Nothing delayed to run.");
                    return;
                }
                object = this.DELAYED.get(0);
            }
            if (object.write()) {
                byteArrayCache = this.CACHE;
                synchronized (byteArrayCache) {
                    this.DELAYED.remove(0);
                    continue;
                }
            }
            this.QUEUE.execute(new Runnable(){

                public void run() {
                    DiskController.this.runDelayedWrites();
                }
            });
        }
    }

    public void clearCaches() {
        CacheCleaner cacheCleaner = new CacheCleaner();
        cacheCleaner.run();
    }

    public int getSizeOfByteCache() {
        return this.CACHE.getCacheSize();
    }

    public int getSizeOfVerifyingCache() {
        return this.CHUNK_CACHE.getCacheSize();
    }

    public int getNumPendingItems() {
        return this.QUEUE.getQueue().size();
    }

    private class ChunkCacheCleaner
    implements Runnable {
        private ChunkCacheCleaner() {
        }

        public void run() {
            DiskController.this.CHUNK_CACHE.clear();
        }
    }

    private class CacheCleaner
    implements Runnable {
        private CacheCleaner() {
        }

        public void run() {
            DiskController.this.LOG.info("clearing cache");
            DiskController.this.CACHE.clear();
            DiskController.this.QUEUE.execute(new ChunkCacheCleaner());
        }
    }
}

