/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.HTTPDownloaderFactory;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.VerifyingFile;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.net.SocketsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class DownloadWorkerFactoryImpl
implements DownloadWorkerFactory {
    private final HTTPDownloaderFactory httpDownloaderFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private final ScheduledExecutorService nioExecutor;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final SocketsManager socketsManager;

    @Inject
    public DownloadWorkerFactoryImpl(HTTPDownloaderFactory hTTPDownloaderFactory, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, @Named(value="nioExecutor") ScheduledExecutorService scheduledExecutorService2, Provider<PushDownloadManager> provider, SocketsManager socketsManager) {
        this.httpDownloaderFactory = hTTPDownloaderFactory;
        this.backgroundExecutor = scheduledExecutorService;
        this.nioExecutor = scheduledExecutorService2;
        this.pushDownloadManager = provider;
        this.socketsManager = socketsManager;
    }

    @Override
    public DownloadWorker create(DownloadWorkerSupport downloadWorkerSupport, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile) {
        return new DownloadWorker(downloadWorkerSupport, remoteFileDesc, verifyingFile, this.httpDownloaderFactory, this.backgroundExecutor, this.nioExecutor, this.pushDownloadManager, this.socketsManager);
    }
}

