/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.MagnetDownloadMemento;
import com.limegroup.gnutella.downloader.serial.MagnetDownloadMementoImpl;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.util.QueryUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.HttpException;
import org.limewire.io.InvalidDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MagnetDownloaderImpl
extends ManagedDownloaderImpl
implements MagnetDownloader {
    private MagnetOptions magnet;

    @Inject
    MagnetDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, FileManager fileManager, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, SavedFileManager savedFileManager, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter iPFilter, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<MessageRouter> provider, Provider<HashTreeCache> provider2, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> provider3) {
        super(saveLocationManager, downloadManager, fileManager, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, savedFileManager, verifyingFileFactory, diskController, iPFilter, scheduledExecutorService, provider, provider2, applicationServices, remoteFileDescFactory, provider3);
    }

    @Override
    public void initialize() {
        assert (this.getMagnet() != null);
        URN uRN = this.getMagnet().getSHA1Urn();
        if (uRN != null) {
            this.setSha1Urn(uRN);
        }
        super.initialize();
    }

    protected synchronized MagnetOptions getMagnet() {
        return this.magnet;
    }

    @Override
    public synchronized void setMagnet(MagnetOptions magnetOptions) {
        if (this.getMagnet() != null) {
            throw new IllegalStateException("magnet already set!");
        }
        this.magnet = magnetOptions;
    }

    @Override
    protected Downloader.DownloadStatus initializeDownload() {
        if (!this.hasRFD()) {
            MagnetOptions magnetOptions = this.getMagnet();
            String[] stringArray = magnetOptions.getDefaultURLs();
            if (stringArray.length == 0) {
                return Downloader.DownloadStatus.GAVE_UP;
            }
            RemoteFileDesc remoteFileDesc = null;
            for (int i = 0; i < stringArray.length && remoteFileDesc == null; ++i) {
                try {
                    remoteFileDesc = this.createRemoteFileDesc(stringArray[i], this.getSaveFile().getName(), magnetOptions.getSHA1Urn());
                    this.initPropertiesMap(remoteFileDesc);
                    this.addDownloadForced(remoteFileDesc, true);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (HttpException httpException) {
                    continue;
                }
                catch (URISyntaxException uRISyntaxException) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (remoteFileDesc == null) {
                return Downloader.DownloadStatus.GAVE_UP;
            }
        }
        return super.initializeDownload();
    }

    private RemoteFileDesc createRemoteFileDesc(String string, String string2, URN uRN) throws IOException, HttpException, InterruptedException, URISyntaxException {
        return this.remoteFileDescFactory.createUrlRemoteFileDesc(new URL(string), string2, uRN, -1L);
    }

    @Override
    public QueryRequest newRequery() throws CantResumeException {
        MagnetOptions magnetOptions = this.getMagnet();
        String string = magnetOptions.getQueryString();
        if (string != null) {
            String string2 = QueryUtils.createQueryString(string);
            return this.queryRequestFactory.createQuery(string2);
        }
        String string3 = QueryUtils.createQueryString(this.getSaveFile().getName());
        return this.queryRequestFactory.createQuery(string3);
    }

    @Override
    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (this.getSha1Urn() != null && uRN != null) {
            return this.getSha1Urn().equals(uRN);
        }
        return false;
    }

    @Override
    protected synchronized boolean addDownloadForced(RemoteFileDesc remoteFileDesc, boolean bl) {
        if (!this.hasRFD()) {
            this.initPropertiesMap(remoteFileDesc);
        }
        return super.addDownloadForced(remoteFileDesc, bl);
    }

    @Override
    protected boolean canSendRequeryNow() {
        return this.getSha1Urn() != null ? super.canSendRequeryNow() : false;
    }

    @Override
    protected void initializeIncompleteFile() throws IOException {
        if (this.getContentLength() != -1L) {
            super.initializeIncompleteFile();
        }
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.MAGNET;
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        super.initFromMemento(downloadMemento);
        MagnetDownloadMemento magnetDownloadMemento = (MagnetDownloadMemento)downloadMemento;
        this.setMagnet(magnetDownloadMemento.getMagnet());
    }

    @Override
    protected void fillInMemento(DownloadMemento downloadMemento) {
        super.fillInMemento(downloadMemento);
        MagnetDownloadMemento magnetDownloadMemento = (MagnetDownloadMemento)downloadMemento;
        magnetDownloadMemento.setMagnet(this.getMagnet());
    }

    @Override
    protected DownloadMemento createMemento() {
        return new MagnetDownloadMementoImpl();
    }
}

