/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.SelectionStrategy;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;

public class RandomDownloadStrategy
implements SelectionStrategy {
    private static final Log LOG = LogFactory.getLog(RandomDownloadStrategy.class);
    private static final int MAX_FRAGMENTS = 16;
    protected static Random pseudoRandom = new Random();
    protected final long completedSize;

    public RandomDownloadStrategy(long l) {
        this.completedSize = l;
    }

    public Range pickAssignment(IntervalSet intervalSet, IntervalSet intervalSet2, long l) throws NoSuchElementException {
        long l2 = intervalSet2.getFirst().getLow();
        long l3 = intervalSet2.getLast().getHigh();
        if (l < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("lowerBound must be >= 0, " + l2 + "<0");
        }
        if (l3 >= this.completedSize) {
            throw new IllegalArgumentException("Greatest needed byte must be less than completedSize " + l3 + " >= " + this.completedSize);
        }
        if (intervalSet.isEmpty()) {
            throw new NoSuchElementException();
        }
        long l4 = this.getIdealLocation(intervalSet2, l);
        Range range = null;
        Range range2 = null;
        for (Range range3 : intervalSet) {
            if (range3.getLow() < l4) {
                range2 = this.optimizeIntervalBelow(range3, l4, l);
            }
            if (range3.getHigh() < l4) continue;
            range = this.optimizeIntervalAbove(range3, l4, l);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("idealLocation=" + l4 + " intervalAbove=" + range + " intervalBelow=" + range2 + " out of possibilites:" + intervalSet);
        }
        if (range == null) {
            return range2;
        }
        if (range2 == null) {
            return range;
        }
        return (pseudoRandom.nextInt() & 1) == 1 ? range : range2;
    }

    protected long alignHigh(long l, long l2) {
        l += l2;
        l -= l % l2;
        return l - 1L;
    }

    protected long alignLow(long l, long l2) {
        l -= l % l2;
        return l;
    }

    private long getIdealLocation(IntervalSet intervalSet, long l) {
        int n = intervalSet.getNumberOfIntervals();
        if (n >= 16) {
            int n2 = pseudoRandom.nextInt(n + 1);
            if (n2 == n) {
                return intervalSet.getLast().getHigh() + 1L;
            }
            return intervalSet.getAllIntervalsAsList().get(n2).getLow();
        }
        return this.getRandomLocation(intervalSet.getFirst().getLow(), intervalSet.getLast().getHigh(), l);
    }

    private Range optimizeIntervalAbove(Range range, long l, long l2) {
        long l3;
        long l4 = range.getLow();
        if (l4 < l) {
            l4 = l;
        }
        if ((l3 = this.alignHigh(l4, l2)) > range.getHigh()) {
            l3 = range.getHigh();
        }
        if (range.getHigh() == l3 && range.getLow() == l4) {
            return range;
        }
        return Range.createRange(l4, l3);
    }

    private Range optimizeIntervalBelow(Range range, long l, long l2) {
        long l3;
        long l4 = range.getHigh();
        if (l4 >= l) {
            l4 = l - 1L;
        }
        if ((l3 = this.alignLow(l4, l2)) < range.getLow()) {
            l3 = range.getLow();
        }
        if (range.getHigh() == l4 && range.getLow() == l3) {
            return range;
        }
        return Range.createRange(l3, l4);
    }

    private long getRandomLocation(long l, long l2, long l3) {
        long l4 = l / l3;
        long l5 = l2 / l3;
        if (l4 >= l5) {
            return l;
        }
        return l3 * (l4 + Math.abs(pseudoRandom.nextLong() % (l5 - l4 + 1L)));
    }
}

