/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;

public class AWTSplashWindow
extends Window {
    private Image splashImage;
    private volatile boolean paintCalled = false;

    public AWTSplashWindow(Frame frame, Image image) {
        super(frame);
        int n;
        int n2;
        this.splashImage = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (mediaTracker.isErrorAny()) {
            this.paintCalled = true;
        }
        if ((n2 = image.getWidth(this)) < 1) {
            n2 = 1;
        }
        if ((n = image.getHeight(this)) < 1) {
            n = 1;
        }
        this.setSize(n2, n);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n2) / 2, (dimension.height - n) / 2);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getForeground());
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        graphics.drawImage(this.splashImage, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            AWTSplashWindow aWTSplashWindow = this;
            synchronized (aWTSplashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash(Image image) {
        Frame frame = new Frame();
        AWTSplashWindow aWTSplashWindow = new AWTSplashWindow(frame, image);
        aWTSplashWindow.toFront();
        aWTSplashWindow.setVisible(true);
        if (!EventQueue.isDispatchThread()) {
            AWTSplashWindow aWTSplashWindow2 = aWTSplashWindow;
            synchronized (aWTSplashWindow2) {
                while (!aWTSplashWindow.paintCalled) {
                    try {
                        aWTSplashWindow.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return frame;
    }
}

