/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.ScrollingTextPane;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.limewire.util.OSUtils;
import org.limewire.util.VersionUtils;

final class AboutWindow {
    private final JDialog DIALOG;
    private final ScrollingTextPane SCROLLING_PANE;
    private final JCheckBox SCROLL_CHECK_BOX = new JCheckBox(I18n.tr("Automatically Scroll"));

    AboutWindow() {
        this.DIALOG = new JDialog(GUIMediator.getAppFrame());
        if (!OSUtils.isMacOSX()) {
            this.DIALOG.setModal(true);
        }
        this.DIALOG.setSize(new Dimension(450, 400));
        this.DIALOG.setResizable(false);
        this.DIALOG.setTitle(I18n.tr("About FrostWire"));
        this.DIALOG.setDefaultCloseOperation(2);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }

            public void windowClosing(WindowEvent windowEvent) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }
        });
        this.SCROLLING_PANE = this.createScrollingPane();
        this.SCROLLING_PANE.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        JLabel jLabel = new JLabel(I18n.tr("FrostWire") + " " + LimeWireUtils.getLimeWireVersion());
        jLabel.setHorizontalAlignment(0);
        JLabel jLabel2 = new JLabel("Java " + VersionUtils.getJavaVersion());
        jLabel2.setHorizontalAlignment(0);
        URLLabel uRLLabel = new URLLabel("http://www.frostwire.com");
        uRLLabel.setHorizontalAlignment(0);
        this.SCROLL_CHECK_BOX.setSelected(true);
        this.SCROLL_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                    AboutWindow.this.SCROLLING_PANE.startScroll();
                } else {
                    AboutWindow.this.SCROLLING_PANE.stopScroll();
                }
            }
        });
        JButton jButton = new JButton(I18n.tr("Close"));
        this.DIALOG.getRootPane().setDefaultButton(jButton);
        jButton.setToolTipText(I18n.tr("Close This Window"));
        jButton.addActionListener(GUIUtils.getDisposeAction());
        JComponent jComponent = (JComponent)this.DIALOG.getContentPane();
        GUIUtils.addHideAction(jComponent);
        jComponent.setLayout(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 0;
        LogoPanel logoPanel = new LogoPanel();
        logoPanel.setSearching(true);
        jComponent.add((Component)logoPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jComponent.add(Box.createVerticalStrut(6), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        jComponent.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jComponent.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jComponent.add((Component)uRLLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jComponent.add(Box.createVerticalStrut(6), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 6;
        jComponent.add((Component)this.SCROLLING_PANE, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jComponent.add(Box.createVerticalStrut(6), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 8;
        jComponent.add((Component)this.SCROLL_CHECK_BOX, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jComponent.add((Component)jButton, gridBagConstraints);
    }

    private void appendListOfNames(String string, StringBuilder stringBuilder) {
        for (String string2 : string.split(",")) {
            stringBuilder.append("<li>" + string2 + "</li>");
        }
    }

    private ScrollingTextPane createScrollingPane() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        Color color = new JLabel().getForeground();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        String string = this.toHex(n) + this.toHex(n2) + this.toHex(n3);
        stringBuilder.append("<body text='#" + string + "'>");
        stringBuilder.append(I18n.tr("<h1>FrostWire Developers</h1>"));
        stringBuilder.append("<strong>US:</strong>");
        stringBuilder.append("<ul><li>Ian '<strong>the man</strong>' Walker</li></ul>");
        stringBuilder.append("<strong>VE:</strong>");
        stringBuilder.append("<ul>");
        stringBuilder.append("<li>Fernando Toussaint '<strong>FTA</strong>' - <a href='http://www.cybercultura.net'>Web</a></li>");
        stringBuilder.append("<li>Alden Torres '<strong>aldenml</strong>' - <a href='http://www.aldentorres.com'>Blog</a>, <a href='http://google.com/profiles/aldenml'>Buzz</a>, <a href='http://twitter.com/aldenml'>Twitter</a></li>");
        stringBuilder.append("<li>Angel Leon '<strong>gubatron</strong>' - <a href='http://www.gubatron.com'>Blog</a>, <a href='http://google.com/profiles/gubatron2'>Buzz</a>, <a href='http://twitter.com/gubatron'>Twitter</a></li>");
        stringBuilder.append("</ul><br><br>");
        stringBuilder.append(I18n.tr("<h1>FrostWire Logo Designer</h1>"));
        stringBuilder.append("<ul><li>Luis Ramirez (Venezuela - <a href='http://www.elblogo.com'>ElBlogo.com</a>)</li></ul>");
        stringBuilder.append(I18n.tr("<h1>FrostWire Graphics Designer</h1>"));
        stringBuilder.append("<ul><li>Arianys Wilson - Splash 4.18 (New York - <a href='http://nanynany.com/blog/?from=frostwire'>NanyNany.com</a>)</li></ul>");
        stringBuilder.append("<ul><li>Scott Kellum - Splash 4.17 (New York - <a href='http://www.scottkellum.net'>ScottKellum.net</a>)</li></ul>");
        stringBuilder.append("<ul><li>Shelby Allen - Splash 4.13 (New Zealand - <a href='http://www.stitzu.com'>Stitzu.com</a>)</li></ul>");
        stringBuilder.append("<ul><li>Cecko Hanssen - <a href='http://www.flickr.com/photos/cecko/95013472/'>Frozen Brothers</a> CC Photograph for 4.17 Splash (Tilburg, Netherlands)</li></ul>");
        stringBuilder.append(I18n.tr("<h1>Thanks to Former FrostWire Developers</h1>"));
        stringBuilder.append("<li>Gregorio Roper (Germany)</li>");
        stringBuilder.append("<br><br>");
        stringBuilder.append(I18n.tr("<h1>Thanks to the FrostWire Chat Community!</h1>"));
        stringBuilder.append(I18n.tr("Thanks to everybody that has helped us everyday in the forums and chatrooms, you not only help new users but you also warn the FrostWire team of any problem that occur on our networks. Thank you all, without you this wouldn't be possible!"));
        stringBuilder.append(I18n.tr("<br><br>In Special we give thanks to the Chatroom Operators and Forum Moderators"));
        stringBuilder.append("<ul>");
        stringBuilder.append(I18n.tr("<h1>FrostWire Chat Operators</h1>"));
        String string2 = "Aubrey,Casper,COOTMASTER,Emily,Flying_Dutch_ManxD,Gummo,Hobo,Humanoid,iDan,lexie,Marshall,OfficerSparker,PwincessJess,Tea,The_Fox,WolfWalker,Wyrdjax";
        this.appendListOfNames(string2, stringBuilder);
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.tr("<h1>FrostWire Forum Moderators</h1>"));
        String string3 = "Aaron.Walkhouse,Calliope,cootmaster,Efrain,et voil&agrave;,nonprofessional,Only A Hobo,spuggy,stief,The_Fox";
        stringBuilder.append("<ul>");
        this.appendListOfNames(string3, stringBuilder);
        stringBuilder.append("</ul>");
        stringBuilder.append("<h1>Many Former Chat Operators</h1>");
        String string4 = "AlleyCat,Coelacanth,Gollum,Jewels,Jordan,Kaapeli,Malachi,Maya,Sabladowah,Sweet_Songbird,UB4T,jwb,luna_moon,nonproffessional,sug,the-jack,yummy-brummy";
        stringBuilder.append("<ul>");
        this.appendListOfNames(string4, stringBuilder);
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.tr("And also to the Support Volunteer Helpers:"));
        stringBuilder.append("<ul>");
        this.appendListOfNames("dutchboy,Lelu,udsteve", stringBuilder);
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.tr("<h1>Thanks to the LimeWire Developer Team</h1>"));
        stringBuilder.append("<ul>\n  <li>Greg Bildson</li>\n  <li>Sam Berlin</li>\n  <li>Zlatin Balevsky</li>\n  <li>Felix Berger</li>\n  <li>Mike Everett</li>\n  <li>Kevin Faaborg</li>\n  <li>Jay Jeyaratnam</li>\n  <li>Curtis Jones</li>\n  <li>Tim Julien</li>\n  <li>Akshay Kumar</li>\n  <li>Jeff Palm</li>\n  <li>Mike Sorvillo</li>\n  <li>Dan Sullivan</li>\n</ul>");
        stringBuilder.append(I18n.tr("Several colleagues in the Gnutella community merit special thanks. These include:"));
        stringBuilder.append("<ul>\n  <li>Vincent Falco -- Free Peers, Inc.</li>\n  <li>Gordon Mohr -- Bitzi, Inc.</li>\n  <li>John Marshall -- Gnucleus</li>\n  <li>Jason Thomas -- Swapper</li>\n  <li>Brander Lien -- ToadNode</li>\n  <li>Angelo Sotira -- www.gnutella.com</li>\n  <li>Marc Molinaro -- www.gnutelliums.com</li>\n  <li>Simon Bellwood -- www.gnutella.co.uk</li>\n  <li>Serguei Osokine</li>\n  <li>Justin Chapweske</li>\n  <li>Mike Green</li>\n  <li>Raphael Manfredi</li>\n  <li>Tor Klingberg</li>\n  <li>Mickael Prinkey</li>\n  <li>Sean Ediger</li>\n  <li>Kath Whittle</li>\n</ul>");
        stringBuilder.append("<h1>Thanks to the Azureus Core Developers</h1>");
        String string5 = "Olivier Chalouhi (gudy),Alon Rohter (nolar),Paul Gardner (parg),ArronM (TuxPaper),Paul Duran (fatal_2),Jonathan Ledlie(ledlie),Allan Crooks (amc1),Xyrio (muxumx),Michael Parker (shadowmatter),Aaron Grunthal (the8472)";
        stringBuilder.append("<ul>");
        this.appendListOfNames(string5, stringBuilder);
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.tr("<h1>Thanks to the PJIRC Staff</h1>"));
        stringBuilder.append("<ul>");
        stringBuilder.append("<li>Plouf</li>");
        stringBuilder.append("<li>Jiquera</li>");
        stringBuilder.append("<li>Ezequiel</li>");
        stringBuilder.append("<li>Superchatbar.nl</li>");
        stringBuilder.append("<li>Thema</li>");
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.tr("<h1>Thanks to the Automatix Team</h1>"));
        stringBuilder.append("<p>For helping distribute Frostwire to opensource communities in a very simple manner.");
        stringBuilder.append("<ul>");
        stringBuilder.append("<li>Arnieboy</li>");
        stringBuilder.append("<li>JimmyJazz</li>");
        stringBuilder.append("<li>Mstlyevil</li>");
        stringBuilder.append("<li>WildTangent</li>");
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.tr("<h1>Thanks to Ubuntu/Kubuntu Teams</h1>"));
        stringBuilder.append(I18n.tr("<p>For making the world a better place with such an excellent distro, you'll be the ones to make a difference on the desktop.</p>"));
        stringBuilder.append(I18n.tr("<h1>Thanks to the NSIS Project</h1>"));
        stringBuilder.append(I18n.tr("<p>Thanks for such an awesome installer builder system and documentation.</p>"));
        stringBuilder.append(I18n.tr("<h1>Thanks to our families</h1>"));
        stringBuilder.append(I18n.tr("For being patient during our many sleepless nights"));
        stringBuilder.append("<small>");
        stringBuilder.append("<br><br>");
        stringBuilder.append(I18n.tr("BitTorrent, the BitTorrent Logo, and Torrent are trademarks of BitTorrent, Inc."));
        stringBuilder.append("</small>");
        stringBuilder.append("</body></html>");
        return new ScrollingTextPane(stringBuilder.toString());
    }

    private String toHex(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    void showDialog() {
        GUIUtils.centerOnScreen(this.DIALOG);
        if (this.SCROLL_CHECK_BOX.isSelected()) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                        AboutWindow.this.SCROLLING_PANE.startScroll();
                    }
                }
            };
            Timer timer = new Timer(10000, actionListener);
            timer.setRepeats(false);
            timer.start();
        }
        this.DIALOG.setVisible(true);
    }
}

