/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BoxPanel
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final Dimension HORIZONTAL_COMPONENT_GAP = new Dimension(6, 0);
    public static final Dimension VERTICAL_COMPONENT_GAP = new Dimension(0, 6);
    public static final Dimension LINE_GAP = new Dimension(0, 10);

    public BoxPanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public BoxPanel(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal BoxPanel orientation");
        }
        this.setLayout(new BoxLayout(this, n));
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal BoxPanel orientation");
        }
        this.setLayout(new BoxLayout(this, n));
    }

    public void addLineGap() {
        this.add(Box.createRigidArea(LINE_GAP));
    }

    public void addHorizontalComponentGap() {
        this.add(Box.createRigidArea(HORIZONTAL_COMPONENT_GAP));
    }

    public void addVerticalComponentGap() {
        this.add(Box.createRigidArea(VERTICAL_COMPONENT_GAP));
    }

    public void addLeft(JComponent jComponent) {
        jComponent.setAlignmentX(1.0f);
        super.add(jComponent);
    }

    public void addCenter(JComponent jComponent) {
        jComponent.setAlignmentX(0.5f);
        super.add(jComponent);
    }

    public void addRight(JComponent jComponent) {
        jComponent.setAlignmentX(0.0f);
        super.add(jComponent);
    }
}

