/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.UISettings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.limewire.io.IOUtils;

public class ButtonIconController {
    private Icon NULL = new ImageIcon();
    private final Properties BUTTON_NAMES = ButtonIconController.loadButtonNameMap();
    private final Map<String, Icon> BUTTON_CACHE = new HashMap<String, Icon>();

    public void wipeButtonIconCache() {
        this.BUTTON_CACHE.clear();
    }

    public Icon getIconForButton(String string) {
        String string2 = this.BUTTON_NAMES.getProperty(string);
        if (string2 == null) {
            return null;
        }
        Icon icon = this.BUTTON_CACHE.get(string2);
        if (icon == this.NULL) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        try {
            String string3 = UISettings.SMALL_ICONS.getValue() ? string2 + "_small" : string2 + "_large";
            icon = ResourceManager.getThemeImage(string3);
            this.BUTTON_CACHE.put(string2, icon);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                icon = ResourceManager.getThemeImage(string2);
                this.BUTTON_CACHE.put(string2, icon);
            }
            catch (MissingResourceException missingResourceException2) {
                this.BUTTON_CACHE.put(string2, this.NULL);
            }
        }
        return icon;
    }

    public Icon getRolloverIconForButton(String string) {
        String string2 = this.BUTTON_NAMES.getProperty(string);
        if (string2 == null) {
            return null;
        }
        String string3 = string2 + "_rollover";
        Icon icon = this.BUTTON_CACHE.get(string3);
        if (icon == this.NULL) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        Icon icon2 = this.BUTTON_CACHE.get(string2);
        if (icon2 == this.NULL || icon2 == null) {
            this.BUTTON_CACHE.put(string3, this.NULL);
            return null;
        }
        icon = ImageManipulator.brighten(icon2);
        if (icon == null) {
            this.BUTTON_CACHE.put(string3, this.NULL);
        } else {
            this.BUTTON_CACHE.put(string3, icon);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadButtonNameMap() {
        Properties properties = new Properties();
        URL uRL = ResourceManager.getURLResource("icon_mapping.properties");
        BufferedInputStream bufferedInputStream = null;
        try {
            if (uRL != null) {
                bufferedInputStream = new BufferedInputStream(uRL.openStream());
                properties.load(bufferedInputStream);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.close(bufferedInputStream);
        }
        return properties;
    }
}

