/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeDaapServerNIO;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import de.kapsi.net.daap.AutoCommitTransaction;
import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class DaapManager
implements FinalizeListener {
    private static final Log LOG = LogFactory.getLog(DaapManager.class);
    private static final boolean USE_LIME_NIO = true;
    private static DaapManager instance = null;
    private Library library;
    private Database database;
    private Playlist masterPlaylist;
    private Playlist whatsNew;
    private Playlist creativecommons;
    private Playlist videos;
    private DaapServer server;
    private BonjourService bonjour;
    private AutoCommitTransaction autoCommitTxn;
    private boolean enabled = false;
    private int maxPlaylistSize;
    private Map<URN, Song> urnToSong;

    public static synchronized DaapManager instance() {
        if (instance == null) {
            instance = new DaapManager();
        }
        return instance;
    }

    private DaapManager() {
        GUIMediator.addFinalizeListener(this);
    }

    public synchronized void init() {
        if (this.isServerRunning()) {
            this.setEnabled(this.enabled);
        }
    }

    public synchronized void start() throws IOException {
        if (!this.isServerRunning()) {
            try {
                InetAddress inetAddress = NetworkUtils.getLocalAddress();
                this.bonjour = new BonjourService(inetAddress);
                this.urnToSong = new HashMap<URN, Song>();
                this.maxPlaylistSize = DaapSettings.DAAP_MAX_LIBRARY_SIZE.getValue();
                String string = DaapSettings.DAAP_LIBRARY_NAME.getValue();
                this.library = new Library(string);
                this.autoCommitTxn = new AutoCommitTransaction(this.library);
                this.database = new Database(string);
                this.whatsNew = new Playlist(I18n.tr("What's New"));
                this.creativecommons = new Playlist(I18n.tr("Creative Commons"));
                this.videos = new Playlist(I18n.tr("Video"));
                this.library.addDatabase(null, this.database);
                this.database.addPlaylist(null, this.creativecommons);
                this.database.addPlaylist(null, this.whatsNew);
                this.creativecommons.setSmartPlaylist(null, true);
                this.whatsNew.setSmartPlaylist(null, true);
                this.masterPlaylist = this.database.getMasterPlaylist();
                LimeConfig limeConfig = new LimeConfig(inetAddress);
                if (DaapSettings.DAAP_REQUIRES_PASSWORD.getValue()) {
                    if (DaapSettings.DAAP_REQUIRES_USERNAME.getValue()) {
                        limeConfig.setAuthenticationMethod(DaapConfig.USERNAME_AND_PASSWORD);
                        limeConfig.setAuthenticationScheme(DaapConfig.DIGEST_SCHEME);
                    } else {
                        limeConfig.setAuthenticationMethod(DaapConfig.PASSWORD);
                        limeConfig.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                    }
                } else {
                    limeConfig.setAuthenticationMethod(DaapConfig.NO_PASSWORD);
                    limeConfig.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                }
                this.server = new LimeDaapServerNIO(this.library, limeConfig);
                this.server.setAuthenticator(new LimeAuthenticator());
                this.server.setStreamSource(new LimeStreamSource());
                this.server.setFilter(new LimeFilter());
                for (int i = 0; i < 10; ++i) {
                    try {
                        this.server.bind();
                        break;
                    }
                    catch (BindException bindException) {
                        if (i >= 9) {
                            throw bindException;
                        }
                        limeConfig.nextPort();
                        continue;
                    }
                }
                this.server.run();
                this.bonjour.registerService();
            }
            catch (IOException iOException) {
                this.stop();
                throw iOException;
            }
        }
    }

    public synchronized void stop() {
        if (this.bonjour != null) {
            this.bonjour.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.urnToSong != null) {
            this.urnToSong.clear();
        }
        this.bonjour = null;
        this.server = null;
        this.urnToSong = null;
        this.library = null;
        this.whatsNew = null;
        this.creativecommons = null;
        this.database = null;
        this.autoCommitTxn = null;
    }

    public synchronized void restart() throws IOException {
        if (this.isServerRunning()) {
            this.stop();
        }
        this.start();
        this.init();
    }

    public void doFinalize() {
        this.stop();
    }

    public synchronized void updateService() throws IOException {
        if (this.isServerRunning()) {
            this.bonjour.updateService();
            Transaction transaction = this.library.beginTransaction();
            String string = DaapSettings.DAAP_LIBRARY_NAME.getValue();
            this.library.setName(transaction, string);
            this.masterPlaylist.setName(transaction, string);
            this.database.setName(transaction, string);
            DaapConfig daapConfig = this.server.getConfig();
            if (DaapSettings.DAAP_REQUIRES_PASSWORD.getValue()) {
                if (DaapSettings.DAAP_REQUIRES_USERNAME.getValue()) {
                    daapConfig.setAuthenticationMethod(DaapConfig.USERNAME_AND_PASSWORD);
                    daapConfig.setAuthenticationScheme(DaapConfig.DIGEST_SCHEME);
                } else {
                    daapConfig.setAuthenticationMethod(DaapConfig.PASSWORD);
                    daapConfig.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                }
            } else {
                daapConfig.setAuthenticationMethod(DaapConfig.NO_PASSWORD);
                daapConfig.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
            }
            transaction.commit();
        }
    }

    public synchronized void disconnectAll() {
        if (this.isServerRunning()) {
            this.server.disconnectAll();
        }
    }

    public synchronized boolean isServerRunning() {
        if (this.server != null) {
            return this.server.isRunning();
        }
        return false;
    }

    private boolean handleError(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        String string = throwable.getMessage();
        if (string == null || string.indexOf("Unable to establish loopback connection") == -1) {
            return this.handleError(throwable.getCause());
        }
        if (OSUtils.isWindowsXP() || OSUtils.isWindowsVista()) {
            DialogOption dialogOption = GUIMediator.showYesNoCancelMessage(I18n.tr("FrostWire was unable to start the Digital Audio Access Protocol (for sharing files in iTunes) because a Microsoft patch is required or a firewall is blocking access. LimeWire can direct you to Microsoft's page with information if you want to use this feature. Click 'Yes' to go to the patch, 'No' to disable this feature, or 'Cancel' to decide later."));
            switch (dialogOption) {
                case YES: {
                    GUIMediator.openURL("http://support.microsoft.com/default.aspx?kbid=884020");
                    break;
                }
                case NO: {
                    DaapSettings.DAAP_ENABLED.setValue(false);
                }
            }
        } else {
            DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("FrostWire was unable to start the Digital Audio Access Protocol (for sharing files in iTunes) because a firewall is blocking access. To continue using this feature, click 'Yes' and change your firewall to allow 'LimeWire.exe' full access to incoming and outgoing connections. To disable this feature, click 'No'."), DialogOption.YES);
            if (dialogOption == DialogOption.NO) {
                DaapSettings.DAAP_ENABLED.setValue(false);
            }
        }
        return true;
    }

    private static boolean isSupportedAudioFormat(String string) {
        return DaapManager.isSupportedFormat(DaapSettings.DAAP_SUPPORTED_AUDIO_FILE_TYPES.getValue(), string);
    }

    private static boolean isSupportedVideoFormat(String string) {
        return DaapManager.isSupportedFormat(DaapSettings.DAAP_SUPPORTED_VIDEO_FILE_TYPES.getValue(), string);
    }

    private static boolean isSupportedFormat(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void handleChangeEvent(FileManagerEvent fileManagerEvent) {
        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
        Song song = this.urnToSong.remove(fileDesc.getSHA1Urn());
        if (song != null) {
            FileDesc fileDesc2 = fileManagerEvent.getFileDescs()[1];
            this.urnToSong.put(fileDesc2.getSHA1Urn(), song);
            String string = fileDesc2.getFileName().toLowerCase(Locale.US);
            if (DaapManager.isSupportedAudioFormat(string)) {
                this.updateSongAudioMeta(this.autoCommitTxn, song, fileDesc2);
            } else if (DaapManager.isSupportedVideoFormat(string)) {
                this.updateSongVideoMeta(this.autoCommitTxn, song, fileDesc2);
            } else {
                this.database.removeSong(this.autoCommitTxn, song);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAddEvent(FileManagerEvent fileManagerEvent) {
        Object object = this.library;
        synchronized (object) {
            if (this.database.getSongCount() >= this.maxPlaylistSize) {
                return;
            }
        }
        object = fileManagerEvent.getFileDescs()[0];
        if (!(object instanceof IncompleteFileDesc)) {
            String string = ((FileDesc)object).getFileName().toLowerCase(Locale.US);
            Song song = null;
            if (DaapManager.isSupportedAudioFormat(string)) {
                song = this.createSong((FileDesc)object, true);
            } else if (DaapManager.isSupportedVideoFormat(string)) {
                song = this.createSong((FileDesc)object, false);
            }
            if (song != null) {
                this.urnToSong.put(((FileDesc)object).getSHA1Urn(), song);
                this.database.getMasterPlaylist().addSong(this.autoCommitTxn, song);
                this.whatsNew.addSong(this.autoCommitTxn, song);
                if (((FileDesc)object).isLicensed()) {
                    this.creativecommons.addSong(this.autoCommitTxn, song);
                }
                if (DaapManager.isSupportedVideoFormat(string)) {
                    this.videos.addSong(this.autoCommitTxn, song);
                }
            }
        }
    }

    private void handleRenameEvent(FileManagerEvent fileManagerEvent) {
        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
        Song song = this.urnToSong.remove(fileDesc.getSHA1Urn());
        if (song != null) {
            FileDesc fileDesc2 = fileManagerEvent.getFileDescs()[1];
            this.urnToSong.put(fileDesc2.getSHA1Urn(), song);
            song.setAttachment(fileDesc2);
        }
    }

    private void handleRemoveEvent(FileManagerEvent fileManagerEvent) {
        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
        Song song = this.urnToSong.remove(fileDesc.getSHA1Urn());
        if (song != null) {
            this.database.removeSong(this.autoCommitTxn, song);
            song.setAttachment(null);
        }
    }

    public synchronized void handleFileManagerEvent(FileManagerEvent fileManagerEvent) {
        if (!this.enabled || !this.isServerRunning()) {
            return;
        }
        if (fileManagerEvent.isChangeEvent()) {
            this.handleChangeEvent(fileManagerEvent);
        } else if (fileManagerEvent.isAddEvent()) {
            this.handleAddEvent(fileManagerEvent);
        } else if (fileManagerEvent.isRenameEvent()) {
            this.handleRenameEvent(fileManagerEvent);
        } else if (fileManagerEvent.isRemoveEvent()) {
            this.handleRemoveEvent(fileManagerEvent);
        }
    }

    public void fileManagerLoading() {
        this.setEnabled(false);
    }

    public void fileManagerLoaded() {
        this.setEnabled(true);
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    private synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl || !this.isServerRunning()) {
            return;
        }
        HashMap<URN, Song> hashMap = new HashMap<URN, Song>();
        int n = this.masterPlaylist.getSongCount();
        Transaction transaction = this.library.beginTransaction();
        FileDesc[] fileDescArray = GuiCoreMediator.getFileManager().getAllSharedFileDescriptors();
        for (int i = 0; i < fileDescArray.length; ++i) {
            String string;
            boolean bl2;
            FileDesc object = fileDescArray[i];
            if (object instanceof IncompleteFileDesc || !(bl2 = DaapManager.isSupportedAudioFormat(string = object.getFileName().toLowerCase(Locale.US))) && !DaapManager.isSupportedVideoFormat(string)) continue;
            URN uRN = object.getSHA1Urn();
            Song song = this.urnToSong.remove(uRN);
            if (hashMap.containsKey(uRN)) continue;
            if (song != null) {
                hashMap.put(uRN, song);
                if (bl2) {
                    this.updateSongAudioMeta(transaction, song, object);
                    continue;
                }
                this.updateSongVideoMeta(transaction, song, object);
                continue;
            }
            if (n >= this.maxPlaylistSize) continue;
            song = this.createSong(object, bl2);
            hashMap.put(uRN, song);
            this.database.getMasterPlaylist().addSong(transaction, song);
            if (object.isLicensed()) {
                this.creativecommons.addSong(transaction, song);
            }
            if (DaapManager.isSupportedVideoFormat(string)) {
                this.videos.addSong(transaction, song);
            }
            ++n;
        }
        for (Song song : this.urnToSong.values()) {
            this.database.removeSong(transaction, song);
            song.setAttachment(null);
        }
        this.urnToSong.clear();
        this.urnToSong = hashMap;
        transaction.commit();
    }

    private Song createSong(FileDesc fileDesc, boolean bl) {
        Song song = new Song(fileDesc.getFileName());
        song.setSize(null, fileDesc.getFileSize() & 0xFFFFFFFFL);
        song.setDateAdded(null, System.currentTimeMillis() / 1000L);
        File file = fileDesc.getFile();
        String string = FileUtils.getFileExtension(file);
        if (!bl) {
            song.setHasVideo(null, true);
        }
        if (string != null) {
            if (!(string = string.toLowerCase(Locale.US)).endsWith("mp3")) {
                song.setFormat(null, string);
            }
            if (bl) {
                this.updateSongAudioMeta(null, song, fileDesc);
            } else {
                this.updateSongVideoMeta(null, song, fileDesc);
            }
        } else {
            song.setAttachment(fileDesc);
        }
        return song;
    }

    private boolean updateSongVideoMeta(Transaction transaction, Song song, FileDesc fileDesc) {
        int n;
        String string;
        song.setAttachment(fileDesc);
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = GuiCoreMediator.getSchemaReplyCollectionMapper();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection("http://www.limewire.com/schemas/video.xsd");
        if (limeXMLReplyCollection == null) {
            LOG.error("LimeXMLReplyCollection is null");
            return false;
        }
        LimeXMLDocument limeXMLDocument = limeXMLReplyCollection.getDocForHash(fileDesc.getSHA1Urn());
        if (limeXMLDocument == null) {
            return false;
        }
        boolean bl = false;
        String string2 = limeXMLDocument.getValue("videos__video__title__");
        String string3 = limeXMLDocument.getValue("videos__video__year__");
        String string4 = limeXMLDocument.getValue("videos__video__rating__");
        String string5 = limeXMLDocument.getValue("videos__video__length__");
        String string6 = limeXMLDocument.getValue("videos__video__license__");
        String string7 = limeXMLDocument.getValue("videos__video__bitrate__");
        String string8 = limeXMLDocument.getValue("videos__video__director__");
        if (!(string2 == null || (string = song.getName()) != null && string2.equals(string))) {
            bl = true;
            song.setName(transaction, string2);
        }
        int n2 = song.getBitrate();
        if (string7 != null) {
            try {
                int n3 = Integer.parseInt(string7);
                if (n3 > 0 && n3 != n2) {
                    bl = true;
                    song.setBitrate(transaction, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n2 != 0) {
            bl = true;
            song.setBitrate(transaction, 0);
        }
        long l = song.getTime();
        if (string5 != null) {
            try {
                n = (int)((long)Integer.parseInt(string5) * 1000L);
                if (n > 0 && (long)n != l) {
                    bl = true;
                    song.setTime(transaction, n);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (l != 0L) {
            bl = true;
            song.setTime(transaction, 0L);
        }
        n = song.getYear();
        if (string3 != null) {
            try {
                int n4 = Integer.parseInt(string3);
                if (n4 > 0 && n4 != n) {
                    bl = true;
                    song.setYear(transaction, n4);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n != 0) {
            bl = true;
            song.setYear(transaction, 0);
        }
        String string9 = song.getGenre();
        if (string6 != null) {
            if (string9 == null || !string6.equals(string9)) {
                bl = true;
                song.setGenre(transaction, string6);
            }
        } else if (string9 != null) {
            bl = true;
            song.setGenre(transaction, null);
        }
        String string10 = song.getArtist();
        if (string8 != null) {
            if (string10 == null || !string8.equals(string10)) {
                bl = true;
                song.setArtist(transaction, string8);
            }
        } else if (string10 != null) {
            bl = true;
            song.setArtist(transaction, null);
        }
        String string11 = song.getAlbum();
        if (string4 != null) {
            if (string11 == null || !string4.equals(string11)) {
                bl = true;
                song.setAlbum(transaction, string4);
            }
        } else if (string11 != null) {
            bl = true;
            song.setAlbum(transaction, null);
        }
        return bl;
    }

    private boolean updateSongAudioMeta(Transaction transaction, Song song, FileDesc fileDesc) {
        int n;
        String string;
        song.setAttachment(fileDesc);
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = GuiCoreMediator.getSchemaReplyCollectionMapper();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection("http://www.limewire.com/schemas/audio.xsd");
        if (limeXMLReplyCollection == null) {
            LOG.error("LimeXMLReplyCollection is null");
            return false;
        }
        LimeXMLDocument limeXMLDocument = limeXMLReplyCollection.getDocForHash(fileDesc.getSHA1Urn());
        if (limeXMLDocument == null) {
            return false;
        }
        boolean bl = false;
        String string2 = limeXMLDocument.getValue("audios__audio__title__");
        String string3 = limeXMLDocument.getValue("audios__audio__track__");
        String string4 = limeXMLDocument.getValue("audios__audio__artist__");
        String string5 = limeXMLDocument.getValue("audios__audio__album__");
        String string6 = limeXMLDocument.getValue("audios__audio__genre__");
        String string7 = limeXMLDocument.getValue("audios__audio__bitrate__");
        String string8 = limeXMLDocument.getValue("audios__audio__seconds__");
        String string9 = limeXMLDocument.getValue("audios__audio__year__");
        if (!(string2 == null || (string = song.getName()) != null && string2.equals(string))) {
            bl = true;
            song.setName(transaction, string2);
        }
        int n2 = song.getTrackNumber();
        if (string3 != null) {
            try {
                int n3 = Integer.parseInt(string3);
                if (n3 > 0 && n3 != n2) {
                    bl = true;
                    song.setTrackNumber(transaction, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n2 != 0) {
            bl = true;
            song.setTrackNumber(transaction, 0);
        }
        String string10 = song.getArtist();
        if (string4 != null) {
            if (string10 == null || !string4.equals(string10)) {
                bl = true;
                song.setArtist(transaction, string4);
            }
        } else if (string10 != null) {
            bl = true;
            song.setArtist(transaction, null);
        }
        String string11 = song.getAlbum();
        if (string5 != null) {
            if (string11 == null || !string5.equals(string11)) {
                bl = true;
                song.setAlbum(transaction, string5);
            }
        } else if (string11 != null) {
            bl = true;
            song.setAlbum(transaction, null);
        }
        String string12 = song.getGenre();
        if (string6 != null) {
            if (string12 == null || !string6.equals(string12)) {
                bl = true;
                song.setGenre(transaction, string6);
            }
        } else if (string12 != null) {
            bl = true;
            song.setGenre(transaction, null);
        }
        int n4 = song.getBitrate();
        if (string7 != null) {
            try {
                int n5 = Integer.parseInt(string7);
                if (n5 > 0 && n5 != n4) {
                    bl = true;
                    song.setBitrate(transaction, n5);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n4 != 0) {
            bl = true;
            song.setBitrate(transaction, 0);
        }
        long l = song.getTime();
        if (string8 != null) {
            try {
                long l2 = (long)Integer.parseInt(string8) * 1000L;
                if (l2 > 0L && l2 != l) {
                    bl = true;
                    song.setTime(transaction, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (l != 0L) {
            bl = true;
            song.setTime(transaction, 0L);
        }
        int n6 = song.getYear();
        if (string9 != null) {
            try {
                n = Integer.parseInt(string9);
                if (n > 0 && n != n6) {
                    bl = true;
                    song.setYear(transaction, n);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n6 != 0) {
            bl = true;
            song.setYear(transaction, 0);
        }
        n = (int)(fileDesc.lastModified() / 1000L);
        if (song.getDateModified() != (long)n) {
            bl = true;
            song.setDateModified(transaction, n);
        }
        return bl;
    }

    private final class BonjourService {
        private static final String VERSION = "Version";
        private static final String MACHINE_NAME = "Machine Name";
        private static final String PASSWORD = "Password";
        private final JmDNS zeroConf;
        private ServiceInfo serviceInfo;

        public BonjourService(InetAddress inetAddress) throws IOException {
            this.zeroConf = new JmDNS(inetAddress);
        }

        public boolean isRegistered() {
            return this.serviceInfo != null;
        }

        private ServiceInfo createServiceInfo() {
            String string = DaapSettings.DAAP_TYPE_NAME.getValue();
            String string2 = DaapSettings.DAAP_SERVICE_NAME.getValue();
            int n = DaapSettings.DAAP_PORT.getValue();
            int n2 = DaapSettings.DAAP_WEIGHT.getValue();
            int n3 = DaapSettings.DAAP_PRIORITY.getValue();
            boolean bl = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(VERSION, Integer.toString(196608));
            hashtable.put(MACHINE_NAME, string2);
            hashtable.put(PASSWORD, Boolean.toString(bl));
            String string3 = null;
            string3 = bl ? string2 + "_PW." + string : string2 + "." + string;
            ServiceInfo serviceInfo = new ServiceInfo(string, string3, n, n2, n3, hashtable);
            return serviceInfo;
        }

        public void registerService() throws IOException {
            if (this.isRegistered()) {
                throw new IOException();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.serviceInfo = serviceInfo;
        }

        public void unregisterService() {
            if (!this.isRegistered()) {
                return;
            }
            this.zeroConf.unregisterService(this.serviceInfo);
            this.serviceInfo = null;
        }

        public void updateService() throws IOException {
            if (!this.isRegistered()) {
                throw new IOException();
            }
            if (this.serviceInfo.getPort() != DaapSettings.DAAP_PORT.getValue()) {
                this.unregisterService();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.serviceInfo = serviceInfo;
        }

        public void close() {
            this.unregisterService();
            this.zeroConf.close();
        }
    }

    private final class LimeConfig
    extends DaapConfig {
        private InetAddress addr;

        public LimeConfig(InetAddress inetAddress) {
            this.addr = inetAddress;
            DaapSettings.DAAP_PORT.revertToDefault();
        }

        public String getServerName() {
            return LimeWireUtils.getHttpServer();
        }

        public void nextPort() {
            int n = DaapSettings.DAAP_PORT.getValue();
            DaapSettings.DAAP_PORT.setValue(n + 1);
        }

        public int getBacklog() {
            return 0;
        }

        public InetSocketAddress getInetSocketAddress() {
            int n = DaapSettings.DAAP_PORT.getValue();
            return new InetSocketAddress(this.addr, n);
        }

        public int getMaxConnections() {
            return DaapSettings.DAAP_MAX_CONNECTIONS.getValue();
        }
    }

    private final class LimeFilter
    implements DaapFilter {
        private LimeFilter() {
        }

        public boolean accept(InetAddress inetAddress) {
            try {
                if (!GuiCoreMediator.getNetworkInstanceUtils().isVeryCloseIP(inetAddress) && GuiCoreMediator.getNetworkInstanceUtils().isPrivateAddress(inetAddress)) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error(illegalArgumentException);
                return false;
            }
            return GuiCoreMediator.getIpFilter().allow(inetAddress.getAddress());
        }
    }

    private final class LimeAuthenticator
    implements DaapAuthenticator {
        private LimeAuthenticator() {
        }

        public byte[] getPassword(String string, Object object) {
            String string2 = DaapSettings.DAAP_PASSWORD.getValue();
            if (string2.startsWith("MD5/")) {
                string2 = string2.substring(4);
            }
            return DaapUtil.parseHexString(string2);
        }

        public boolean authenticate(String string, String string2, String string3, String string4) {
            if (string3 == null && string4 == null) {
                return DaapSettings.DAAP_PASSWORD.equals(string2);
            }
            if (string3 != null && string4 != null) {
                String string5 = DaapSettings.DAAP_PASSWORD.getValue();
                if (string5.startsWith("MD5/")) {
                    string5 = string5.substring(4);
                }
                String string6 = DaapUtil.calculateHA2(string3);
                String string7 = DaapUtil.digest(string5, string6, string4);
                return string7.equalsIgnoreCase(string2);
            }
            if (LOG.isErrorEnabled()) {
                LOG.error("Unknown scheme!");
            }
            return false;
        }
    }

    private final class LimeStreamSource
    implements DaapStreamSource {
        private LimeStreamSource() {
        }

        public Object getSource(Song song) throws IOException {
            FileDesc fileDesc = (FileDesc)song.getAttachment();
            if (fileDesc != null) {
                return new FileInputStream(fileDesc.getFile());
            }
            return null;
        }
    }
}

