/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.AzureusStarter;
import com.frostwire.gnutella.connectiondoctor.ConnectionDoctor;
import com.frostwire.gnutella.gui.chat.ChatMediator;
import com.google.inject.Provider;
import com.limegroup.bittorrent.gui.TorrentUploadCanceller;
import com.limegroup.gnutella.bugs.FatalBugManager;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.JavaVersionNotice;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.LimeJFrame;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.TipOfTheDayMessages;
import com.limegroup.gnutella.gui.TrayPopupMenu;
import com.limegroup.gnutella.gui.UpgradeWindow;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.shell.LimeAssociations;
import com.limegroup.gnutella.gui.shell.ShellAssociationManager;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tabs.LibraryPlayListTab;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.LaunchException;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.LogUtils;
import com.limegroup.gnutella.version.UpdateInformation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.Connectable;
import org.limewire.service.ErrorService;
import org.limewire.service.Switch;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringSetting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.VersionUtils;

public final class GUIMediator {
    private static final int STABLE_THRESHOLD = 5;
    private static boolean _displayedMessage;
    private static final String DISCONNECTED_MESSAGE;
    private static GUIMediator _instance;
    private static boolean HAS_DONATED;
    private static final JFrame FRAME;
    private static final JPopupMenu TRAY_MENU;
    private static final List<RefreshListener> REFRESH_LIST;
    private final String APP_TITLE = I18n.tr("FrostWire: Share it with your friends");
    private static OptionsMediator _optionsMediator;
    private static final Provider<ShellAssociationManager> ASSOCIATION_MANAGER;
    private final MainFrame MAIN_FRAME = new MainFrame(FRAME);
    private final DownloadMediator DOWNLOAD_MEDIATOR = this.MAIN_FRAME.getDownloadMediator();
    private final UploadMediator UPLOAD_MEDIATOR = this.MAIN_FRAME.getUploadMediator();
    private final ConnectionMediator CONNECTION_MEDIATOR = this.MAIN_FRAME.getConnectionMediator();
    private final LibraryMediator LIBRARY_MEDIATOR = this.MAIN_FRAME.getLibraryMediator();
    private final ChatMediator CHAT_MEDIATOR = this.MAIN_FRAME.getChatMediator();
    private final StatusLine STATUS_LINE = this.MAIN_FRAME.getStatusLine();
    private static boolean _visibleOnce;
    private static boolean _allowVisible;
    private long lastIdleTime = 0L;

    public static boolean isBrowserCapable() {
        return OSUtils.isWindows();
    }

    private GUIMediator() {
        FRAME.setTitle(this.APP_TITLE);
        _optionsMediator = this.MAIN_FRAME.getOptionsMediator();
    }

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    public static boolean isConstructed() {
        return _instance != null;
    }

    public void coreInitialized() {
        this.startTimer();
        this.createEventListeners();
        new ConnectionDoctor().initialize();
    }

    private final void startTimer() {
        RefreshTimer refreshTimer = new RefreshTimer();
        refreshTimer.startTimer();
    }

    private void createEventListeners() {
        TorrentUploadCanceller.createAndRegister(GuiCoreMediator.getTorrentManager());
    }

    public static final boolean isAppVisible() {
        return FRAME.isShowing();
    }

    public static final void setAppVisible(final boolean bl) {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                block17: {
                    try {
                        if (bl) {
                            FRAME.toFront();
                        }
                        FRAME.setVisible(bl);
                    }
                    catch (NullPointerException nullPointerException) {
                        System.out.println("GUIMediator - NULL POINTER EXCEPTION HAPPENED");
                        if (OSUtils.isNativeThemeWindows()) {
                            try {
                                if (ThemeSettings.isWindowsTheme()) {
                                    ThemeMediator.changeTheme(ThemeSettings.FROSTWIRE_THEME_FILE);
                                    try {
                                        if (bl) {
                                            FRAME.toFront();
                                        }
                                        FRAME.setVisible(bl);
                                    }
                                    catch (NullPointerException nullPointerException2) {
                                        GUIMediator.showError(I18n.tr("FrostWire has encountered a problem during startup and cannot proceed. You may be able to fix this problem by changing FrostWire's Windows Compatibility. Right-click on the FrostWire icon on your Desktop and select 'Properties' from the popup menu. Click the 'Compatibility' tab at the top, then click the 'Run this program in compatibility mode for' check box, and then select 'Windows 2000' in the box below the check box. Then click the 'OK' button at the bottom and restart FrostWire."));
                                        System.exit(0);
                                    }
                                }
                                GUIMediator.showError(I18n.tr("FrostWire has encountered a problem during startup and cannot proceed. You may be able to fix this problem by changing FrostWire's Windows Compatibility. Right-click on the FrostWire icon on your Desktop and select 'Properties' from the popup menu. Click the 'Compatibility' tab at the top, then click the 'Run this program in compatibility mode for' check box, and then select 'Windows 2000' in the box below the check box. Then click the 'OK' button at the bottom and restart FrostWire."));
                                System.exit(0);
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    FatalBugManager.handleFatalBug(nullPointerException);
                                    break block17;
                                }
                                ErrorService.error(nullPointerException);
                            }
                        }
                        if (bl) {
                            FatalBugManager.handleFatalBug(nullPointerException);
                        } else {
                            ErrorService.error(nullPointerException);
                        }
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            FatalBugManager.handleFatalBug(throwable);
                        }
                        ErrorService.error(throwable);
                    }
                }
                if (bl) {
                    SearchMediator.requestSearchFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FRAME.getContentPane().invalidate();
                            FRAME.getContentPane().validate();
                        }
                    });
                }
                if (bl && !_visibleOnce) {
                    GUIMediator.showDialogsForFirstVisibility();
                    _visibleOnce = true;
                }
            }
        });
    }

    private static final void showDialogsForFirstVisibility() {
        JDialog jDialog;
        if (_displayedMessage) {
            return;
        }
        _displayedMessage = true;
        GUIMediator.getAssociationManager().checkAndGrab(true);
        if (!GUIMediator.hasDonated()) {
            UpgradeWindow.showProDialog();
        }
        if (TipOfTheDayMessages.hasLocalizedMessages() && StartupSettings.SHOW_TOTD.getValue()) {
            TipOfTheDayMediator.instance();
            ThreadExecutor.startThread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TipOfTheDayMediator.instance().displayTipWindow();
                        }
                    });
                }
            }, "TOTD");
        }
        if ((jDialog = JavaVersionNotice.getUpgradeRecommendedDialog(VersionUtils.getJavaVersion())) != null) {
            jDialog.setVisible(true);
        }
    }

    public static void closeStartupDialogs() {
        if (SplashWindow.instance().isShowing()) {
            SplashWindow.instance().toBack();
        }
        if (TipOfTheDayMediator.isConstructed()) {
            TipOfTheDayMediator.instance().hide();
        }
    }

    public static final Dimension getAppSize() {
        return FRAME.getSize();
    }

    public static final Point getAppLocation() {
        return FRAME.getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public static final JFrame getAppFrame() {
        return FRAME;
    }

    public static final JPopupMenu getTrayMenu() {
        return TRAY_MENU;
    }

    public StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    public final void refreshGUI() {
        int n;
        for (n = 0; n < REFRESH_LIST.size(); ++n) {
            try {
                REFRESH_LIST.get(n).refresh();
                continue;
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
        n = GuiCoreMediator.getFileManager().getNumFiles();
        int n2 = GuiCoreMediator.getFileManager().getNumPendingFiles();
        int n3 = this.getConnectionQuality();
        this.STATUS_LINE.setStatistics(n, n2);
        if (n3 != 0 && n3 != 1) {
            GUIMediator.hideDisposableMessage(DISCONNECTED_MESSAGE);
        }
        this.updateConnectionUI(n3);
    }

    public int getConnectionQuality() {
        int n;
        int n2;
        int n3 = GuiCoreMediator.getConnectionServices().countConnectionsWithNMessages(5);
        if (n3 == 0) {
            n2 = this.CONNECTION_MEDIATOR.getConnectingCount();
            int n4 = GuiCoreMediator.getConnectionServices().getNumInitializedConnections();
            n = n2 == 0 && n4 == 0 ? (!GuiCoreMediator.getConnectionServices().isConnecting() ? 0 : 1) : (n4 == 0 ? 1 : 2);
        } else if (GuiCoreMediator.getConnectionManager().isConnectionIdle()) {
            this.lastIdleTime = System.currentTimeMillis();
            n = 7;
        } else {
            double d;
            n2 = GuiCoreMediator.getConnectionManager().getPreferredConnectionCount();
            if (LimeWireUtils.isPro()) {
                n2 -= 2;
            }
            if (GuiCoreMediator.getConnectionServices().isSupernode()) {
                n2 -= 5;
            }
            n = (d = (double)n3 / (double)(n2 = Math.max(1, n2))) <= 0.25 ? 2 : (d <= 0.5 ? 3 : (d <= 0.75 ? 4 : (d <= 1.0 ? 5 : 6)));
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                long l = System.currentTimeMillis();
                if (l >= this.lastIdleTime + 15000L) break;
                n = 8;
            }
        }
        return n;
    }

    public void setOptionsVisible(boolean bl) {
        if (_optionsMediator == null) {
            return;
        }
        _optionsMediator.setOptionsVisible(bl);
    }

    public void setOptionsVisible(boolean bl, String string) {
        if (_optionsMediator == null) {
            return;
        }
        _optionsMediator.setOptionsVisible(bl, string);
    }

    public static boolean isOptionsVisible() {
        if (_optionsMediator == null) {
            return false;
        }
        return _optionsMediator.isOptionsVisible();
    }

    public static Component getMainOptionsComponent() {
        if (_optionsMediator == null) {
            return null;
        }
        return _optionsMediator.getMainOptionsComponent();
    }

    public static ShellAssociationManager getAssociationManager() {
        return ASSOCIATION_MANAGER.get();
    }

    public void setWindow(Tabs tabs) {
        this.MAIN_FRAME.setSelectedTab(tabs);
    }

    public void updateTabIcon(Tabs tabs) {
        this.MAIN_FRAME.updateTabIcon(tabs);
    }

    public void clearConnections() {
        this.CONNECTION_MEDIATOR.clearConnections();
    }

    private void updateConnectionUI(int n) {
        boolean bl;
        this.STATUS_LINE.setConnectionQuality(n);
        boolean bl2 = bl = n != 0;
        if (!bl) {
            this.setSearching(false);
        }
    }

    public int getTotalUploads() {
        return this.UPLOAD_MEDIATOR.getTotalUploads();
    }

    public int getCurrentUploads() {
        return this.UPLOAD_MEDIATOR.getCurrentUploads();
    }

    public final int getTotalDownloads() {
        return this.DOWNLOAD_MEDIATOR.getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return this.DOWNLOAD_MEDIATOR.getCurrentDownloads();
    }

    public final void openTorrent(File file) {
        this.DOWNLOAD_MEDIATOR.openTorrent(file);
        this.setWindow(Tabs.SEARCH);
    }

    public final void openTorrentURI(URI uRI) {
        this.DOWNLOAD_MEDIATOR.openTorrentURI(uRI);
        this.setWindow(Tabs.SEARCH);
    }

    public final void addSharedLibraryFolder() {
        this.LIBRARY_MEDIATOR.addSharedLibraryFolder();
    }

    public static PlaylistMediator getPlayList() {
        return MainFrame.getPlaylistMediator();
    }

    public static boolean isPlaylistVisible() {
        if (!GUIMediator.isConstructed()) {
            return PlayerSettings.PLAYER_ENABLED.getValue();
        }
        return GUIMediator.getPlayList() != null && PlayerSettings.PLAYER_ENABLED.getValue();
    }

    public static void startupHidden() {
        GUIMediator.showTrayIcon();
        if (OSUtils.isMacOSX()) {
            GUIMediator.hideView();
        }
    }

    public static void allowVisibility() {
        if (!_allowVisible && OSUtils.isAnyMac()) {
            MacEventHandler.instance().enablePreferences();
        }
        _allowVisible = true;
    }

    public void loadFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread thread = Thread.currentThread();
                thread.setPriority(thread.getPriority() + 1);
                GUIMediator.this.STATUS_LINE.loadFinished();
            }
        });
    }

    public static void handleReopen() {
        if (_allowVisible) {
            if (!_visibleOnce) {
                GUIMediator.restoreView();
            }
            GUIMediator.setAppVisible(true);
        }
    }

    public static void hideView() {
        FRAME.setState(1);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            GUIMediator.setAppVisible(false);
        }
    }

    public static void restoreView() {
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            boolean bl = false;
            if (!_visibleOnce) {
                bl = true;
            }
            GUIMediator.setAppVisible(true);
            if (ApplicationSettings.DISPLAY_TRAY_ICON.getValue()) {
                GUIMediator.showTrayIcon();
            } else {
                GUIMediator.hideTrayIcon();
            }
            if (bl) {
                GUIMediator.restoreView();
            }
        }
        Finalizer.cancelShutdown();
        FRAME.setState(0);
    }

    public static void close(boolean bl) {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            if (OSUtils.supportsTray() && !ResourceManager.instance().isTrayIconAvailable()) {
                GUIMediator.shutdownAfterTransfers();
            } else {
                GUIMediator.applyWindowSettings();
                GUIMediator.showTrayIcon();
                GUIMediator.hideView();
            }
        } else if (OSUtils.isMacOSX() && bl) {
            GUIMediator.setAppVisible(false);
        } else if (ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue()) {
            GUIMediator.shutdownAfterTransfers();
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        Finalizer.shutdown();
    }

    public static void shutdownAfterTransfers() {
        Finalizer.shutdownAfterTransfers();
        GUIMediator.hideView();
    }

    public static void flagUpdate(String string) {
        Finalizer.flagUpdate(string);
    }

    public static final void showAboutWindow() {
        new AboutWindow().showDialog();
    }

    public static void showTrayIcon() {
        NotifyUserProxy.instance().showTrayIcon();
    }

    public static void hideTrayIcon() {
        NotifyUserProxy.instance().hideTrayIcon();
    }

    public static void applyWindowSettings() {
        ApplicationSettings.RUN_ONCE.setValue(true);
        if (GUIMediator.isAppVisible()) {
            if ((GUIMediator.getAppFrame().getExtendedState() & 6) == 6) {
                ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            } else {
                Dimension dimension = GUIMediator.getAppSize();
                if (dimension.height > 100 && dimension.width > 100) {
                    Point point = GUIMediator.getAppLocation();
                    ApplicationSettings.APP_WIDTH.setValue(dimension.width);
                    ApplicationSettings.APP_HEIGHT.setValue(dimension.height);
                    ApplicationSettings.WINDOW_X.setValue(point.x);
                    ApplicationSettings.WINDOW_Y.setValue(point.y);
                }
            }
        }
    }

    public static final ImageIcon getThemeImage(String string) {
        return ResourceManager.getThemeImage(string);
    }

    public static final ImageIcon getImageFromResourcePath(String string) {
        return ResourceManager.getImageFromResourcePath(string);
    }

    public static URL getURLResource(String string) {
        return ResourceManager.getURLResource(string);
    }

    public static void resetLocale() {
        ResourceManager.resetLocaleOptions();
        GUIUtils.resetLocale();
    }

    public static final ResourceBundle getXMLResourceBundle(String string) {
        return ResourceManager.getXMLResourceBundle(string);
    }

    public static final String showInputMessage(String string, String string2) {
        return MessageService.instance().showInputMessage(string, string2);
    }

    public static final DialogOption showYesNoMessage(String string, DialogOption dialogOption) {
        return MessageService.instance().showYesNoMessage(string, dialogOption);
    }

    public static final DialogOption showYesNoMessage(String string, IntSetting intSetting, DialogOption dialogOption) {
        return MessageService.instance().showYesNoMessage(string, intSetting, dialogOption);
    }

    public static final DialogOption showYesNoTitledMessage(String string, String string2, DialogOption dialogOption) {
        return MessageService.instance().showYesNoMessage(string, string2, dialogOption);
    }

    public static final int showConfirmListMessage(String string, Object[] objectArray, int n, ListCellRenderer listCellRenderer) {
        return MessageService.instance().showConfirmListMessage(string, objectArray, n, listCellRenderer);
    }

    public static final DialogOption showYesNoOtherMessage(String string, IntSetting intSetting, String string2) {
        return MessageService.instance().showYesNoOtherMessage(string, intSetting, string2);
    }

    public static final DialogOption showYesNoCancelMessage(String string) {
        return MessageService.instance().showYesNoCancelMessage(string);
    }

    public static final DialogOption showYesNoCancelMessage(String string, IntSetting intSetting) {
        return MessageService.instance().showYesNoCancelMessage(string, intSetting);
    }

    public static final void showMessage(String string) {
        MessageService.instance().showMessage(string);
    }

    public static final void showMessage(String string, Switch switch_) {
        MessageService.instance().showMessage(string, switch_);
    }

    public static final void showDisposableMessage(String string, String string2, Switch switch_, int n) {
        MessageService.instance().showDisposableMessage(string, string2, switch_, n);
    }

    public static final void hideDisposableMessage(String string) {
        MessageService.instance().hideDisposableMessage(string);
    }

    public static final void showConfirmMessage(String string) {
        MessageService.instance().showConfirmMessage(string);
    }

    public static final void showConfirmMessage(String string, Switch switch_) {
        MessageService.instance().showConfirmMessage(string, switch_);
    }

    public static final void showError(String string) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(string);
    }

    public static final void showError(String string, Switch switch_) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(string, switch_);
    }

    public static final void showWarning(String string, Switch switch_) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showWarning(string, switch_);
    }

    public static final void showWarning(String string) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showWarning(string);
    }

    public static final int openURL(String string) {
        try {
            return Launcher.openURL(string);
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("FrostWire could not locate your web browser to display the following webpage: {0}.", string));
            return -1;
        }
    }

    public static final void launchFile(File file) {
        try {
            Launcher.launchFile(file);
        }
        catch (SecurityException securityException) {
            GUIMediator.showError(I18n.tr("FrostWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException launchException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(launchException.getCommand(), " ")));
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file."));
        }
    }

    public static final void launchExplorer(File file) {
        try {
            Launcher.launchExplorer(file);
        }
        catch (SecurityException securityException) {
            GUIMediator.showError(I18n.tr("FrostWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException launchException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(launchException.getCommand(), " ")));
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file."));
        }
    }

    public static final Component getHorizontalSeparator() {
        return Box.createRigidArea(new Dimension(6, 0));
    }

    public static final Component getVerticalSeparator() {
        return Box.createRigidArea(new Dimension(0, 6));
    }

    public void connect() {
        GuiCoreMediator.getConnectionServices().connect();
        GuiCoreMediator.getDHTManager().setEnabled(true);
    }

    public void disconnect() {
        GuiCoreMediator.getConnectionServices().disconnect();
        GuiCoreMediator.getDHTManager().setEnabled(false);
    }

    public static void disconnected() {
        GUIMediator.showDisposableMessage(DISCONNECTED_MESSAGE, I18n.tr("Your machine does not appear to have an active Internet connection or a firewall is blocking FrostWire from accessing the internet. FrostWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu."), QuestionsHandler.NO_INTERNET_RETRYING, 0);
    }

    public static boolean hasDonated() {
        return HAS_DONATED;
    }

    public void setTabVisible(Tabs tabs, boolean bl) {
        this.MAIN_FRAME.setTabVisible(tabs, bl);
    }

    public static void setSplashScreenString(String string) {
        if (!_allowVisible) {
            SplashWindow.instance().setStatusText(string);
        } else if (GUIMediator.isConstructed()) {
            GUIMediator.instance().STATUS_LINE.setStatusText(string);
        }
    }

    public static Point getScreenCenterPoint(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(dimension2.width, dimension.width);
        int n2 = Math.min(dimension2.height - 40, dimension.height);
        return new Point((dimension2.width - n) / 2, (dimension2.height - n2) / 2);
    }

    public static void addFinalizeListener(FinalizeListener finalizeListener) {
        Finalizer.addFinalizeListener(finalizeListener);
    }

    public void setSearching(boolean bl) {
        this.MAIN_FRAME.setSearching(bl);
    }

    public static void addRefreshListener(RefreshListener refreshListener) {
        if (!REFRESH_LIST.contains(refreshListener)) {
            REFRESH_LIST.add(refreshListener);
        }
    }

    public static void removeRefreshListener(RefreshListener refreshListener) {
        REFRESH_LIST.remove(refreshListener);
    }

    public static Locale getLocale() {
        return ResourceManager.getLocale();
    }

    public static boolean isEnglishLocale() {
        return LanguageUtils.isEnglishLocale(GUIMediator.getLocale());
    }

    public void launchAudio(PlayListItem playListItem) {
        this.launchAudio(playListItem, true);
    }

    public void launchAudio(PlayListItem playListItem, boolean bl) {
        ThemeObserver themeObserver;
        if (MediaPlayerComponent.getInstance().getCurrentSong() != null) {
            try {
                MediaPlayerComponent.getInstance().stopSong();
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            themeObserver = PlaylistMediator.getInstance();
            ((AbstractTableMediator)themeObserver).add(playListItem, ((AbstractTableMediator)themeObserver).getSize());
            ((PlaylistMediator)themeObserver).setSelectedIndex(playListItem);
        }
        themeObserver = MediaPlayerComponent.getInstance();
        ((MediaPlayerComponent)themeObserver).loadSong(playListItem, !bl);
    }

    public boolean attemptStopAudio() {
        MediaPlayerComponent mediaPlayerComponent = MediaPlayerComponent.getInstance();
        mediaPlayerComponent.stopSong();
        return true;
    }

    public void showUpdateNotification(final UpdateInformation updateInformation) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                GUIMediator.this.STATUS_LINE.showUpdatePanel(true, updateInformation);
            }
        });
    }

    public byte[] triggerSearch(String string) {
        this.MAIN_FRAME.setSelectedTab(Tabs.SEARCH);
        return SearchMediator.triggerSearch(string);
    }

    public void buttonViewChanged() {
        IconManager.instance().wipeButtonIconCache();
        this.updateButtonView(FRAME);
    }

    public void smileysChanged(boolean bl) {
        ChatMediator.instance().changesmileys(bl);
        this.updateButtonView(FRAME);
    }

    private void updateButtonView(Component component) {
        if (component instanceof IconButton) {
            ((IconButton)component).updateUI();
        }
        Component[] componentArray = null;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.updateButtonView(componentArray[i]);
            }
        }
    }

    public void doBrowseHost(Connectable connectable) {
        this.MAIN_FRAME.setSelectedTab(Tabs.SEARCH);
        SearchMediator.doBrowseHost(connectable, null);
    }

    public static void safeInvokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                ErrorService.error(throwable);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void safeInvokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setPlayerEnabled(boolean bl) {
        if (bl == PlayerSettings.PLAYER_ENABLED.getValue()) {
            return;
        }
        PlayerSettings.PLAYER_ENABLED.setValue(bl);
        this.getStatusLine().refresh();
        this.LIBRARY_MEDIATOR.setPlayerEnabled(bl);
        LibraryPlayListTab.setPlayerEnabled(bl);
    }

    public void tryToStartAndAddChat() {
        this.CHAT_MEDIATOR.tryToStartAndAddChat();
    }

    public void setIRCNick(String string) {
        this.CHAT_MEDIATOR.nick(string);
    }

    public void setFrameCursor(Cursor cursor) {
        FRAME.setCursor(cursor);
    }

    public static ChatFrame createChat(String string, int n) {
        InstantMessenger instantMessenger = GuiCoreMediator.getChatManager().createConnection(string, n);
        ChatFrame chatFrame = ChatUIManager.instance().acceptChat(instantMessenger);
        instantMessenger.start();
        return chatFrame;
    }

    public void openTorrentMagnet(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.setSplashScreenString("Fetching .torrent from the DHT...");
            }
        });
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    GUIMediator.this.azureusInit();
                    final CountDownLatch countDownLatch = new CountDownLatch(1);
                    TorrentDownloader torrentDownloader = TorrentDownloaderFactory.create(new TorrentDownloaderCallBackInterface(){

                        public void TorrentDownloaderEvent(int n, TorrentDownloader torrentDownloader) {
                            if (n == 3) {
                                countDownLatch.countDown();
                                GUIMediator.instance().getStatusLine().setStatusText("Done");
                            }
                        }
                    }, string, null, SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.getCanonicalPath());
                    torrentDownloader.start();
                    if (!countDownLatch.await(1L, TimeUnit.MINUTES)) {
                        throw new TimeoutException("Error downloading torrent magnet");
                    }
                    GUIMediator.instance().openTorrent(torrentDownloader.getFile());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
        ThreadExecutor.startThread(runnable, "MagnetTorrentFetcher");
    }

    private void azureusInit() {
        AzureusStarter.start();
    }

    static {
        DISCONNECTED_MESSAGE = I18nMarker.marktr("Your machine does not appear to have an active Internet connection or a firewall is blocking FrostWire from accessing the internet. FrostWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu.");
        _instance = null;
        HAS_DONATED = true;
        FRAME = new LimeJFrame();
        TRAY_MENU = new TrayPopupMenu();
        REFRESH_LIST = new ArrayList<RefreshListener>();
        ASSOCIATION_MANAGER = new AbstractLazySingletonProvider<ShellAssociationManager>(){

            @Override
            protected ShellAssociationManager createObject() {
                return new ShellAssociationManager(LimeAssociations.getSupportedAssociations());
            }
        };
        _visibleOnce = false;
        _allowVisible = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tabs {
        SEARCH(I18n.tr("&Search")),
        MONITOR(I18n.tr("&Monitor"), ApplicationSettings.MONITOR_VIEW_ENABLED),
        CONNECTION(I18n.tr("&Connections"), ApplicationSettings.CONNECTION_VIEW_ENABLED),
        LIBRARY(I18n.tr("&Library"), ApplicationSettings.LIBRARY_VIEW_ENABLED),
        CHAT(I18n.tr("Community C&hat"), ApplicationSettings.CHAT_VIEW_ENABLED),
        LOGGING(I18n.tr("Lo&gging"), ApplicationSettings.LOGGING_VIEW_ENABLED),
        FROSTCLICK(I18n.tr("FrostClick.com"), ApplicationSettings.SWT_BROWSER_VIEW_ENABLED, "http://www.frostclick.com/?from=frostwire&");

        private Action navAction;
        private Action showTabAction;
        private String name;
        private final BooleanSetting visibleSetting;
        private final PropertyChangeSupport propertyChangeSupport;
        private static Tabs[] OPTIONAL_TABS;

        private Tabs(String string2) {
            this(string2, null);
        }

        private Tabs(String string2, BooleanSetting booleanSetting) {
            this.name = GUIUtils.stripAmpersand(string2);
            this.navAction = new NavigationAction(string2, I18n.tr("Display the {0} Screen", this.name));
            this.visibleSetting = booleanSetting;
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
            this.showTabAction = new ShowTabAction(this);
        }

        private Tabs(StringSetting stringSetting, BooleanSetting booleanSetting) {
            this(stringSetting.getValue(), booleanSetting);
            stringSetting.addSettingListener(new SettingListener(){

                public void settingChanged(final SettingEvent settingEvent) {
                    if (settingEvent.getEventType() == SettingEvent.EventType.VALUE_CHANGED) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Tabs.this.setName(settingEvent.getSetting().getValueAsString());
                            }
                        });
                    }
                }
            });
        }

        private Tabs(String string2, BooleanSetting booleanSetting, String string3) {
            this(string2, booleanSetting);
            this.navAction = new BrowseAction(string2, string3);
        }

        void setName(String string) {
            String string2 = this.name;
            this.name = GUIUtils.stripAmpersand(string);
            this.navAction.putValue("Name", string);
            this.navAction.putValue("LongDescription", I18n.tr("Display the {0} Screen", this.name));
            this.propertyChangeSupport.firePropertyChange("name", string2, this.name);
            this.showTabAction.putValue("Name", string);
            this.showTabAction.putValue("LongDescription", I18n.tr("Toggle the {0} Screen", this.name));
        }

        void setEnabled(boolean bl) {
            this.navAction.setEnabled(bl);
        }

        public Action getNavigationAction() {
            return this.navAction;
        }

        public Action getShowTabAction() {
            return this.showTabAction;
        }

        public boolean isViewEnabled() {
            if (this.visibleSetting == null) {
                throw new IllegalStateException("Should not be called on " + this.getName() + " which is a non-optional tab");
            }
            return this.visibleSetting.getValue();
        }

        public String getName() {
            return this.name;
        }

        public static Tabs[] getOptionalTabs() {
            if (OPTIONAL_TABS != null) {
                return OPTIONAL_TABS;
            }
            OPTIONAL_TABS = LogUtils.isLog4JAvailable() ? (GUIMediator.isBrowserCapable() ? new Tabs[]{MONITOR, CONNECTION, LIBRARY, LOGGING, CHAT} : new Tabs[]{MONITOR, CONNECTION, LIBRARY, LOGGING, CHAT}) : (GUIMediator.isBrowserCapable() ? new Tabs[]{MONITOR, CONNECTION, LIBRARY, LOGGING, CHAT} : new Tabs[]{MONITOR, CONNECTION, LIBRARY, LOGGING, CHAT});
            return OPTIONAL_TABS;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        static {
            OPTIONAL_TABS = null;
        }

        private class BrowseAction
        extends AbstractAction {
            private String url;

            public BrowseAction(String string, String string2) {
                super(string);
                this.url = string2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                byte[] byArray = GuiCoreMediator.getApplicationServices().getMyGUID();
                GUIMediator.openURL(LimeWireUtils.addLWInfoToUrl(this.url, byArray));
            }
        }

        private class NavigationAction
        extends AbstractAction {
            public NavigationAction(String string, String string2) {
                super(string);
                this.putValue("LongDescription", string2);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().setWindow(Tabs.this);
            }
        }

        private class ShowTabAction
        extends AbstractAction {
            private final Tabs tab;

            private ShowTabAction(Tabs tabs2) {
                super(tabs2.getName());
                this.putValue("LongDescription", I18n.tr("Show {0} Window", tabs2.getName()));
                this.tab = tabs2;
                tabs2.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("name".equals(propertyChangeEvent.getPropertyName())) {
                            ShowTabAction.this.putValue("Name", propertyChangeEvent.getNewValue());
                            ShowTabAction.this.putValue("LongDescription", I18n.tr("Show {0} Window", propertyChangeEvent.getNewValue()));
                        }
                    }
                });
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                GUIMediator.instance().setTabVisible(this.tab, abstractButton.isSelected());
                GUIMediator.instance().setWindow(this.tab);
                GUIMediator.instance().getMainFrame().getMenuMediator().refreshShowHideSubMenu();
            }
        }
    }
}

