/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class GUIUtils {
    private static final Log LOG = LogFactory.getLog(GUIUtils.class);
    private static NumberFormat NUMBER_FORMAT0;
    private static NumberFormat NUMBER_FORMAT1;
    private static DateFormat DATETIME_FORMAT;
    private static DateFormat FULL_DATETIME_FORMAT;
    public static String GENERAL_UNIT_KILOBYTES;
    public static String GENERAL_UNIT_MEGABYTES;
    public static String GENERAL_UNIT_GIGABYTES;
    public static String GENERAL_UNIT_TERABYTES;
    public static String GENERAL_UNIT_KBPSEC;
    public static final HyperlinkListener HYPER_LISTENER;
    public static Action ACTION_DISPOSE;

    private GUIUtils() {
    }

    static void resetLocale() {
        NUMBER_FORMAT0 = NumberFormat.getNumberInstance(GUIMediator.getLocale());
        NUMBER_FORMAT0.setMaximumFractionDigits(0);
        NUMBER_FORMAT0.setMinimumFractionDigits(0);
        NUMBER_FORMAT0.setGroupingUsed(true);
        NUMBER_FORMAT1 = NumberFormat.getNumberInstance(GUIMediator.getLocale());
        NUMBER_FORMAT1.setMaximumFractionDigits(1);
        NUMBER_FORMAT1.setMinimumFractionDigits(1);
        NUMBER_FORMAT1.setGroupingUsed(true);
        DATETIME_FORMAT = DateFormat.getDateTimeInstance(2, 2, GUIMediator.getLocale());
        FULL_DATETIME_FORMAT = new SimpleDateFormat("EEE, MMM. d, yyyy h:mm a", GUIMediator.getLocale());
        GENERAL_UNIT_KILOBYTES = I18n.tr("KB");
        GENERAL_UNIT_MEGABYTES = I18n.tr("MB");
        GENERAL_UNIT_GIGABYTES = I18n.tr("GB");
        GENERAL_UNIT_TERABYTES = I18n.tr("TB");
        GENERAL_UNIT_KBPSEC = I18n.tr("KB/s");
    }

    public static String toLocalizedInteger(long l) {
        return NUMBER_FORMAT0.format(l);
    }

    public static String toKilobytes(long l) {
        if (l < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        long l2 = l / 1024L;
        if ((l & 0x200L) != 0L || l > 0L && l < 1024L) {
            ++l2;
        }
        return NUMBER_FORMAT0.format(l2) + GENERAL_UNIT_KILOBYTES;
    }

    public static String toUnitbytes(long l) {
        String string;
        long l2;
        if (l < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        if (l < 0xA00000L) {
            l2 = 1024L;
            string = GENERAL_UNIT_KILOBYTES;
        } else if (l < 0x280000000L) {
            l2 = 0x100000L;
            string = GENERAL_UNIT_MEGABYTES;
        } else if (l < 0xA0000000000L) {
            l2 = 0x40000000L;
            string = GENERAL_UNIT_GIGABYTES;
        } else {
            l2 = 0x10000000000L;
            string = GENERAL_UNIT_TERABYTES;
        }
        NumberFormat numberFormat = (double)l * 100.0 / (double)l2 < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        try {
            return numberFormat.format((double)l / (double)l2) + " " + string;
        }
        catch (ArithmeticException arithmeticException) {
            return "0 " + string;
        }
    }

    public static MultiLineLabel getSizedLabel(String string) {
        Dimension dimension = new Dimension();
        MultiLineLabel multiLineLabel = new MultiLineLabel(string);
        FontMetrics fontMetrics = multiLineLabel.getFontMetrics(multiLineLabel.getFont());
        int n = fontMetrics.stringWidth(string);
        dimension.setSize(Integer.MAX_VALUE, n / 9);
        multiLineLabel.setPreferredSize(dimension);
        return multiLineLabel;
    }

    public static String speed2name(int n) {
        if (n <= 56) {
            return GUIConstants.MODEM_SPEED;
        }
        if (n <= 350) {
            return GUIConstants.CABLE_SPEED;
        }
        if (n <= 1000) {
            return GUIConstants.T1_SPEED;
        }
        if (n == 0x7FFFFFFD) {
            return "--";
        }
        if (n < 0x7FFFFFFE) {
            return GUIConstants.T3_SPEED;
        }
        return GUIConstants.MULTICAST_SPEED;
    }

    public static String rate2speed(double d) {
        return NUMBER_FORMAT0.format(d) + " " + GENERAL_UNIT_KBPSEC;
    }

    public static String msec2DateTime(long l) {
        Date date = new Date(l);
        return DATETIME_FORMAT.format(date);
    }

    public static DateFormat getFullDateTimeFormat() {
        return FULL_DATETIME_FORMAT;
    }

    public static void setOpaque(boolean bl, JComponent jComponent) {
        jComponent.setOpaque(bl);
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent) || componentArray[i] instanceof JTextField || !ThemeSettings.isNativeOSXTheme() && componentArray[i] instanceof JButton) continue;
            ((JComponent)componentArray[i]).setOpaque(bl);
            GUIUtils.setOpaque(bl, (JComponent)componentArray[i]);
        }
    }

    public static JPanel center(JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        jPanel.add(jComponent);
        return jPanel;
    }

    public static JPanel left(JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(jComponent);
        return jPanel;
    }

    public static int width(JLabel jLabel) {
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        return fontMetrics.stringWidth(jLabel.getText()) + 3;
    }

    public static boolean canDisplay(Font font, String string) {
        int n = font.canDisplayUpTo(string);
        return n >= string.length() || n == -1;
    }

    public static void addHideAction(JDialog jDialog) {
        GUIUtils.addHideAction((JComponent)jDialog.getContentPane());
    }

    public static void addHideAction(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(1);
        inputMap.put(GUIUtils.getHideKeystroke(), "limewire.hideWindow");
        jComponent.getActionMap().put("limewire.hideWindow", GUIUtils.getDisposeAction());
    }

    public static KeyStroke getHideKeystroke() {
        if (OSUtils.isMacOSX()) {
            return KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        return KeyStroke.getKeyStroke(27, 0);
    }

    public static void bindKeyToAction(JComponent jComponent, KeyStroke keyStroke, Action action, int n) {
        InputMap inputMap = jComponent.getInputMap(n);
        ActionMap actionMap = jComponent.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, action);
            actionMap.put(action, action);
        }
    }

    public static void bindKeyToAction(JComponent jComponent, KeyStroke keyStroke, Action action) {
        GUIUtils.bindKeyToAction(jComponent, keyStroke, action, 0);
    }

    public static Action getDisposeAction() {
        if (ACTION_DISPOSE == null) {
            ACTION_DISPOSE = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Window window = actionEvent.getSource() instanceof Window ? (Window)actionEvent.getSource() : SwingUtilities.getWindowAncestor((Component)actionEvent.getSource());
                    if (window != null) {
                        window.dispatchEvent(new WindowEvent(window, 201));
                    }
                }
            };
        }
        return ACTION_DISPOSE;
    }

    public static void fixInputMap(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(1);
        if (OSUtils.isMacOSX()) {
            GUIUtils.replaceAction(inputMap, 'A');
            GUIUtils.replaceAction(inputMap, 'C');
            GUIUtils.replaceAction(inputMap, 'V');
            GUIUtils.replaceAction(inputMap, 'X');
        }
    }

    private static void replaceAction(InputMap inputMap, char c) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke("control pressed " + c);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("meta pressed " + c);
        if (keyStroke == null || keyStroke2 == null) {
            return;
        }
        Object object = inputMap.get(keyStroke);
        if (object != null) {
            inputMap.remove(keyStroke);
            inputMap.put(keyStroke2, object);
        }
    }

    public static HyperlinkListener getHyperlinkListener() {
        return HYPER_LISTENER;
    }

    public static MouseListener getURLInputListener(final ActionListener actionListener) {
        return new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getComponent();
                jComponent.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getComponent();
                jComponent.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                actionListener.actionPerformed(new ActionEvent(mouseEvent.getComponent(), 0, null));
            }
        };
    }

    public static MouseListener getURLInputListener(final String string) {
        return GUIUtils.getURLInputListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.openURL(string);
            }
        });
    }

    public static boolean shouldShowStartOnStartupWindow() {
        return OSUtils.isMacOSX() || WindowsUtils.isLoginStatusAvailable();
    }

    public static String convertToNonBreakingSpaces(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder(n + string.length());
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\u00a0');
        }
        stringBuilder.append(string.replace(' ', '\u00a0'));
        return stringBuilder.toString();
    }

    public static String colorToHex(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return GUIUtils.toHex(n) + GUIUtils.toHex(n2) + GUIUtils.toHex(n3);
    }

    private static String toHex(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public static Color hexToColor(String string) {
        int n = Integer.parseInt(string, 16);
        return new Color(n);
    }

    public static boolean launchOrEnqueueFile(File file, boolean bl) {
        return GUIUtils.launchFile(file, false, bl);
    }

    public static boolean launchOneTimeFile(File file) {
        return GUIUtils.launchFile(file, true, false);
    }

    private static boolean launchFile(final File file, boolean bl, boolean bl2) {
        String string = FileUtils.getFileExtension(file);
        if (string != null && string.equals("torrent")) {
            GUIMediator.instance().openTorrent(file);
            return false;
        }
        if (GUIMediator.isPlaylistVisible()) {
            if (PlaylistMediator.getInstance().openIfPlaylist(file)) {
                return false;
            }
            if (PlaylistMediator.isPlayableFile(file)) {
                if (bl) {
                    BackgroundExecutorService.schedule(new Runnable(){

                        public void run() {
                            final PlayListItem playListItem = new PlayListItem(file);
                            GUIMediator.safeInvokeAndWait(new Runnable(){

                                public void run() {
                                    GUIMediator.instance().launchAudio(playListItem, false);
                                }
                            });
                        }
                    });
                } else if (!bl2) {
                    BackgroundExecutorService.schedule(new Runnable(){

                        public void run() {
                            final PlayListItem playListItem = new PlayListItem(file);
                            GUIMediator.safeInvokeAndWait(new Runnable(){

                                public void run() {
                                    GUIMediator.instance().launchAudio(playListItem);
                                }
                            });
                        }
                    });
                } else {
                    PlaylistMediator.getInstance().addFileToPlaylist(file);
                }
                return true;
            }
        }
        GUIMediator.launchFile(file);
        return false;
    }

    public static boolean launchAndEnqueueFile(File file, boolean bl) {
        if (PlaylistMediator.isPlayableFile(file) && GUIMediator.isPlaylistVisible()) {
            GUIMediator.instance().attemptStopAudio();
            PlayListItem playListItem = new PlayListItem(file);
            GUIMediator.instance().launchAudio(playListItem);
            PlaylistMediator.getInstance().addFileToPlaylist(file);
            return true;
        }
        return GUIUtils.launchFile(file, false, bl);
    }

    public static void centerOnScreen(JDialog jDialog) {
        if (GUIMediator.isAppVisible()) {
            jDialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            jDialog.setLocation(GUIMediator.getScreenCenterPoint(jDialog));
        }
    }

    public static String restrictWidth(String string, int n) {
        return "<html><table width=\"" + n + "\"><tr><td>" + string + "</td></tr></table></html>";
    }

    public static void restrictSize(JComponent jComponent, SizePolicy sizePolicy) {
        GUIUtils.restrictSize(jComponent, sizePolicy, false);
    }

    public static void restrictSize(JComponent jComponent, SizePolicy sizePolicy, boolean bl) {
        switch (sizePolicy) {
            case RESTRICT_HEIGHT: {
                int n = jComponent.getPreferredSize().height;
                int n2 = jComponent.getPreferredSize().width;
                jComponent.setMinimumSize(new Dimension(n2, n));
                jComponent.setMaximumSize(new Dimension(Integer.MAX_VALUE, n));
                break;
            }
            case RESTRICT_BOTH: {
                int n = jComponent.getPreferredSize().height;
                int n3 = jComponent.getPreferredSize().width;
                jComponent.setMinimumSize(new Dimension(n3, n));
                jComponent.setMaximumSize(new Dimension(n3, n));
                break;
            }
            case RESTRICT_NONE: {
                jComponent.setMinimumSize(null);
                jComponent.setMaximumSize(null);
            }
        }
        if (bl) {
            jComponent.putClientProperty(SizePolicy.class, (Object)sizePolicy);
        }
    }

    public static int getCodeForCharKey(String string) {
        int n = -1;
        String string2 = string.toUpperCase(Locale.US);
        if (string2.length() > 1) {
            return -1;
        }
        try {
            Field field = KeyEvent.class.getField("VK_" + string2);
            n = field.getInt(KeyEvent.class);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOG.error("can't get key for: " + string2, noSuchFieldException);
        }
        catch (SecurityException securityException) {
            LOG.error("can't get key for: " + string2, securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("can't get key for: " + string2, illegalAccessException);
        }
        return n;
    }

    private static int getAmpersandPosition(String string) {
        int n = -1;
        while (!((n = string.indexOf(38, n + 1)) == -1 || n < string.length() - 1 && Character.isLetterOrDigit(string.charAt(n + 1)))) {
        }
        return n;
    }

    public static String stripAmpersand(String string) {
        int n = GUIUtils.getAmpersandPosition(string);
        if (n >= 0) {
            return string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    public static int getMnemonicKeyCode(String string) {
        int n = GUIUtils.getAmpersandPosition(string);
        if (n >= 0) {
            return GUIUtils.getCodeForCharKey(string.substring(n + 1, n + 2));
        }
        return -1;
    }

    static {
        HYPER_LISTENER = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                URL uRL;
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (uRL = hyperlinkEvent.getURL()) != null) {
                    GUIMediator.openURL(uRL.toExternalForm());
                }
            }
        };
        GUIUtils.resetLocale();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizePolicy {
        RESTRICT_NONE,
        RESTRICT_HEIGHT,
        RESTRICT_BOTH;

    }

    public static class EmptyIcon
    implements Icon {
        private final String name;
        private final int width;
        private final int height;

        public EmptyIcon(String string, int n, int n2) {
            this.name = string;
            this.width = n;
            this.height = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public String toString() {
            return this.name;
        }
    }
}

