/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.LimeLookAndFeel;
import com.limegroup.gnutella.gui.themes.LimePlasticTheme;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

public final class ResourceManager {
    private static ResourceManager _instance;
    private static final String GUI_PATH = "org/limewire/gui/";
    private static final String RESOURCES_PATH = "org/limewire/gui/resources/";
    private static final String IMAGES_PATH = "org/limewire/gui/images/";
    private static boolean _localeOptionsSet;
    private static Locale _locale;
    private static boolean _fontReduced;
    private static MetalTheme _defaultTheme;
    private final boolean BRUSHED_METAL;
    private final boolean LOADED_TRAY_LIBRARY;
    private final boolean LOADED_JDIC_LIBRARY;
    private static final Map<String, ImageIcon> THEME_IMAGES;
    private static boolean loadFailureEncountered;

    static void resetLocaleOptions() {
        _localeOptionsSet = false;
        ResourceManager.setLocaleOptions();
    }

    static void setLocaleOptions() {
        if (!_localeOptionsSet) {
            if (ApplicationSettings.LANGUAGE.getValue().equals("")) {
                ApplicationSettings.LANGUAGE.setValue("en");
            }
            _locale = new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue());
            StringUtils.setLocale(_locale);
            I18n.setLocale(_locale);
            _localeOptionsSet = true;
        }
    }

    static Locale getLocale() {
        return _locale;
    }

    public static boolean hasLoadFailure() {
        return loadFailureEncountered;
    }

    public static void resetLoadFailure() {
        loadFailureEncountered = false;
    }

    static ResourceBundle getXMLResourceBundle(String string) {
        return ResourceBundle.getBundle("xml.display." + string, _locale);
    }

    static final ImageIcon getThemeImage(String string) {
        if (string == null) {
            throw new NullPointerException("null image name");
        }
        ImageIcon imageIcon = null;
        imageIcon = THEME_IMAGES.get(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        File file = ThemeSettings.THEME_DIR.getValue();
        imageIcon = ResourceManager.getImageFromURL(new File(file, string).getPath(), true);
        if (imageIcon != null && imageIcon.getImage() != null) {
            THEME_IMAGES.put(string, imageIcon);
            return imageIcon;
        }
        imageIcon = ResourceManager.getImageFromURL(IMAGES_PATH + string, false);
        if (imageIcon != null && imageIcon.getImage() != null) {
            THEME_IMAGES.put(string, imageIcon);
            return imageIcon;
        }
        throw new MissingResourceException("image: " + string + " doesn't exist.", null, null);
    }

    static final ImageIcon getImageFromResourcePath(String string) {
        return ResourceManager.getImageFromURL(string, false);
    }

    private static final ImageIcon getImageFromURL(String string, boolean bl) {
        URL uRL = ResourceManager.toURL(string, bl);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        uRL = ResourceManager.toURL(string + ".png", bl);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        uRL = ResourceManager.toURL(string + ".gif", bl);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    private static final URL toURL(String string, boolean bl) {
        if (bl) {
            File file = new File(string);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            return null;
        }
        return ResourceManager.getURL(string);
    }

    static URL getURLResource(String string) {
        return ResourceManager.getURL(RESOURCES_PATH + string);
    }

    private static URL getURL(String string) {
        ClassLoader classLoader = ResourceManager.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return ClassLoader.getSystemResource(string);
        }
        return uRL;
    }

    public static final synchronized ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private ResourceManager() {
        String string;
        if (!ThemeFileHandler.isCurrent() || !ThemeSettings.isValid()) {
            ThemeSettings.THEME_FILE.revertToDefault();
            ThemeSettings.THEME_DIR.revertToDefault();
            ThemeFileHandler.reload(false);
        }
        this.BRUSHED_METAL = (string = System.getProperty("apple.awt.brushMetalLook")) != null && string.equalsIgnoreCase("true");
        this.themeChanged();
        ResourceManager.setFontSizes(ThemeSettings.FONT_SIZE_INCREMENT.getValue());
        try {
            ResourceManager.validateLocaleAndFonts(Locale.getDefault());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (OSUtils.isWindows() || OSUtils.isLinux()) {
            boolean bl = false;
            try {
                System.loadLibrary("tray");
                bl = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            this.LOADED_TRAY_LIBRARY = bl;
            bl = false;
            try {
                System.loadLibrary("jdic");
                bl = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            this.LOADED_JDIC_LIBRARY = bl;
        } else {
            this.LOADED_TRAY_LIBRARY = false;
            this.LOADED_JDIC_LIBRARY = false;
        }
    }

    public static void validateLocaleAndFonts(Locale locale) {
        if (OSUtils.isMacOSX()) {
            return;
        }
        String string = locale.getDisplayName();
        if (!ResourceManager.checkUIFonts("dialog", string)) {
            ApplicationSettings.LANGUAGE.setValue("en");
            ApplicationSettings.COUNTRY.setValue("");
            ApplicationSettings.LOCALE_VARIANT.setValue("");
            GUIMediator.resetLocale();
        }
        String string2 = "\u4e2d\u56fd";
        ResourceManager.checkFont("TextField.font", "dialog", string2, true);
        ResourceManager.checkFont("Table.font", "dialog", string2, true);
        ResourceManager.checkFont("ProgressBar.font", "dialog", string2, true);
        ResourceManager.checkFont("TabbedPane.font", "dialog", string2, true);
    }

    private static boolean checkUIFonts(String string, String string2) {
        String[] stringArray = new String[]{"TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "FormattedTextField.font", "Button.font", "CheckBox.font", "RadioButton.font", "ToggleButton.font", "ProgressBar.font", "ComboBox.font", "InternalFrame.titleFont", "DesktopIcon.font", "TitledBorder.font", "Label.font", "List.font", "TabbedPane.font", "Table.font", "TableHeader.font", "MenuBar.font", "Menu.font", "Menu.acceleratorFont", "MenuItem.font", "MenuItem.acceleratorFont", "PopupMenu.font", "CheckBoxMenuItem.font", "CheckBoxMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "RadioButtonMenuItem.acceleratorFont", "Spinner.font", "Tree.font", "ToolBar.font", "OptionPane.messageFont", "OptionPane.buttonFont", "ToolTip.font"};
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            bl |= ResourceManager.checkFont(stringArray[i], string, string2, false);
        }
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Font font;
            if (!(entry.getValue() instanceof Font) || (font = (Font)entry.getValue()) == null || string.equalsIgnoreCase(font.getName()) || GUIUtils.canDisplay(font, string2) || !GUIUtils.canDisplay(font = new Font(string, font.getStyle(), font.getSize()), string2)) continue;
            entry.setValue(font);
            bl = true;
        }
        return bl;
    }

    private static boolean checkFont(String string, String string2, String string3, boolean bl) {
        boolean bl2 = true;
        Font font = UIManager.getFont(string);
        if (font != null && !string2.equalsIgnoreCase(font.getName())) {
            if (!GUIUtils.canDisplay(font, string3) || bl) {
                if (GUIUtils.canDisplay(font = new Font(string2, font.getStyle(), font.getSize()), string3)) {
                    UIManager.put(string, font);
                } else {
                    bl2 = false;
                }
            }
        } else {
            bl2 = font != null ? GUIUtils.canDisplay(font, string3) : false;
        }
        return bl2;
    }

    public boolean isTrayLibraryLoaded() {
        return this.LOADED_TRAY_LIBRARY;
    }

    public boolean isTrayIconAvailable() {
        return this.isTrayLibraryLoaded() && NotifyUserProxy.instance().supportsSystemTray();
    }

    public boolean isJdicLibraryLoaded() {
        return this.LOADED_JDIC_LIBRARY;
    }

    public boolean isBrushedMetalSet() {
        return this.BRUSHED_METAL;
    }

    public void themeChanged() {
        THEME_IMAGES.clear();
        try {
            Object object;
            if (ThemeSettings.isOtherTheme()) {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                if (_defaultTheme != null) {
                    MetalLookAndFeel.setCurrentTheme(_defaultTheme);
                }
                object = ThemeSettings.getOtherLF();
                UIManager.setLookAndFeel((String)object);
            } else if (ThemeSettings.isNativeTheme()) {
                if (OSUtils.isWindows() && this.isPlasticWindowsAvailable()) {
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
                    }
                    catch (NullPointerException nullPointerException) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                if (OSUtils.isMacOSX()) {
                    if (!_fontReduced) {
                        _fontReduced = true;
                        ResourceManager.reduceFont("Label.font");
                        ResourceManager.reduceFont("Table.font");
                    }
                    UIManager.put("List.focusCellHighlightBorder", BorderFactory.createEmptyBorder(1, 1, 1, 1));
                    UIManager.put("ScrollPane.border", BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray));
                }
                if (OSUtils.isWindows()) {
                    this.replaceIconIfFailing("FileChooser.upFolderIcon", "upFolderIconVistaFix");
                    this.replaceIconIfFailing("FileChooser.detailsViewIcon", "detailsViewIconVistaFix");
                    this.replaceIconIfFailing("FileChooser.listViewIcon", "listViewIconVistaFix");
                    this.replaceIconIfFailing("FileChooser.newFolderIcon", "newFolderIconVistaFix");
                }
            } else if (this.isPlasticAvailable()) {
                if (_defaultTheme == null) {
                    _defaultTheme = this.getDefaultTheme();
                }
                LimePlasticTheme.installThisTheme();
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
                LimeLookAndFeel.installUIManagerDefaults();
            } else {
                UIManager.setLookAndFeel(new LimeLookAndFeel());
            }
            UIManager.put("Tree.leafIcon", UIManager.getIcon("Tree.closedIcon"));
            UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder());
            if (!OSUtils.isMacOSX()) {
                UIManager.put("Table.focusRowHighlightBorder", UIManager.get("Table.focusCellHighlightBorder"));
            }
            UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createEmptyBorder(1, 1, 1, 1));
            object = UIManager.getFont("Table.font");
            FontUIResource fontUIResource = new FontUIResource(((Font)object).getName(), 1, ((Font)object).getSize());
            UIManager.put("Table.font.bold", fontUIResource);
            UIManager.put("Tree.rowHeight", 0);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            throw new ExceptionInInitializerError(unsupportedLookAndFeelException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new ExceptionInInitializerError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionInInitializerError(illegalAccessException);
        }
        this.wrapDesktopProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapDesktopProperties() {
        UIDefaults uIDefaults;
        Class<?> clazz;
        if (!OSUtils.isWindows()) {
            return;
        }
        try {
            clazz = Class.forName("com.sun.java.swing.plaf.windows.DesktopProperty");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        UIDefaults uIDefaults2 = uIDefaults = UIManager.getLookAndFeelDefaults();
        synchronized (uIDefaults2) {
            for (Map.Entry entry : uIDefaults.entrySet()) {
                Object v = entry.getValue();
                if (!(entry.getValue() instanceof UIDefaults.ActiveValue)) continue;
                UIDefaults.ActiveValue activeValue = (UIDefaults.ActiveValue)v;
                if (v == null || !clazz.isAssignableFrom(v.getClass())) continue;
                entry.setValue(new ActiveDesktopProperty(activeValue));
            }
        }
    }

    private void replaceIconIfFailing(String string, String string2) {
        try {
            UIManager.getIcon(string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            UIManager.put(string, ResourceManager.getThemeImage(string2));
        }
    }

    private MetalTheme getDefaultTheme() {
        MetalTheme metalTheme = null;
        try {
            metalTheme = (MetalTheme)MetalLookAndFeel.class.getMethod("getCurrentTheme", null).invoke(null, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (metalTheme == null) {
            metalTheme = new DefaultMetalTheme();
        }
        return metalTheme;
    }

    private boolean isPlasticAvailable() {
        try {
            Class<?> clazz = Class.forName("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean isPlasticWindowsAvailable() {
        try {
            Class<?> clazz = Class.forName("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static ComponentUI getNativeUI(JComponent jComponent) {
        ComponentUI componentUI = null;
        String string = UIManager.getSystemLookAndFeelClassName();
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
                lookAndFeel.initialize();
                UIDefaults uIDefaults = lookAndFeel.getDefaults();
                componentUI = uIDefaults.getUI(jComponent);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (SecurityException securityException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (componentUI == null) {
            componentUI = UIManager.getUI(jComponent);
        }
        return componentUI;
    }

    private static void reduceFont(String string) {
        Font font = UIManager.getFont(string);
        FontUIResource fontUIResource = new FontUIResource(font.getName(), font.getStyle(), font.getSize() - 2);
        UIManager.put(string, fontUIResource);
    }

    public static void setFontSizes(float f) {
        if (f == 0.0f) {
            return;
        }
        HashMap<Font, Font> hashMap = new HashMap<Font, Font>();
        String[] stringArray = new String[]{"Button.font", "CheckBox.font", "ComboBox.font", "DesktopIcon.font", "Label.font", "List.font", "ProgressBar.font", "RadioButton.font", "Slider.font", "Spinner.font", "TabbedPane.font", "TitledBorder.font", "ToggleButton.font", "CheckBoxMenuItem.font", "Menu.font", "MenuBar.font", "MenuItem.font", "PopupMenu.font", "RadioButtonMenuItem.font", "ToolBar.font", "ToolTip.font", "EditorPane.font", "FormattedTextField.font", "PasswordField.font", "Table.font", "TableHeader.font", "TextArea.font", "TextField.font", "TextPane.font", "Tree.font", "InternalFrame.titleFont"};
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length * 2);
        for (String string : stringArray) {
            Font font = UIManager.getFont(string);
            Font font2 = (Font)hashMap.get(font);
            if (font2 == null) {
                if (font == null) continue;
                font2 = new FontUIResource(font.deriveFont((float)font.getSize() + f));
                hashMap.put(font, font2);
            }
            arrayList.add(string);
            arrayList.add(font2);
        }
        UIManager.getDefaults().putDefaults(arrayList.toArray());
    }

    static {
        _fontReduced = false;
        _defaultTheme = null;
        THEME_IMAGES = new HashMap<String, ImageIcon>();
        loadFailureEncountered = false;
        ResourceManager.resetLocaleOptions();
    }

    private static class ActiveDesktopProperty
    implements UIDefaults.ActiveValue,
    Runnable {
        private final UIDefaults.ActiveValue delegate;
        private volatile UIDefaults table;
        private volatile Object result;

        ActiveDesktopProperty(UIDefaults.ActiveValue activeValue) {
            this.delegate = activeValue;
        }

        public Object createValue(UIDefaults uIDefaults) {
            if (SwingUtilities.isEventDispatchThread()) {
                return this.delegate.createValue(uIDefaults);
            }
            this.table = uIDefaults;
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (InterruptedException interruptedException) {
                return this.delegate.createValue(uIDefaults);
            }
            catch (InvocationTargetException invocationTargetException) {
                return this.delegate.createValue(uIDefaults);
            }
            return this.result;
        }

        public void run() {
            this.result = this.delegate.createValue(this.table);
        }
    }
}

