/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class SaveDirectoryHandler {
    private SaveDirectoryHandler() {
    }

    private static void showSaveDirectoryWindow() {
        File file = null;
        while (!SaveDirectoryHandler.isSaveDirectoryValid(file) || !SaveDirectoryHandler.showVistaWarningIfNeeded(file)) {
            final AtomicReference atomicReference = new AtomicReference();
            GUIMediator.safeInvokeAndWait(new Runnable(){

                public void run() {
                    GUIMediator.showError(I18n.tr("Your save folder is not valid. It may have been deleted, you may not have permissions to write to it, or there may be another problem. Please choose a different folder."));
                    atomicReference.set(SaveDirectoryHandler.showChooser());
                }
            });
            file = (File)atomicReference.get();
            if (file == null) continue;
            FileUtils.setWriteable(file);
        }
    }

    private static File showChooser() {
        final AtomicReference atomicReference = new AtomicReference();
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                atomicReference.set(FileChooserHandler.getInputDirectory(null));
            }
        });
        File file = (File)atomicReference.get();
        if (file != null) {
            try {
                SharingSettings.setSaveDirectory(file);
                return file;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSaveDirectoryValid(File file) {
        int n;
        if (file == null || !file.exists() || !file.isDirectory()) {
            return false;
        }
        FileUtils.setWriteable(file);
        Random random = new Random();
        File file2 = null;
        for (int i = 0; i < 10 && file2 == null; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < 8; ++n) {
                stringBuilder.append((char)(97 + random.nextInt(25)));
            }
            stringBuilder.append(".tmp");
            file2 = new File(file, stringBuilder.toString());
            if (!file2.exists()) continue;
            file2 = null;
        }
        if (file2 == null) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file2, "rw");
            randomAccessFile.write(7);
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            n = 0;
            return n != 0;
        }
        catch (IOException iOException) {
            n = 0;
            return n != 0;
        }
        finally {
            file2.delete();
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return file.canWrite();
    }

    public static void handleSaveDirectory() {
        File file = SharingSettings.getSaveDirectory();
        if (!SaveDirectoryHandler.isSaveDirectoryValid(file) || !SaveDirectoryHandler.showVistaWarningIfNeeded(file)) {
            SaveDirectoryHandler.showSaveDirectoryWindow();
        }
    }

    public static boolean isGoodVistaDirectory(File file) {
        if (!OSUtils.isWindowsVista()) {
            return true;
        }
        try {
            return FileUtils.isReallyInParentPath(CommonUtils.getUserHomeDir(), file);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static boolean showVistaWarningIfNeeded(File file) {
        if (SaveDirectoryHandler.isGoodVistaDirectory(file)) {
            return true;
        }
        return GUIMediator.showYesNoMessage(I18n.tr("Saving downloads to {0} may not function correctly.  To be sure downloads are saved properly you should save them to a sub-folder of {1}.  Would you like to choose another location?", file, CommonUtils.getUserHomeDir()), QuestionsHandler.VISTA_SAVE_LOCATION, DialogOption.YES) == DialogOption.NO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ERROR_CODE {
        INVALID,
        NOT_HOME;

    }
}

