/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.actions.ConnectionDoctorAction;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageButton;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.StatusComponent;
import com.limegroup.gnutella.gui.StatusLinkHandler;
import com.limegroup.gnutella.gui.UpdatePanel;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.StatusBarSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.UpdateInformation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;
import org.limewire.setting.BooleanSetting;

public final class StatusLine
implements ThemeObserver {
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_POOR = 2;
    public static final int STATUS_FAIR = 3;
    public static final int STATUS_GOOD = 4;
    public static final int STATUS_EXCELLENT = 5;
    public static final int STATUS_TURBOCHARGED = 6;
    public static final int STATUS_IDLE = 7;
    public static final int STATUS_WAKING_UP = 8;
    private final JPanel BAR = new JPanel(new GridBagLayout());
    private final JLabel _connectionQualityMeter = new JLabel();
    private final ImageIcon[] _connectionQualityMeterIcons = new ImageIcon[9];
    private final LanguageButton _languageButton = new LanguageButton();
    private final JLabel _firewallStatus = new JLabel();
    private final SharedFilesLabel _sharedFiles = new SharedFilesLabel();
    private final JLabel _lwsStatus = new JLabel();
    private final JLabel _bandwidthUsageDown = new LazyTooltip(GUIMediator.getThemeImage("downloading_small"));
    private final JLabel _bandwidthUsageUp = new LazyTooltip(GUIMediator.getThemeImage("uploading_small"));
    private final StatusComponent STATUS_COMPONENT = new StatusComponent();
    private final UpdatePanel _updatePanel = new UpdatePanel();
    private final StatusLinkHandler _statusLinkHandler = new StatusLinkHandler();
    private final JPanel _centerPanel = new JPanel(new GridBagLayout());
    private Component _centerComponent = this._updatePanel;
    private MediaPlayerComponent _mediaPlayer;
    private final NetworkManager networkManager;
    private long _nextUpdateTime = System.currentTimeMillis();
    private final RefreshListener REFRESH_LISTENER = new RefreshListener(){

        public void refresh() {
            if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue()) {
                StatusLine.this.updateBandwidth();
            }
            StatusLine.this.updateCenterPanel();
        }
    };
    private final MouseAdapter STATUS_BAR_LISTENER = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (mouseEvent.getComponent().equals(StatusLine.this._connectionQualityMeter)) {
                    jPopupMenu.add(new JMenuItem(ConnectionDoctorAction.getInstance()));
                    jPopupMenu.addSeparator();
                }
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowConnectionQualityAction());
                jCheckBoxMenuItem.setState(StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue());
                jPopupMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowLanguageStatusAction());
                jCheckBoxMenuItem.setState(StatusLine.this.getLanguageSetting().getValue());
                jPopupMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowFirewallStatusAction());
                jCheckBoxMenuItem.setState(StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue());
                jPopupMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowSharedFilesCountAction());
                jCheckBoxMenuItem.setState(StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.getValue());
                jPopupMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowBandwidthConsumptionAction());
                jCheckBoxMenuItem.setState(StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue());
                jPopupMenu.add(jCheckBoxMenuItem);
                jPopupMenu.addSeparator();
                jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowMediaPlayerAction());
                jCheckBoxMenuItem.setState(PlayerSettings.PLAYER_ENABLED.getValue());
                jPopupMenu.add(jCheckBoxMenuItem);
                jPopupMenu.pack();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };

    public StatusLine(NetworkManager networkManager) {
        this.networkManager = networkManager;
        GUIMediator.setSplashScreenString(I18n.tr("Loading Status Window..."));
        GUIMediator.addRefreshListener(this.REFRESH_LISTENER);
        this.BAR.addMouseListener(this.STATUS_BAR_LISTENER);
        GUIMediator.getAppFrame().addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                StatusLine.this.refresh();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.createConnectionQualityPanel();
        this.createLanguageButton();
        this.createFirewallLabel();
        this.createLWSLabel();
        this.createSharingFilesLabel();
        this.createBandwidthLabel();
        this.createCenterPanel();
        this.setConnectionQuality(0);
        ThemeMediator.addThemeObserver(this);
        this.refresh();
    }

    public void refresh() {
        int n;
        this.BAR.removeAll();
        int n2 = Math.max(2, this.createSeparator().getWidth());
        int n3 = this.BAR.getWidth();
        if (n3 <= 0) {
            n3 = ApplicationSettings.APP_WIDTH.getValue();
        }
        if (GUIMediator.isPlaylistVisible()) {
            if (this._mediaPlayer == null) {
                this._mediaPlayer = MediaPlayerComponent.getInstance();
            }
            n3 -= n2;
            n3 -= 3;
            n3 -= this._mediaPlayer.minWidth;
            n3 -= 6;
        }
        if ((n = this._centerComponent.getWidth()) <= 0 && this._updatePanel.shouldBeShown()) {
            n = 190;
            if (!GUIMediator.hasDonated()) {
                n = 280;
            }
        }
        n3 -= n;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = -1;
        n = 6 + Math.max((int)this._connectionQualityMeter.getMinimumSize().getWidth(), this._connectionQualityMeter.getWidth()) + n2;
        if (StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue() && n3 > n) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._connectionQualityMeter, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n3 -= n;
        }
        n = 6 + Math.max((int)this._languageButton.getMinimumSize().getWidth(), this._languageButton.getWidth()) + n2;
        BooleanSetting booleanSetting = this.getLanguageSetting();
        if (booleanSetting.getValue() && n3 > n) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._languageButton, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n3 -= n;
        }
        n = 6 + Math.max((int)this._firewallStatus.getMinimumSize().getWidth(), this._firewallStatus.getWidth()) + n2;
        if (StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue() && n3 > n) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._firewallStatus, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n3 -= n;
        }
        n = 6 + Math.max((int)this._lwsStatus.getMinimumSize().getWidth(), this._lwsStatus.getWidth()) + n2;
        if (StatusBarSettings.LWS_DISPLAY_ENABLED.getValue() && n3 > n) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._lwsStatus, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n3 -= n;
        }
        n = 6 + Math.max((int)this._sharedFiles.getMinimumSize().getWidth(), this._sharedFiles.getWidth()) + n2;
        if (StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.getValue() && n3 > n) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._sharedFiles, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n3 -= n;
        }
        n = 9 + n2 + Math.max((int)this._bandwidthUsageDown.getMinimumSize().getWidth(), this._bandwidthUsageDown.getWidth()) + Math.max((int)this._bandwidthUsageUp.getMinimumSize().getWidth(), this._bandwidthUsageUp.getWidth());
        if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue() && n3 > n) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._bandwidthUsageDown, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(6), gridBagConstraints);
            this.BAR.add((Component)this._bandwidthUsageUp, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n3 -= n;
        }
        this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.BAR.add((Component)this._centerPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
        if (GUIMediator.isPlaylistVisible()) {
            JPanel jPanel = this._mediaPlayer.getMediaPanel();
            if (n3 + this._mediaPlayer.minWidth > this._mediaPlayer.fullSizeWidth) {
                jPanel.setPreferredSize(new Dimension(this._mediaPlayer.fullSizeWidth, 25));
            } else {
                jPanel.setPreferredSize(new Dimension(this._mediaPlayer.minWidth, 25));
            }
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)jPanel, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(6), gridBagConstraints);
        }
        this.BAR.validate();
        this.BAR.repaint();
    }

    private Component createSeparator() {
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(2, 20));
        jSeparator.setMinimumSize(new Dimension(2, 20));
        return jSeparator;
    }

    private void createConnectionQualityPanel() {
        this.updateTheme();
        this._connectionQualityMeter.setOpaque(false);
        this._connectionQualityMeter.setMinimumSize(new Dimension(34, 20));
        this._connectionQualityMeter.setMaximumSize(new Dimension(90, 30));
        this._connectionQualityMeter.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createSharingFilesLabel() {
        this._sharedFiles.setHorizontalAlignment(2);
        this._sharedFiles.setMinimumSize(new Dimension(24, 20));
        this._sharedFiles.addMouseListener(this.STATUS_BAR_LISTENER);
        this._sharedFiles.updateToolTip(0);
    }

    private void createLanguageButton() {
        this._languageButton.addMouseListener(this.STATUS_BAR_LISTENER);
        this.updateLanguage();
    }

    private void createFirewallLabel() {
        this.updateFirewall();
        this._firewallStatus.setMinimumSize(new Dimension(20, 20));
        this._firewallStatus.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createLWSLabel() {
        this.updateLWS();
        this._lwsStatus.setMinimumSize(new Dimension(20, 20));
        this._lwsStatus.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createBandwidthLabel() {
        this.updateBandwidth();
        this._bandwidthUsageDown.setMinimumSize(new Dimension(60, 20));
        this._bandwidthUsageUp.setMinimumSize(new Dimension(60, 20));
        this._bandwidthUsageDown.addMouseListener(this.STATUS_BAR_LISTENER);
        this._bandwidthUsageUp.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createCenterPanel() {
        this._centerPanel.setOpaque(false);
        this._updatePanel.setOpaque(false);
        ((JComponent)this._statusLinkHandler.getComponent()).setOpaque(false);
        this.STATUS_COMPONENT.setProgressPreferredSize(new Dimension(250, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this._centerPanel.add((Component)this.STATUS_COMPONENT, gridBagConstraints);
        this._statusLinkHandler.getComponent().addMouseListener(this.STATUS_BAR_LISTENER);
        this._centerPanel.addMouseListener(this.STATUS_BAR_LISTENER);
        this._updatePanel.addMouseListener(this.STATUS_BAR_LISTENER);
        this.STATUS_COMPONENT.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void updateCenterPanel() {
        long l = System.currentTimeMillis();
        if (this._nextUpdateTime > l) {
            return;
        }
        this._nextUpdateTime = l + 5000L;
        this._centerPanel.removeAll();
        this._centerComponent = GUIMediator.hasDonated() ? (this._updatePanel.shouldBeShown() ? this._updatePanel : new JLabel()) : (this._centerComponent == this._statusLinkHandler.getComponent() && this._updatePanel.shouldBeShown() ? this._updatePanel : this._statusLinkHandler.getComponent());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this._centerPanel.add(this._centerComponent, gridBagConstraints);
        this.refresh();
    }

    public void showUpdatePanel(boolean bl, UpdateInformation updateInformation) {
        this._updatePanel.makeVisible(bl, updateInformation);
    }

    void setStatusText(final String string) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                StatusLine.this.STATUS_COMPONENT.setText(string);
            }
        });
    }

    public void updateFirewallLabel(boolean bl) {
        if (bl) {
            this._firewallStatus.setIcon(GUIMediator.getThemeImage("firewall_no"));
            this._firewallStatus.setToolTipText(I18n.tr("FrostWire has not detected a firewall"));
        } else {
            this._firewallStatus.setIcon(GUIMediator.getThemeImage("firewall"));
            this._firewallStatus.setToolTipText(I18n.tr("FrostWire has detected a firewall"));
        }
    }

    public void updateLWSLabel(boolean bl) {
        if (bl) {
            this._lwsStatus.setIcon(GUIMediator.getThemeImage("lws_statusline_no"));
            this._lwsStatus.setToolTipText(I18n.tr("You are not connected to the FrostWire VIP Area"));
        } else {
            this._lwsStatus.setIcon(GUIMediator.getThemeImage("lws_statusline"));
            this._lwsStatus.setToolTipText(I18n.tr("You are connected to the FrostWire"));
        }
    }

    public void updateLanguage() {
        this._languageButton.updateLanguageFlag();
    }

    public void updateFirewall() {
        this.updateFirewallLabel(this.networkManager.acceptedIncomingConnection());
    }

    public void updateLWS() {
        this.updateLWSLabel(true);
    }

    private int getNumberOfUploadsWithoutHostilesTxt() {
        int n = GuiCoreMediator.getUploadServices().getNumUploads();
        if (GuiCoreMediator.getUploadServices().isSeedingHostilesTxt()) {
            --n;
        }
        return n;
    }

    public void updateBandwidth() {
        String string = GUIUtils.rate2speed(GuiCoreMediator.getDownloadManager().getLastMeasuredBandwidth());
        String string2 = GUIUtils.rate2speed(GuiCoreMediator.getUploadManager().getLastMeasuredBandwidth());
        int n = GuiCoreMediator.getDownloadServices().getNumActiveDownloads();
        int n2 = this.getNumberOfUploadsWithoutHostilesTxt();
        this._bandwidthUsageDown.setText(n + " @ " + string);
        this._bandwidthUsageUp.setText(n2 + " @ " + string2);
    }

    void loadFinished() {
        this.updateCenterPanel();
        this._centerPanel.revalidate();
        this._centerPanel.repaint();
        this.refresh();
    }

    public void updateTheme() {
        for (int i = 0; i < this._connectionQualityMeterIcons.length; ++i) {
            this._connectionQualityMeterIcons[i] = GUIMediator.getThemeImage("connect_small_" + i);
        }
        if (this._mediaPlayer != null) {
            this._mediaPlayer.updateTheme();
        }
    }

    public void setConnectionQuality(int n) {
        if (n >= this._connectionQualityMeterIcons.length) {
            n = this._connectionQualityMeterIcons.length - 1;
        }
        this._connectionQualityMeter.setIcon(this._connectionQualityMeterIcons[n]);
        String string = null;
        String string2 = null;
        String string3 = I18n.tr("Connection");
        switch (n) {
            case 0: {
                string = I18n.tr("Disconnected");
                string2 = I18n.tr("You are disconnected from the network. To connect, choose Connect from the File menu.");
                break;
            }
            case 1: {
                string = I18n.tr("Starting") + " " + string3;
                string2 = I18n.tr("You are currently connecting to the network");
                break;
            }
            case 2: {
                string = I18n.tr("Poor") + " " + string3;
                string2 = I18n.tr("You are connected to few hosts and have an unstable connection the network");
                break;
            }
            case 3: {
                string = I18n.tr("Fair") + " " + string3;
                string2 = I18n.tr("Your connection to the network is getting stronger");
                break;
            }
            case 4: {
                string = I18n.tr("Good") + " " + string3;
                string2 = I18n.tr("You are not yet fully connected to the network, but have a very good connection");
                break;
            }
            case 5: 
            case 7: {
                string = I18n.tr("Excellent") + " " + string3;
                string2 = I18n.tr("Your connection to the network is very strong");
                break;
            }
            case 6: {
                string = I18n.tr("Turbo-Charged") + " " + string3;
                string2 = LimeWireUtils.isPro() ? I18n.tr("Your connection to the network is extremely strong") : I18n.tr("You can experience Turbo-Charged connections all the time with LimeWire PRO!");
                break;
            }
            case 8: {
                string = I18n.tr("Waking Up") + " " + string3;
                string2 = I18n.tr("FrostWire is waking up from sleep mode");
            }
        }
        this._connectionQualityMeter.setToolTipText(string2);
        if (GUIMediator.hasDonated()) {
            this._connectionQualityMeter.setText(string);
        }
    }

    public void setStatistics(int n, int n2) {
        this._sharedFiles.update(n, n2);
    }

    public JComponent getComponent() {
        return this.BAR;
    }

    private BooleanSetting getLanguageSetting() {
        if (GUIMediator.isEnglishLocale()) {
            return StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED;
        }
        return StatusBarSettings.LANGUAGE_DISPLAY_ENABLED;
    }

    private class LazyTooltip
    extends JLabel {
        LazyTooltip(ImageIcon imageIcon) {
            super(imageIcon);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public String getToolTipText() {
            String string = GUIUtils.rate2speed(GuiCoreMediator.getDownloadManager().getLastMeasuredBandwidth());
            String string2 = GUIUtils.rate2speed(GuiCoreMediator.getUploadManager().getLastMeasuredBandwidth());
            String string3 = GUIUtils.toUnitbytes(GuiCoreMediator.getTcpBandwidthStatistics().getTotalDownstream() * 1024L);
            String string4 = GUIUtils.toUnitbytes(GuiCoreMediator.getTcpBandwidthStatistics().getTotalUpstream() * 1024L);
            int n = GuiCoreMediator.getDownloadServices().getNumActiveDownloads();
            int n2 = StatusLine.this.getNumberOfUploadsWithoutHostilesTxt();
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("<html><table>").append("<tr><td>").append(I18n.tr("Downloads:")).append("</td><td>").append(n).append("</td><td>@</td><td align=right>").append(string).append("</td></tr>").append("<tr><td>").append(I18n.tr("Uploads:")).append("</td><td>").append(n2).append("</td><td>@</td><td align=right>").append(string2).append("</td></tr>").append("<tr><td>").append(I18n.tr("Total Downstream:")).append("</td><td>").append(string3).append("</td></tr>").append("<tr><td>").append(I18n.tr("Total Upstream:")).append("</td><td>").append(string4).append("</td></tr>").append("</table></html>");
            return stringBuilder.toString();
        }
    }

    private class SharedFilesLabel
    extends JLabel {
        private static final int _height = 20;
        private int _width = 26;
        private FontMetrics fm = null;
        private String _string = "0...";
        private int _share;
        private int _pending;

        private SharedFilesLabel() {
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this._width, 20);
        }

        public void update(int n, int n2) {
            boolean bl = n != this._share;
            boolean bl2 = n2 != this._pending;
            this._share = n;
            this._pending = n2;
            if (!bl && !bl2) {
                return;
            }
            this._string = GUIUtils.toLocalizedInteger(this._share);
            if (!GuiCoreMediator.getFileManager().isLoadFinished() || GuiCoreMediator.getFileManager().isUpdating()) {
                this._string = this._string + "...";
            }
            if (this.fm != null) {
                this._width = this.fm.stringWidth(this._string) + 20;
            }
            this.revalidate();
            this.repaint();
            this.updateToolTip(n);
        }

        private void updateToolTip(int n) {
            if (GuiCoreMediator.getFileManager().isLoadFinished()) {
                this.setToolTipText(I18n.trn("You are sharing {0} file", "You are sharing {0} files", n, n));
            } else {
                this.setToolTipText(I18n.trn("You are sharing {0} file (Loading...)", "You are sharing {0} files (Loading...)", n, n));
            }
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.fm == null) {
                this.fm = graphics2D.getFontMetrics();
            }
            if (!GuiCoreMediator.getFileManager().isLoadFinished() || GuiCoreMediator.getFileManager().isUpdating()) {
                graphics2D.setPaint(new Color(165, 165, 2));
                if (!this._string.endsWith("...")) {
                    this._string = this._string + "...";
                }
            } else if (this._string.startsWith("0")) {
                graphics2D.setPaint(ThemeFileHandler.NOT_SHARING_LABEL_COLOR.getValue());
                if (this._string.endsWith("...")) {
                    this._string = this._string.substring(0, this._string.length() - 3);
                }
            } else {
                graphics2D.setPaint(new Color(2, 137, 2));
                if (this._string.endsWith("...")) {
                    this._string = this._string.substring(0, this._string.length() - 3);
                }
            }
            if ((n = this.fm.stringWidth(this._string) + 20) != this._width) {
                this._width = n;
                this.revalidate();
            }
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 0.0f, this._width - 2, 18.0f, 20.0f, 20.0f);
            graphics2D.fill(float_);
            graphics2D.setColor(Color.black);
            graphics2D.draw(float_);
            graphics2D.setColor(Color.white);
            graphics2D.drawString(this._string, (float_.width - (float)this.fm.stringWidth(this._string)) / 2.0f, (float_.height + (float)this.fm.getAscent() - (float)this.fm.getDescent()) / 2.0f);
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    private class ShowMediaPlayerAction
    extends AbstractAction {
        public ShowMediaPlayerAction() {
            this.putValue("Name", I18n.tr("Show Media Player"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.instance().setPlayerEnabled(!PlayerSettings.PLAYER_ENABLED.getValue());
        }
    }

    private class ShowBandwidthConsumptionAction
    extends AbstractAction {
        public ShowBandwidthConsumptionAction() {
            this.putValue("Name", I18n.tr("Show Bandwidth Consumption"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowStoreIndicatorStatusAction
    extends AbstractAction {
        public ShowStoreIndicatorStatusAction() {
            this.putValue("Name", I18n.tr("Show Store Indicator"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.LWS_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowFirewallStatusAction
    extends AbstractAction {
        public ShowFirewallStatusAction() {
            this.putValue("Name", I18n.tr("Show Firewall Status"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.FIREWALL_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowLanguageStatusAction
    extends AbstractAction {
        public ShowLanguageStatusAction() {
            this.putValue("Name", I18n.tr("Show Language Status"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BooleanSetting booleanSetting = StatusLine.this.getLanguageSetting();
            booleanSetting.invert();
            StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(booleanSetting.getValue());
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(booleanSetting.getValue());
            StatusLine.this.refresh();
        }
    }

    private class ShowSharedFilesCountAction
    extends AbstractAction {
        public ShowSharedFilesCountAction() {
            this.putValue("Name", I18n.tr("Show Shared Files Count"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowConnectionQualityAction
    extends AbstractAction {
        public ShowConnectionQualityAction() {
            this.putValue("Name", I18n.tr("Show Connection Quality"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }
}

