/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.version.UpdateInformation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

final class UpdateDialog
extends JDialog {
    public UpdateDialog(UpdateInformation updateInformation) {
        super(GUIMediator.getAppFrame());
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(I18n.tr("New Version Available!"));
        JButton jButton = this.buildContentArea(updateInformation);
        this.pack();
        Dimension dimension = new Dimension(500, 300);
        this.setSize(dimension);
        ((JComponent)this.getContentPane()).setPreferredSize(dimension);
        this.getRootPane().setDefaultButton(jButton);
        jButton.requestFocus();
    }

    private JButton buildContentArea(UpdateInformation updateInformation) {
        URLLabel uRLLabel = new URLLabel(updateInformation.getUpdateURL(), this.getUpdateIcon());
        JComponent jComponent = this.makeText(this.getUpdateTitle(updateInformation.getUpdateTitle()), false);
        JComponent jComponent2 = this.makeText(updateInformation.getUpdateText(), true);
        JButton jButton = this.makeButton1(updateInformation);
        JButton jButton2 = this.makeButton2(updateInformation);
        JComponent jComponent3 = (JComponent)this.getContentPane();
        jComponent3.setLayout(new GridBagLayout());
        jComponent3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)uRLLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        jComponent3.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jComponent3.add((Component)jComponent2, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        jComponent3.add((Component)jPanel, gridBagConstraints);
        return jButton;
    }

    private String getUpdateTitle(String string) {
        if (string != null) {
            return "<b>" + string + "</b>";
        }
        return "<b>" + I18n.tr("A new version of FrostWire is available.") + "</b>";
    }

    private Icon getUpdateIcon() {
        return GUIMediator.getThemeImage("searching");
    }

    private JComponent makeText(String string, boolean bl) {
        JEditorPane jEditorPane = new JEditorPane();
        JLabel jLabel = new JLabel();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(jLabel.getBackground());
        jEditorPane.setFont(jLabel.getFont());
        jEditorPane.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        string = this.updateForeground(jLabel.getForeground(), string);
        jEditorPane.setText(string);
        jEditorPane.setCaretPosition(0);
        if (!bl) {
            return jEditorPane;
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    private String updateForeground(Color color, String string) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        String string2 = this.toHex(n) + this.toHex(n2) + this.toHex(n3);
        return "<html><body text='#" + string2 + "'>" + string + "</body></html>";
    }

    private String toHex(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    private JButton makeButton1(final UpdateInformation updateInformation) {
        String string = updateInformation.getButton1Text();
        if (string == null) {
            string = I18n.tr("Update Now");
        }
        JButton jButton = new JButton(string);
        jButton.setToolTipText(I18n.tr("Visit http://www.frostwire.com to update!"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = updateInformation.getUpdateCommand();
                if (string != null) {
                    GUIMediator.flagUpdate(string);
                    DialogOption dialogOption = GUIMediator.showYesNoTitledMessage(I18n.tr("FrostWire needs to be restarted to install the update. If you choose not to update now, FrostWire will update automatically when you close. Would you like to update now?"), I18n.tr("Update Ready"), DialogOption.YES);
                    if (dialogOption == DialogOption.YES) {
                        GUIMediator.shutdown();
                    }
                } else {
                    GUIMediator.openURL(updateInformation.getUpdateURL());
                }
                UpdateDialog.this.setVisible(false);
                UpdateDialog.this.dispose();
            }
        });
        return jButton;
    }

    private JButton makeButton2(UpdateInformation updateInformation) {
        String string = updateInformation.getButton2Text();
        if (string == null) {
            string = I18n.tr("Update Later");
        }
        JButton jButton = new JButton(string);
        jButton.setToolTipText(I18n.tr("Visit http://www.frostwire.com to update!"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdateDialog.this.setVisible(false);
                UpdateDialog.this.dispose();
            }
        });
        return jButton;
    }
}

