/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;

public class BitziLookupAction
extends AbstractAction {
    private static final String BITZI_LOOKUP_URL = "http://bitzi.com/lookup/{0}?ref=limewire";
    FileDetailsProvider provider;

    public BitziLookupAction(FileDetailsProvider fileDetailsProvider) {
        this.putValue("Name", I18n.tr("Lookup File with Bitzi"));
        this.provider = fileDetailsProvider;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDetails[] fileDetailsArray = this.provider.getFileDetails();
        if (fileDetailsArray.length == 0) {
            return;
        }
        URN uRN = fileDetailsArray[0].getSHA1Urn();
        if (uRN != null) {
            String string = uRN.toString();
            int n = 1 + string.indexOf(":", 4);
            String string2 = MessageFormat.format(BITZI_LOOKUP_URL, string.substring(n));
            GUIMediator.openURL(string2);
        }
    }
}

