/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class CopyMagnetLinkToClipboardAction
extends AbstractAction {
    private FileDetailsProvider provider;

    public CopyMagnetLinkToClipboardAction(FileDetailsProvider fileDetailsProvider) {
        this.provider = fileDetailsProvider;
        this.putValue("Name", I18n.tr("Copy Magnet Links to Clipboard"));
        this.putValue("ShortDescription", I18n.tr("Copy the Magnet Links of the Selected Files to the Clipboard"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setClipboardString();
    }

    private void setClipboardString() {
        Object object;
        FileDetails[] fileDetailsArray = this.provider.getFileDetails();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = System.getProperty("line.separator");
        for (int i = 0; i < fileDetailsArray.length; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            if (!((MagnetOptions)(object = MagnetOptions.createMagnet(fileDetailsArray[i]))).isDownloadable()) continue;
            bl |= fileDetailsArray[i].isFirewalled();
            stringBuilder.append(((MagnetOptions)object).toExternalForm());
        }
        String string2 = stringBuilder.toString();
        MagnetClipboardListener.getInstance().setCopiedText(string2);
        object = new StringSelection(string2);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
        if (bl) {
            GUIMediator.showWarning(I18n.tr("One or more of the created magnet links may not be accessible since their hosts are firewalled."), QuestionsHandler.FIREWALLED_MAGNET_LINK);
        }
    }
}

