/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.download.TorrentFileFilter;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.http.URIUtils;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FileMenuActions {
    static final int SPACE = 6;

    public static boolean openMagnetOrTorrent(String string) {
        if (string.startsWith("magnet:?xt=urn:btih")) {
            GUIMediator.instance().openTorrentMagnet(string);
            return true;
        }
        MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnets(string);
        if (magnetOptionsArray.length != 0) {
            MagnetClipboardListener.handleMagnets(magnetOptionsArray, false);
            return true;
        }
        File file = new File(string);
        if (FileMenuActions.isFileSystemPath(file)) {
            if (file.exists()) {
                GUIMediator.instance().openTorrent(file);
                return true;
            }
        } else {
            try {
                String string2;
                URI uRI = URIUtils.toURI(string);
                String string3 = uRI.getScheme();
                if (string3 != null && string3.equalsIgnoreCase("http") && (string2 = uRI.getAuthority()) != null && string2.length() != 0 && string2.indexOf(32) == -1) {
                    uRI = URIUtils.toURI(uRI.toString());
                    GUIMediator.instance().openTorrentURI(uRI);
                    return true;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                URIUtils.error(uRISyntaxException);
            }
        }
        return false;
    }

    private static boolean isFileSystemPath(File file) {
        return file.isAbsolute();
    }

    public static class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(I18n.tr("&Close"));
            this.putValue("LongDescription", I18n.tr("Close the Program"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.close(false);
        }
    }

    public static class OpenMagnetTorrentAction
    extends AbstractAction {
        private JDialog dialog = null;
        private AutoCompleteTextField PATH_FIELD = new ClearableAutoCompleteTextField(34);

        public OpenMagnetTorrentAction() {
            super(I18n.tr("&Download .Torrent or Magnet"));
            this.putValue("LongDescription", I18n.tr("Opens a magnet link or torrent file"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.PATH_FIELD.setText("");
            this.dialog.pack();
            GUIUtils.centerOnScreen(this.dialog);
            this.dialog.setVisible(true);
        }

        private void createDialog() {
            this.dialog = new JDialog(GUIMediator.getAppFrame(), I18n.tr("Download .Torrent or Magnet"), true);
            this.dialog.addWindowListener(new OpenDialogWindowAdapter());
            JPanel jPanel = (JPanel)this.dialog.getContentPane();
            GUIUtils.addHideAction(jPanel);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setBorder(new EmptyBorder(12, 6, 6, 6));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            jPanel.add((Component)new JLabel(IconManager.instance().getIconForButton("SEARCH_DOWNLOAD")), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 6, 12, 0);
            jPanel.add((Component)new MultiLineLabel(I18n.tr("Type a magnet link, or the path or Web address of a torrent file, and FrostWire will download it for you."), true), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)new JLabel(I18n.tr("Open:")), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            jPanel.add((Component)this.PATH_FIELD, gridBagConstraints);
            ButtonRow buttonRow = new ButtonRow(new Action[]{new PasteAction(), new BrowseAction()}, 0, 12);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(6, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)buttonRow, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)new Canvas(), gridBagConstraints);
            buttonRow = new ButtonRow(new Action[]{new OkAction(), new CancelAction()}, 0, 12);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(12, 0, 0, 0);
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)buttonRow, gridBagConstraints);
            this.dialog.getRootPane().setDefaultButton(buttonRow.getButtonAtIndex(0));
        }

        private class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super(I18n.tr("Cancel"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                GUIUtils.getDisposeAction().actionPerformed(actionEvent);
            }
        }

        private class OkAction
        extends AbstractAction {
            public OkAction() {
                super(I18n.tr("OK"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (FileMenuActions.openMagnetOrTorrent(OpenMagnetTorrentAction.this.PATH_FIELD.getText())) {
                    OpenMagnetTorrentAction.this.dialog.setVisible(false);
                    OpenMagnetTorrentAction.this.dialog.dispose();
                } else {
                    GUIMediator.showError(I18n.tr("FrostWire cannot download this address. Make sure you typed it correctly, and then try again."));
                }
            }
        }

        private class BrowseAction
        extends AbstractAction {
            public BrowseAction() {
                super(I18n.tr("Browse..."));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                File file = FileChooserHandler.getInputFile(GUIMediator.getAppFrame(), TorrentFileFilter.INSTANCE);
                if (file != null) {
                    OpenMagnetTorrentAction.this.PATH_FIELD.setText(file.getAbsolutePath());
                }
            }
        }

        private class PasteAction
        extends AbstractAction {
            public PasteAction() {
                super(I18n.tr("Paste"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OpenMagnetTorrentAction.this.PATH_FIELD.paste();
            }
        }

        private class OpenDialogWindowAdapter
        extends WindowAdapter {
            private OpenDialogWindowAdapter() {
            }

            public void windowOpened(WindowEvent windowEvent) {
                OpenMagnetTorrentAction.this.PATH_FIELD.requestFocusInWindow();
            }
        }
    }

    public static class DisconnectAction
    extends AbstractAction {
        private final ConnectionManager manager;

        public DisconnectAction(ConnectionManager connectionManager) {
            super(I18n.tr("D&isconnect"));
            this.putValue("LongDescription", I18n.tr("Disconnect from the Network"));
            this.manager = connectionManager;
            this.setEnabled(connectionManager.isConnected() || connectionManager.isConnecting());
            connectionManager.addEventListener(new ConnectionStateHandler());
        }

        public DisconnectAction() {
            this(GuiCoreMediator.getConnectionManager());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.instance().disconnect();
        }

        private class ConnectionStateHandler
        implements ConnectionLifecycleListener {
            private ConnectionStateHandler() {
            }

            public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
                DisconnectAction.this.setEnabled(DisconnectAction.this.manager.isConnected() || DisconnectAction.this.manager.isConnecting());
            }
        }
    }

    public static class ConnectAction
    extends AbstractAction {
        private final ConnectionManager manager;

        public ConnectAction(ConnectionManager connectionManager) {
            super(I18n.tr("C&onnect"));
            this.putValue("LongDescription", I18n.tr("Connect to the Network"));
            this.manager = connectionManager;
            this.setEnabled(!connectionManager.isConnected() && !connectionManager.isConnecting());
            connectionManager.addEventListener(new ConnectionStateHandler());
        }

        public ConnectAction() {
            this(GuiCoreMediator.getConnectionManager());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.instance().connect();
        }

        private class ConnectionStateHandler
        implements ConnectionLifecycleListener {
            private ConnectionStateHandler() {
            }

            public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
                ConnectAction.this.setEnabledLater(!ConnectAction.this.manager.isConnected() && !ConnectAction.this.manager.isConnecting());
            }
        }
    }
}

