/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.limewire.collection.NameValue;
import org.limewire.util.I18NConvert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchXMLFieldAction
extends AbstractAction {
    private NameValue<?> displayPair;
    private String name;
    private String value;
    private NamedMediaType nm;

    public SearchXMLFieldAction(NameValue<?> nameValue, String string, String string2, NamedMediaType namedMediaType) {
        this.displayPair = nameValue;
        this.name = string;
        this.value = string2;
        this.nm = namedMediaType;
        String string3 = MessageFormat.format(I18n.tr("Search for {0}: {1}"), nameValue.getName(), nameValue.getValue());
        if (string3.length() > 80) {
            string3 = string3.substring(0, 80) + "...";
        }
        this.putValue("Name", string3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        NameValue<String> nameValue = new NameValue<String>(this.name, I18NConvert.instance().getNorm(this.value));
        String string = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(Collections.singletonList(nameValue), this.nm.getSchema().getSchemaURI()).getXMLString();
        SearchMediator.triggerSearch(SearchInformation.createTitledKeywordSearch(QueryUtils.createQueryString(this.value, true), string, this.nm.getMediaType(), this.displayPair.getName() + ": " + this.displayPair.getValue()));
        GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
    }
}

