/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.banner;

import com.limegroup.gnutella.gui.banner.Ad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Banner {
    private static final Banner DEFAULT_BANNER = new Banner("Only search results with a {0} are official FrostWire communications.", "http://www.frostwire.com/results", "1.0f");
    private final List<Ad> ads;

    public Banner(String ... stringArray) {
        if (stringArray.length % 3 != 0) {
            throw new IllegalArgumentException();
        }
        this.ads = new ArrayList<Ad>(stringArray.length / 3);
        for (int i = 0; i < stringArray.length; i += 3) {
            this.ads.add(new Ad(stringArray[i], stringArray[i + 1], Float.valueOf(stringArray[i + 2]).floatValue()));
        }
        Collections.sort(this.ads);
        float f = 0.0f;
        for (Ad ad : this.ads) {
            f += ad.getProbability();
        }
        if ((double)f < 0.9999 || (double)f > 1.0) {
            throw new IllegalArgumentException("wrong probabilities: " + f);
        }
    }

    public Ad getAd() {
        float f = (float)Math.random();
        float f2 = 0.0f;
        for (Ad ad : this.ads) {
            if (!((f2 += ad.getProbability()) >= f)) continue;
            return ad;
        }
        return this.ads.get(this.ads.size() - 1);
    }

    public Collection<Ad> getAllAds() {
        return Collections.unmodifiableCollection(this.ads);
    }

    public static Banner getDefaultBanner() {
        return DEFAULT_BANNER;
    }
}

