/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChatUIManager {
    private static final ChatUIManager INSTANCE = new ChatUIManager();
    private Map<InstantMessenger, ChatFrame> _chats = new HashMap<InstantMessenger, ChatFrame>();

    private ChatUIManager() {
    }

    public static ChatUIManager instance() {
        return INSTANCE;
    }

    public ChatFrame acceptChat(InstantMessenger instantMessenger) {
        ChatFrame chatFrame = this.raiseExistingFrame(instantMessenger);
        if (chatFrame != null) {
            this._chats.remove(chatFrame.getChat());
            chatFrame.chatAvailable(instantMessenger);
        } else {
            final ChatFrame chatFrame2 = new ChatFrame(instantMessenger);
            chatFrame2.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    chatFrame2.getChat().stop();
                    ChatUIManager.this.removeChat(chatFrame2.getChat());
                }
            });
            chatFrame2.setVisible(true);
            chatFrame = chatFrame2;
        }
        this._chats.put(instantMessenger, chatFrame);
        return chatFrame;
    }

    private ChatFrame raiseExistingFrame(InstantMessenger instantMessenger) {
        for (InstantMessenger instantMessenger2 : this._chats.keySet()) {
            if (!instantMessenger2.getHost().equals(instantMessenger.getHost())) continue;
            ChatFrame chatFrame = this._chats.get(instantMessenger2);
            chatFrame.setState(0);
            chatFrame.toFront();
            return chatFrame;
        }
        return null;
    }

    public void removeChat(InstantMessenger instantMessenger) {
        ChatFrame chatFrame = this._chats.remove(instantMessenger);
        if (chatFrame != null) {
            chatFrame.dispose();
            chatFrame.setVisible(false);
        }
    }

    public void receiveMessage(InstantMessenger instantMessenger, String string) {
        ChatFrame chatFrame = this._chats.get(instantMessenger);
        if (chatFrame == null) {
            return;
        }
        chatFrame.addResponse(string);
    }

    public void chatUnavailable(InstantMessenger instantMessenger) {
        ChatFrame chatFrame = this._chats.get(instantMessenger);
        if (chatFrame == null) {
            return;
        }
        chatFrame.chatUnavailable();
    }

    public void chatErrorMessage(InstantMessenger instantMessenger, String string) {
        ChatFrame chatFrame = this._chats.get(instantMessenger);
        if (chatFrame == null) {
            return;
        }
        chatFrame.displayErrorMessage(string);
    }

    public Collection<ChatFrame> getChatFrames() {
        return this._chats.values();
    }

    public void clear() {
        for (ChatFrame chatFrame : this.getChatFrames()) {
            chatFrame.getChat().stop();
            chatFrame.dispose();
        }
        this._chats.clear();
    }
}

