/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.connection.ConnectionButtons;
import com.limegroup.gnutella.gui.connection.ConnectionDataLine;
import com.limegroup.gnutella.gui.connection.ConnectionModel;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionMediator
extends AbstractTableMediator<ConnectionModel, ConnectionDataLine, RoutedConnection> {
    ActionListener ADD_LISTENER;
    ActionListener BROWSE_HOST_LISTENER;
    private static final String IS_ULTRAPEER = I18n.tr("Ultrapeer");
    private static final String IS_LEAF = I18n.tr("Leaf");
    private static final String CONNECTING = I18n.tr("Connecting");
    private static final String LEAVES = I18n.tr("Leaves");
    private static final String ULTRAPEERS = I18n.tr("Ultrapeers");
    private static final String PEERS = I18n.tr("Peers");
    private static final String STANDARD = I18n.tr("Standard");
    private static final ConnectionMediator INSTANCE = new ConnectionMediator();
    private JLabel SERVENT_STATUS;
    private JLabel NEIGHBORS;

    public static ConnectionMediator instance() {
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.ADD_LISTENER = new AddListener();
        this.BROWSE_HOST_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionMediator.this.doBrowseHost();
            }
        };
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void addListeners() {
        super.addListeners();
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new ConnectionModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new ConnectionButtons(this).getComponent();
        this.SERVENT_STATUS = new JLabel("");
        this.NEIGHBORS = new JLabel("");
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLER);
    }

    @Override
    protected JComponent getScrolledTablePane() {
        JComponent jComponent = super.getScrolledTablePane();
        this.SCROLL_PANE.setPreferredSize(new Dimension(3000, 5000));
        return jComponent;
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Connections Window..."));
    }

    @Override
    protected void setupMainPanel() {
        if (this.MAIN_PANEL == null) {
            return;
        }
        super.setupMainPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.SERVENT_STATUS, "West");
        jPanel.add((Component)this.NEIGHBORS, "East");
        this.MAIN_PANEL.add((Component)jPanel, 0);
    }

    private ConnectionMediator() {
        super("CONNECTION_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        this.doRefresh();
    }

    @Override
    public void removeSelection() {
        int[] nArray = this.TABLE.getSelectedRows();
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            RoutedConnection routedConnection = (RoutedConnection)((ConnectionDataLine)((ConnectionModel)this.DATA_MODEL).get(n)).getInitializeObject();
            GuiCoreMediator.getConnectionServices().removeConnection(routedConnection);
        }
        this.clearSelection();
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Add..."));
        jMenuItem.addActionListener(this.ADD_LISTENER);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(I18n.tr("Remove"));
        jMenuItem.addActionListener(this.REMOVE_LISTENER);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(I18n.tr("Browse Host"));
        jMenuItem.addActionListener(this.BROWSE_HOST_LISTENER);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    @Override
    public void handleSelection(int n) {
        this.setButtonEnabled(1, true);
        this.setButtonEnabled(2, true);
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
    }

    @Override
    public void handleActionKey() {
        this.doBrowseHost();
    }

    private void doBrowseHost() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length > 0) {
            RoutedConnection routedConnection = (RoutedConnection)((ConnectionDataLine)((ConnectionModel)this.DATA_MODEL).get(nArray[0])).getInitializeObject();
            GUIMediator.instance().doBrowseHost(routedConnection);
        }
    }

    @Override
    public void doRefresh() {
        super.doRefresh();
        this.SERVENT_STATUS.setText(I18n.tr("Connection Status:") + "  " + (GuiCoreMediator.getConnectionServices().isSupernode() ? IS_ULTRAPEER : IS_LEAF) + "      ");
        int[] nArray = ((ConnectionModel)this.DATA_MODEL).getConnectionInfo();
        this.NEIGHBORS.setText("(" + nArray[1] + " " + ULTRAPEERS + ", " + nArray[2] + " " + PEERS + ", " + nArray[3] + " " + LEAVES + ", " + nArray[0] + " " + CONNECTING + ", " + nArray[4] + " " + STANDARD + ")");
    }

    public int getConnectingCount() {
        return ((ConnectionModel)this.DATA_MODEL).getConnectingCount();
    }

    private void tryConnection(final String string, final int n, final SocketsManager.ConnectType connectType) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                GuiCoreMediator.getConnectionServices().connectToHostAsynchronously(string, n, connectType);
            }
        });
    }

    public void clearConnections() {
        ((ConnectionModel)this.DATA_MODEL).clear();
    }

    void addKnownHost(String string, int n) {
    }

    private final class AddListener
    implements ActionListener {
        private JDialog dialog = null;
        private AutoCompleteTextField HOST_INPUT = new ClearableAutoCompleteTextField(20);
        private JTextField PORT_INPUT = new WholeNumberField(6346, 4);
        private JButton OK_BUTTON = new JButton(I18n.tr("OK"));
        private JButton CANCEL_BUTTON = new JButton(I18n.tr("Cancel"));
        private JCheckBox TLS_BOX = new JCheckBox();

        private AddListener() {
        }

        private void createDialog() {
            if (this.dialog != null) {
                return;
            }
            this.dialog = new JDialog(GUIMediator.getAppFrame(), I18n.tr("Add Gnutella Connection"), true);
            JPanel jPanel = (JPanel)this.dialog.getContentPane();
            GUIUtils.addHideAction(jPanel);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 6;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(n, n, 0, 0);
            gridBagConstraints.gridwidth = -1;
            jPanel.add((Component)new JLabel(I18n.tr("Host:")), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(n, n, 0, n);
            jPanel.add((Component)this.HOST_INPUT, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.insets = new Insets(n, n, 0, 0);
            jPanel.add((Component)new JLabel(I18n.tr("Port:")), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(n, n, 0, n);
            jPanel.add((Component)this.PORT_INPUT, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.insets = new Insets(n, n, 0, 0);
            jPanel.add((Component)new JLabel(I18n.tr("Use TLS:")), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(n, n, 0, n);
            jPanel.add((Component)this.TLS_BOX, gridBagConstraints);
            JPanel jPanel2 = new JPanel();
            this.OK_BUTTON.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = AddListener.this.HOST_INPUT.getText();
                    String string2 = AddListener.this.PORT_INPUT.getText();
                    int n = string.lastIndexOf(58);
                    if (n != -1) {
                        AddListener.this.PORT_INPUT.setText(string.substring(n + 1));
                        string2 = AddListener.this.PORT_INPUT.getText();
                        AddListener.this.HOST_INPUT.setText(string.substring(0, n));
                        string = AddListener.this.HOST_INPUT.getText();
                    }
                    int n2 = -1;
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = 6346;
                    }
                    if (!NetworkUtils.isValidPort(n2)) {
                        n2 = 6346;
                    }
                    AddListener.this.PORT_INPUT.setText("" + n2);
                    if (!string.equals("")) {
                        ConnectionMediator.this.tryConnection(string, n2, AddListener.this.TLS_BOX.isSelected() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN);
                        AddListener.this.dialog.setVisible(false);
                        AddListener.this.dialog.dispose();
                    } else {
                        AddListener.this.HOST_INPUT.requestFocus();
                    }
                }
            });
            this.CANCEL_BUTTON.addActionListener(GUIUtils.getDisposeAction());
            jPanel2.add(this.OK_BUTTON);
            jPanel2.add(this.CANCEL_BUTTON);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(n, n, n, n);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)jPanel2, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.dialog.getRootPane().setDefaultButton(this.OK_BUTTON);
            this.dialog.pack();
            GUIUtils.centerOnScreen(this.dialog);
            this.dialog.setVisible(true);
        }
    }
}

