/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.FileTransfer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferable
implements Transferable {
    private final List<File> files;
    private final List<? extends FileTransfer> lazyFiles;
    public static final DataFlavor URIFlavor = FileTransferable.createURIFlavor();
    public static final List<? extends FileTransfer> EMPTY_FILE_TRANSFER_LiST = Collections.emptyList();
    public static final List<File> EMPTY_FILE_LIST = Collections.emptyList();

    static DataFlavor createURIFlavor() {
        try {
            return new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public FileTransferable(List<File> list) {
        this(list, EMPTY_FILE_TRANSFER_LiST);
    }

    public FileTransferable(List<File> list, List<? extends FileTransfer> list2) {
        if (list == null) {
            throw new NullPointerException("realFiles must not be null");
        }
        if (list2 == null) {
            throw new NullPointerException("lazyFiles must not be empty");
        }
        this.files = new ArrayList<File>(list);
        this.lazyFiles = new ArrayList<FileTransfer>(list2);
    }

    private List<File> getFiles() {
        if (!this.lazyFiles.isEmpty()) {
            for (FileTransfer fileTransfer : this.lazyFiles) {
                File file = fileTransfer.getFile();
                if (file == null) continue;
                this.files.add(file);
            }
            this.lazyFiles.clear();
        }
        return this.files;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.getFiles();
        }
        if (URIFlavor.equals(dataFlavor)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = System.getProperty("line.separator");
            for (File file : this.getFiles()) {
                URI uRI = file.toURI();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(uRI.toString());
            }
            return stringBuilder.toString();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (OSUtils.isWindows()) {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, URIFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.javaFileListFlavor) || dataFlavor.equals(URIFlavor);
    }
}

