/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dock;

import com.limegroup.gnutella.gui.dock.Dock;
import com.limegroup.gnutella.gui.dock.DockIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;

public class DockIconMacOSXImpl
implements DockIcon {
    private static final int MAX_NUMBER = 999999;
    private static final int MIN_WnH = 42;
    private final Color FROM = new Color(224, 0, 0);
    private final Color TO = new Color(192, 0, 0);
    private final Font FONT = new Font("Lucida Grande", 1, 24);
    private int complete = 0;

    void register(ServiceRegistry serviceRegistry) {
        serviceRegistry.register(new Service(){

            public void start() {
            }

            @Asynchronous(daemon=false)
            public void stop() {
                Dock.restoreDockTileImage();
            }

            public void initialize() {
            }

            public String getServiceName() {
                return "Dock cleanup";
            }
        }).in("UIHack");
    }

    public int getIconWidth() {
        return 128;
    }

    public int getIconHeight() {
        return 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(int n) {
        Object object = Dock.getDockLock();
        synchronized (object) {
            if (n != this.complete) {
                this.complete = n;
                Dock.restoreDockTileImage();
                if (n > 0) {
                    Dock.setDockTileOverlayImage(this);
                }
            }
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        String string = Integer.toString(Math.min(this.complete, 999999));
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.FONT);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = 42;
        if (string.length() > 2) {
            n4 = Math.max(n3 + 16, n4);
        }
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n + 128 - n4 - 5, n2 + 128 - 55, n4, 42.0f, 42.0f, 42.0f);
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.FROM, float_.width, float_.height, this.TO));
        graphics2D.fill(float_);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(float_);
        graphics2D.setPaint(Color.white);
        graphics2D.drawString(string, float_.x + (float_.width - (float)n3) / 2.0f, float_.y + (float)fontMetrics.getHeight());
    }
}

