/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.frostwire.FrostWireUtils;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.gui.TorrentDownloadFactory;
import com.limegroup.bittorrent.gui.TorrentFileFetcher;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.dock.DockIcon;
import com.limegroup.gnutella.gui.dock.DockIconFactoryImpl;
import com.limegroup.gnutella.gui.download.DownloadButtons;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadModel;
import com.limegroup.gnutella.gui.download.DownloadTransferHandler;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SimpleColumnListener;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DownloadMediator
extends AbstractTableMediator<DownloadModel, DownloadDataLine, Downloader>
implements FileDetailsProvider {
    private static final Log LOG = LogFactory.getLog(DownloadMediator.class);
    @InspectablePrimitive(value="resume button clicks")
    private static volatile int resumeClicks;
    private static int _totalDownloads;
    private static boolean _audioLaunched;
    private static DownloadMediator _instance;
    private Action removeAction;
    private Action chatAction;
    private Action clearAction;
    private Action browseAction;
    private Action launchAction;
    private Action resumeAction;
    private Action pauseAction;
    private Action priorityUpAction;
    private Action priorityDownAction;
    private Action editLocationAction;
    private Action magnetAction;
    private Action bitziAction;
    private Action exploreAction;
    private DownloadButtons _downloadButtons;
    private final DockIcon dockIcon;

    public static DownloadMediator instance() {
        return _instance;
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new DownloadTransferHandler());
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.removeAction = new RemoveAction();
        this.chatAction = new ChatAction();
        this.clearAction = new ClearAction();
        this.browseAction = new BrowseAction();
        this.launchAction = new LaunchAction();
        this.resumeAction = new ResumeAction();
        this.pauseAction = new PauseAction();
        this.priorityUpAction = new PriorityUpAction();
        this.priorityDownAction = new PriorityDownAction();
        this.editLocationAction = new EditLocationAction();
        this.magnetAction = new CopyMagnetLinkToClipboardAction(this);
        this.exploreAction = new ExploreAction();
        this.bitziAction = new BitziLookupAction(this);
    }

    public Action[] getActions() {
        Action[] actionArray = OSUtils.isWindows() || OSUtils.isMacOSX() ? new Action[]{this.priorityUpAction, this.priorityDownAction, this.resumeAction, this.pauseAction, this.launchAction, this.exploreAction, this.clearAction, this.removeAction} : new Action[]{this.priorityUpAction, this.priorityDownAction, this.resumeAction, this.pauseAction, this.launchAction, this.clearAction, this.removeAction};
        return actionArray;
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(I18n.tr("Downloads"));
        this.DATA_MODEL = new DownloadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this._downloadButtons = new DownloadButtons(this);
        this.BUTTON_ROW = this._downloadButtons.getComponent();
    }

    @Override
    protected void setupTableHeaders() {
        super.setupTableHeaders();
        Object object = ((DownloadModel)this.DATA_MODEL).getColumnId(0);
        this._downloadButtons.setQueuePanelVisible(this.TABLE.isColumnVisible(object));
        ColumnPreferenceHandler columnPreferenceHandler = this.TABLE.getColumnPreferenceHandler();
        columnPreferenceHandler.setSimpleColumnListener(new SimpleColumnListener(){

            public void columnAdded(LimeTableColumn limeTableColumn, LimeJTable limeJTable) {
                assert (limeJTable == DownloadMediator.this.TABLE);
                if (limeTableColumn.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(true);
                }
            }

            public void columnRemoved(LimeTableColumn limeTableColumn, LimeJTable limeJTable) {
                assert (limeJTable == DownloadMediator.this.TABLE);
                if (limeTableColumn.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(false);
                }
            }
        });
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Download Window..."));
    }

    private DownloadMediator() {
        super("DOWNLOAD_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        if (this.SETTINGS.REAL_TIME_SORT.getValue()) {
            ((DownloadModel)this.DATA_MODEL).sort(0);
        }
        this.dockIcon = new DockIconFactoryImpl().createDockIcon();
    }

    @Override
    public void doRefresh() {
        boolean bl = (Boolean)((DownloadModel)this.DATA_MODEL).refresh();
        this.clearAction.setEnabled(bl);
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length > 0) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[0]);
            if (downloadDataLine.getState() == Downloader.DownloadStatus.WAITING_FOR_USER) {
                this.resumeAction.putValue("Name", I18n.tr("Find More Sources for Download"));
                this.resumeAction.putValue("LimeShortName", I18n.tr("Find Sources"));
                this.resumeAction.putValue("ShortDescription", I18n.tr("Try to Find Additional Sources for Downloads"));
            } else {
                this.resumeAction.putValue("Name", I18n.tr("Resume Download"));
                this.resumeAction.putValue("LimeShortName", I18n.tr("Resume"));
                this.resumeAction.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
            }
            Downloader downloader = downloadDataLine.getDownloader();
            boolean bl2 = downloadDataLine.isDownloaderInactive();
            boolean bl3 = downloader.isResumable();
            boolean bl4 = downloader.isPausable();
            boolean bl5 = downloader.isCompleted();
            this.resumeAction.setEnabled(bl3);
            this.pauseAction.setEnabled(bl4);
            this.priorityUpAction.setEnabled(bl2 && bl4);
            this.priorityDownAction.setEnabled(bl2 && bl4);
            this.exploreAction.setEnabled(bl5 || bl2);
        }
        this.dockIcon.draw(this.getCompleteDownloads());
    }

    public int getCompleteDownloads() {
        int n = 0;
        for (int i = 0; i < ((DownloadModel)this.DATA_MODEL).getRowCount(); ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(i);
            if (downloadDataLine.getState() != Downloader.DownloadStatus.COMPLETE) continue;
            ++n;
        }
        return n;
    }

    public int getTotalDownloads() {
        return _totalDownloads;
    }

    public int getCurrentDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getCurrentDownloads();
    }

    public int getActiveDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getRowCount();
    }

    public Set<String> getFileNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < ((DownloadModel)this.DATA_MODEL).getRowCount(); ++i) {
            hashSet.add(((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(i)).getFileName());
        }
        return hashSet;
    }

    public double getActiveDownloadsBandwidth() {
        return ((DownloadModel)this.DATA_MODEL).getActiveDownloadsBandwidth();
    }

    @Override
    public void add(Downloader downloader) {
        if (downloader != null && downloader.getFile() != null && downloader.getFile().getName().startsWith("hostiles.txt.")) {
            return;
        }
        if (!((DownloadModel)this.DATA_MODEL).contains(downloader)) {
            ++_totalDownloads;
            super.add(downloader);
        }
    }

    @Override
    public void remove(Downloader downloader) {
        Object object;
        Downloader.DownloadStatus downloadStatus = downloader.getState();
        if (downloadStatus == Downloader.DownloadStatus.COMPLETE && this.isThemeFile(downloader.getSaveFile().getName())) {
            object = downloader.getDownloadFragment();
            object = this.copyToThemeDir((File)object);
            if (OptionsMediator.instance().isOptionsVisible()) {
                GUIMediator.showMessage(I18n.tr("You have downloaded a skin titled \"{0}\", you can activate the new skin by clicking \"{1}\" in the \"{2}\"->\"{3}\" menu and then selecting it from the list of available skins.", ThemeSettings.formatName(downloader.getSaveFile().getName()), I18n.tr("&Refresh Skins"), I18n.tr("&View"), I18n.tr("&Apply Skins")));
            } else {
                DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("You have downloaded a new skin titled {0}. Would you like to use this new skin?", ThemeSettings.formatName(downloader.getSaveFile().getName())), QuestionsHandler.THEME_DOWNLOADED, DialogOption.YES);
                if (dialogOption == DialogOption.YES) {
                    ThemeMediator.changeTheme((File)object);
                }
            }
        }
        if (downloadStatus == Downloader.DownloadStatus.COMPLETE && BittorrentSettings.TORRENT_AUTO_START.getValue() && this.isTorrentFile(downloader.getSaveFile().getName())) {
            GUIMediator.instance().openTorrent(downloader.getSaveFile());
        }
        if (SharingSettings.CLEAR_DOWNLOAD.getValue() && (downloadStatus == Downloader.DownloadStatus.COMPLETE || downloadStatus == Downloader.DownloadStatus.ABORTED)) {
            super.remove(downloader);
        } else {
            object = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(downloader);
            if (object != null) {
                ((DownloadDataLine)object).setEndTime(System.currentTimeMillis());
            }
        }
    }

    public void openTorrent(File file) {
        block7: {
            try {
                TorrentDownloadFactory torrentDownloadFactory = new TorrentDownloadFactory(file);
                DownloaderUtils.createDownloader(torrentDownloadFactory);
                if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
                    FrostWireUtils.shareTorrent(file);
                    BTMetaInfo bTMetaInfo = torrentDownloadFactory.getBTMetaInfo();
                    if (bTMetaInfo == null) {
                        return;
                    }
                    File file2 = GuiCoreMediator.getTorrentManager().getSharedTorrentMetaDataFile(bTMetaInfo);
                    File file3 = null;
                    if (file2.exists()) {
                        if (file2.equals(file)) {
                            return;
                        }
                        GuiCoreMediator.getFileManager().stopSharingFile(file2);
                        file3 = new File(file2.getParent(), file2.getName().concat(".bak"));
                        FileUtils.forceRename(file2, file3);
                    }
                    if (!FileUtils.copy(file, file2) && file3 != null && FileUtils.forceRename(file3, file2)) {
                        GuiCoreMediator.getFileManager().addFileIfShared(file2);
                    }
                }
            }
            catch (IOException iOException) {
                if (iOException.toString().contains("No files selected by user")) break block7;
                GUIMediator.showError(I18n.tr("FrostWire was unable to load the torrent file \"{0}\", - it may be malformed or FrostWire does not have permission to access this file.", file.getName()), QuestionsHandler.TORRENT_OPEN_FAILURE);
            }
        }
    }

    public void openTorrentURI(URI uRI) {
        TorrentFileFetcher torrentFileFetcher = new TorrentFileFetcher(uRI, GuiCoreMediator.getDownloadManager());
        this.add(torrentFileFetcher);
        torrentFileFetcher.fetch();
    }

    private File copyToThemeDir(File file) {
        File file2 = ThemeSettings.THEME_DIR_FILE;
        File file3 = new File(file2, file.getName());
        if (file3.equals(file)) {
            return file;
        }
        file3.delete();
        FileUtils.copy(file, file3);
        return file3;
    }

    private boolean isThemeFile(String string) {
        return string.toLowerCase().endsWith("fwtp");
    }

    private boolean isTorrentFile(String string) {
        return string.toLowerCase().endsWith(".torrent");
    }

    void launchSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        GUILauncher.LaunchableProvider[] launchableProviderArray = new GUILauncher.LaunchableProvider[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            launchableProviderArray[i] = new DownloaderProvider(((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[i])).getDownloader());
        }
        GUILauncher.launch(launchableProviderArray);
    }

    void pauseSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            ((Downloader)((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[i])).getInitializeObject()).pause();
        }
    }

    void launchExplorer() {
        int[] nArray = this.TABLE.getSelectedRows();
        Downloader downloader = (Downloader)((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[nArray.length - 1])).getInitializeObject();
        File file = downloader.getFile();
        if (file == null) {
            return;
        }
        GUIMediator.launchExplorer(file);
    }

    void bumpPriority(final boolean bl, int n) {
        int n2;
        int[] nArray = this.TABLE.getSelectedRows();
        DownloadDataLine[] downloadDataLineArray = new DownloadDataLine[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            downloadDataLineArray[n2] = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[n2]);
        }
        Arrays.sort(downloadDataLineArray, new Comparator<DownloadDataLine>(){

            @Override
            public int compare(DownloadDataLine downloadDataLine, DownloadDataLine downloadDataLine2) {
                int n;
                int n2 = ((Downloader)downloadDataLine.getInitializeObject()).getInactivePriority();
                return (n2 < (n = ((Downloader)downloadDataLine2.getInitializeObject()).getInactivePriority()) ? -1 : (n2 > n ? 1 : 0)) * (bl ? 1 : -1);
            }
        });
        for (n2 = 0; n2 < downloadDataLineArray.length; ++n2) {
            Downloader downloader = (Downloader)downloadDataLineArray[n2].getInitializeObject();
            GuiCoreMediator.getDownloadManager().bumpPriority(downloader, bl, n);
        }
    }

    FileTransfer[] getSelectedFileTransfers() {
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList<FileTransfer> arrayList = new ArrayList<FileTransfer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[i]);
            Downloader downloader = downloadDataLine.getDownloader();
            if (downloader.getState() == Downloader.DownloadStatus.COMPLETE && !downloader.getSaveFile().exists() || !downloader.isLaunchable()) continue;
            arrayList.add(downloadDataLine.getFileTransfer());
        }
        return arrayList.toArray(new FileTransfer[arrayList.size()]);
    }

    void resumeSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[i]);
            Downloader downloader = downloadDataLine.getDownloader();
            if (downloadDataLine.isCleaned()) continue;
            downloader.resume();
        }
        ++resumeClicks;
    }

    void chatWithSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[i]);
            Downloader downloader = (Downloader)downloadDataLine.getInitializeObject();
            Endpoint endpoint = downloader.getChatEnabledHost();
            if (endpoint == null) continue;
            GUIMediator.createChat(endpoint.getAddress(), endpoint.getPort());
        }
    }

    void editSelectedDownload() {
        File file;
        int[] nArray = this.TABLE.getSelectedRows();
        Downloader downloader = (Downloader)((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[0])).getInitializeObject();
        File file2 = downloader.getSaveFile();
        File file3 = file = downloader instanceof BTDownloader ? FileChooserHandler.getSaveAsDir(MessageService.getParentComponent(), I18nMarker.marktr("Choose Save Location"), file2) : FileChooserHandler.getSaveAsFile(MessageService.getParentComponent(), I18nMarker.marktr("Choose Save Location"), file2);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        if (string.toLowerCase().startsWith(FrostWireUtils.getInstallationFolder().toLowerCase())) {
            GUIMediator.showError(I18n.tr("Invalid folder for saving files. Please use another folder or revert to the default."));
            return;
        }
        try {
            if (!file.equals(downloader.getSaveFile())) {
                downloader.setSaveFile(file.getParentFile(), file.getName(), false);
            }
        }
        catch (SaveLocationException saveLocationException) {
            CoreExceptionHandler.handleSaveLocationError(saveLocationException);
        }
    }

    void browseSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[i]);
            Downloader downloader = (Downloader)downloadDataLine.getInitializeObject();
            RemoteFileDesc remoteFileDesc = downloader.getBrowseEnabledHost();
            if (remoteFileDesc == null) continue;
            SearchMediator.doBrowseHost(remoteFileDesc);
        }
    }

    @Override
    public void handleActionKey() {
        if (this.launchAction.isEnabled()) {
            this.launchSelectedDownloads();
        }
    }

    void clearCompletedDownloads() {
        ((DownloadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.clearAction.setEnabled(false);
        this.dockIcon.draw(0);
    }

    @Override
    public FileDetails[] getFileDetails() {
        int[] nArray = this.TABLE.getSelectedRows();
        FileManager fileManager = GuiCoreMediator.getFileManager();
        ArrayList<FileDetails> arrayList = new ArrayList<FileDetails>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            URN uRN = ((DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[i])).getDownloader().getSha1Urn();
            if (uRN != null) {
                FileDesc fileDesc = fileManager.getFileDescForUrn(uRN);
                if (fileDesc != null) {
                    arrayList.add(GuiCoreMediator.getLocalFileDetailsFactory().create(fileDesc));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("not filedesc for urn " + uRN);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("no urn");
        }
        return arrayList.toArray(new FileDetails[0]);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(this.removeAction));
        jPopupMenu.add(new JMenuItem(this.resumeAction));
        jPopupMenu.add(new JMenuItem(this.pauseAction));
        jPopupMenu.add(new JMenuItem(this.launchAction));
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            jPopupMenu.add(new JMenuItem(this.exploreAction));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(this.clearAction));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createSearchMenu());
        jPopupMenu.add(new JMenuItem(this.chatAction));
        jPopupMenu.add(new JMenuItem(this.browseAction));
        jPopupMenu.add(new JMenuItem(this.editLocationAction));
        return jPopupMenu;
    }

    private JMenu createSearchMenu() {
        SearchInformation searchInformation;
        int n;
        Object object;
        JMenu jMenu = new JMenu(I18n.tr("Search..."));
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length == 0) {
            jMenu.setEnabled(false);
            return jMenu;
        }
        DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(nArray[0]);
        Downloader downloader = downloadDataLine.getDownloader();
        Map map = (Map)downloader.getAttribute("searchInformationMap");
        if (map != null) {
            object = SearchInformation.createFromMap(map);
            jMenu.add(new JMenuItem(new SearchAction((SearchInformation)object)));
        }
        if ((n = ((String)(object = downloadDataLine.getFileName())).lastIndexOf(46)) > 0) {
            object = ((String)object).substring(0, n);
        }
        if (((String)(object = QueryUtils.removeIllegalChars((String)object))).length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            object = ((String)object).substring(0, SearchSettings.MAX_QUERY_LENGTH.getValue());
        }
        if (SearchMediator.validateInfo(searchInformation = SearchInformation.createKeywordSearch((String)object, null, MediaType.getAnyTypeMediaType())) == 0) {
            jMenu.add(new JMenuItem(new SearchAction(searchInformation, I18nMarker.marktr("Search for Keywords: {0}"))));
        }
        return jMenu;
    }

    @Override
    public void handleSelection(int n) {
        DownloadDataLine downloadDataLine = (DownloadDataLine)((DownloadModel)this.DATA_MODEL).get(n);
        this.chatAction.setEnabled(downloadDataLine.getChatEnabled());
        this.browseAction.setEnabled(downloadDataLine.getBrowseEnabled());
        boolean bl = downloadDataLine.isDownloaderInactive();
        boolean bl2 = downloadDataLine.getDownloader().isPausable();
        if (downloadDataLine.getState() == Downloader.DownloadStatus.WAITING_FOR_USER) {
            this.resumeAction.putValue("Name", I18n.tr("Find More Sources for Download"));
            this.resumeAction.putValue("LimeShortName", I18n.tr("Find Sources"));
            this.resumeAction.putValue("ShortDescription", I18n.tr("Try to Find Additional Sources for Downloads"));
        } else {
            this.resumeAction.putValue("Name", I18n.tr("Resume Download"));
            this.resumeAction.putValue("LimeShortName", I18n.tr("Resume"));
            this.resumeAction.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
        }
        if (downloadDataLine.isCompleted()) {
            this.removeAction.putValue("Name", I18n.tr("Clear Download"));
            this.removeAction.putValue("LimeShortName", I18n.tr("Clear"));
            this.removeAction.putValue("ShortDescription", I18n.tr("Clear Selected Downloads"));
            this.launchAction.putValue("Name", I18n.tr("Launch Download"));
            this.launchAction.putValue("LimeShortName", I18n.tr("Launch"));
            this.launchAction.putValue("ShortDescription", I18n.tr("Launch Selected Downloads"));
            this.exploreAction.setEnabled(this.TABLE.getSelectedRowCount() == 1);
        } else {
            this.removeAction.putValue("Name", I18n.tr("Cancel Download"));
            this.removeAction.putValue("LimeShortName", I18n.tr("Cancel"));
            this.removeAction.putValue("ShortDescription", I18n.tr("Cancel Selected Downloads"));
            this.launchAction.putValue("Name", I18n.tr("Preview Download"));
            this.launchAction.putValue("LimeShortName", I18n.tr("Preview"));
            this.launchAction.putValue("ShortDescription", I18n.tr("Preview Selected Downloads"));
            this.exploreAction.setEnabled(false);
        }
        this.removeAction.setEnabled(true);
        this.resumeAction.setEnabled(bl);
        this.pauseAction.setEnabled(bl2);
        this.priorityDownAction.setEnabled(bl && bl2);
        this.priorityUpAction.setEnabled(bl && bl2);
        Downloader downloader = (Downloader)downloadDataLine.getInitializeObject();
        this.editLocationAction.setEnabled(this.TABLE.getSelectedRowCount() == 1 && downloader.isRelocatable());
        this.magnetAction.setEnabled(downloader.getSha1Urn() != null);
        this.bitziAction.setEnabled(downloader.getSha1Urn() != null);
        this.launchAction.setEnabled(downloader.isLaunchable());
    }

    @Override
    public void handleNoSelection() {
        this.removeAction.setEnabled(false);
        this.resumeAction.setEnabled(false);
        this.launchAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.chatAction.setEnabled(false);
        this.browseAction.setEnabled(false);
        this.priorityDownAction.setEnabled(false);
        this.priorityUpAction.setEnabled(false);
        this.editLocationAction.setEnabled(false);
        this.magnetAction.setEnabled(false);
        this.bitziAction.setEnabled(false);
        this.exploreAction.setEnabled(false);
    }

    static {
        _totalDownloads = 0;
        _audioLaunched = false;
        _instance = new DownloadMediator();
    }

    private static class DownloaderProvider
    implements GUILauncher.LaunchableProvider {
        private final Downloader downloader;

        public DownloaderProvider(Downloader downloader) {
            this.downloader = downloader;
        }

        public Downloader getDownloader() {
            return this.downloader;
        }

        public File getFile() {
            return null;
        }
    }

    private class EditLocationAction
    extends RefreshingAction {
        public EditLocationAction() {
            this.putValue("Name", I18n.tr("Change File Location..."));
            this.putValue("ShortDescription", I18n.tr("Edit the Final Filename of the Download"));
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.editSelectedDownload();
        }
    }

    private class PriorityDownAction
    extends RefreshingAction {
        public PriorityDownAction() {
            this.putValue("LimeShortName", "");
            this.putValue("ShortDescription", I18n.tr("Move the Selected Download Further from Becoming Active"));
            this.putValue("LimeIconName", "DOWNLOAD_PRIORITY_DOWN");
        }

        public void performAction(ActionEvent actionEvent) {
            if ((actionEvent.getModifiers() & 2) != 0) {
                DownloadMediator.this.bumpPriority(false, 10);
            } else if ((actionEvent.getModifiers() & 8) != 0) {
                DownloadMediator.this.bumpPriority(false, 0);
            } else {
                DownloadMediator.this.bumpPriority(false, 1);
            }
        }
    }

    private class PriorityUpAction
    extends RefreshingAction {
        public PriorityUpAction() {
            this.putValue("LimeShortName", "");
            this.putValue("ShortDescription", I18n.tr("Move the Selected Download Closer to Becoming Active"));
            this.putValue("LimeIconName", "DOWNLOAD_PRIORITY_UP");
        }

        public void performAction(ActionEvent actionEvent) {
            if ((actionEvent.getModifiers() & 2) != 0) {
                DownloadMediator.this.bumpPriority(true, 10);
            } else if ((actionEvent.getModifiers() & 8) != 0) {
                DownloadMediator.this.bumpPriority(true, 0);
            } else {
                DownloadMediator.this.bumpPriority(true, 1);
            }
        }
    }

    private class ExploreAction
    extends RefreshingAction {
        public ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.launchExplorer();
        }
    }

    private class PauseAction
    extends RefreshingAction {
        public PauseAction() {
            this.putValue("Name", I18n.tr("Pause Download"));
            this.putValue("LimeShortName", I18n.tr("Pause"));
            this.putValue("ShortDescription", I18n.tr("Pause Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_PAUSE");
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.pauseSelectedDownloads();
        }
    }

    private class ResumeAction
    extends RefreshingAction {
        public ResumeAction() {
            this.putValue("Name", I18n.tr("Resume Download"));
            this.putValue("LimeShortName", I18n.tr("Resume"));
            this.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_FILE_MORE_SOURCES");
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.resumeSelectedDownloads();
        }
    }

    private class LaunchAction
    extends RefreshingAction {
        public LaunchAction() {
            this.putValue("Name", I18n.tr("Preview Download"));
            this.putValue("LimeShortName", I18n.tr("Preview"));
            this.putValue("ShortDescription", I18n.tr("Preview Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_LAUNCH");
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.launchSelectedDownloads();
        }
    }

    private class BrowseAction
    extends RefreshingAction {
        public BrowseAction() {
            this.putValue("Name", I18n.tr("Browse Host"));
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.browseSelectedDownloads();
        }
    }

    private class ClearAction
    extends RefreshingAction {
        public ClearAction() {
            this.putValue("Name", I18n.tr("Clear All Inactive Downloads"));
            this.putValue("LimeShortName", I18n.tr("Clear Inactive"));
            this.putValue("ShortDescription", I18n.tr("Remove Inactive Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_CLEAR");
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.clearCompletedDownloads();
        }
    }

    private class ChatAction
    extends RefreshingAction {
        public ChatAction() {
            this.putValue("Name", I18n.tr("Chat with Host"));
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.chatWithSelectedDownloads();
        }
    }

    private class RemoveAction
    extends RefreshingAction {
        public RemoveAction() {
            this.putValue("Name", I18n.tr("Cancel Download"));
            this.putValue("LimeShortName", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_KILL");
        }

        public void performAction(ActionEvent actionEvent) {
            DownloadMediator.this.removeSelection();
        }
    }

    private abstract class RefreshingAction
    extends AbstractAction {
        private RefreshingAction() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            this.performAction(actionEvent);
            DownloadMediator.this.doRefresh();
        }

        protected abstract void performAction(ActionEvent var1);
    }
}

