/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.gui.dnd.CompositeTransferable;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableTransferable;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultTransferable;
import com.limegroup.gnutella.gui.search.TableLine;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JComponent;

class DownloadTransferHandler
extends LimeTransferHandler {
    DownloadTransferHandler() {
        super(1);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (DNDUtils.contains(dataFlavorArray, SearchResultTransferable.dataFlavor)) {
            return true;
        }
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.canImport(jComponent, dataFlavorArray);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), SearchResultTransferable.dataFlavor)) {
            try {
                SearchResultTransferable searchResultTransferable = (SearchResultTransferable)transferable.getTransferData(SearchResultTransferable.dataFlavor);
                ResultPanel resultPanel = searchResultTransferable.getResultPanel();
                TableLine[] tableLineArray = searchResultTransferable.getTableLines();
                SearchMediator.downloadFromPanel(resultPanel, tableLineArray);
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.importData(jComponent, transferable);
    }

    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        FileTransfer[] fileTransferArray = DownloadMediator.instance().getSelectedFileTransfers();
        if (fileTransferArray.length > 0) {
            return new CompositeTransferable(new LibraryTableTransferable(new LibraryTableDataLine[0]), new FileTransferable(FileTransferable.EMPTY_FILE_LIST, Arrays.asList(fileTransferArray)));
        }
        return null;
    }
}

