/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;

public class MagnetDownloaderFactory
implements GuiDownloaderFactory {
    private MagnetOptions magnet;
    private File saveFile;

    public MagnetDownloaderFactory(MagnetOptions magnetOptions) {
        this.magnet = magnetOptions;
        String string = magnetOptions.getFileNameForSaving();
        if (string == null) {
            string = I18n.tr("No Filename");
        }
        this.saveFile = new File(SharingSettings.getSaveDirectory(string), string);
        if (!magnetOptions.isDownloadable()) {
            throw new IllegalArgumentException("Invalid magnet");
        }
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setSaveFile(File file) {
        this.saveFile = file;
    }

    public long getFileSize() {
        return 0L;
    }

    public URN getURN() {
        return this.magnet.getSHA1Urn();
    }

    public Downloader createDownloader(boolean bl) throws SaveLocationException {
        return GuiCoreMediator.getDownloadServices().download(this.magnet, bl, this.saveFile.getParentFile(), this.getSaveFile().getName());
    }
}

