/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.library.DirectoryHolder;
import java.io.File;
import javax.swing.Icon;

public abstract class AbstractDirectoryHolder
implements DirectoryHolder {
    public File[] getFiles() {
        File[] fileArray = this.getDirectory().listFiles(this);
        return fileArray != null ? fileArray : new File[]{};
    }

    public boolean accept(File file) {
        if (!this.isFileVisible(file)) {
            return false;
        }
        File file2 = file.getParentFile();
        return file2 != null && file2.equals(this.getDirectory());
    }

    protected boolean isFileVisible(File file) {
        return file != null && file.exists() && file.canRead() && !file.isHidden();
    }

    public String getName() {
        return this.getDirectory().getName();
    }

    public String getDescription() {
        return this.getDirectory().getAbsolutePath();
    }

    public int size() {
        File[] fileArray = this.getFiles();
        if (fileArray == null) {
            return 0;
        }
        return fileArray.length;
    }

    public Icon getIcon() {
        return null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isStoreNode() {
        return false;
    }
}

