/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.frostwire.audio.AuxMP3Player;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerEvent;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.LimeAudioFormat;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayerState;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ThreadExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeWirePlayer
implements Runnable,
AudioPlayer,
RefreshListener {
    private static final long SLEEP_NONPLAYING = 100L;
    private static final long SLEEP_PLAYING = 150L;
    public static final int EXTERNAL_BUFFER_SIZE = 16384;
    private List<AudioPlayerListener> listenerList = new CopyOnWriteArrayList<AudioPlayerListener>();
    private Thread playerthread;
    private final LoadSongBuffer songBuffer;
    private final Object threadLock = new Object();
    private volatile PlayerState playerState = PlayerState.UNKNOWN;
    private Object seekLock = new Object();
    private long seekValue = -1L;
    private volatile boolean loadSong = false;
    private Object volumeLock = new Object();
    private boolean setVolume = false;
    private double volume = 0.0;
    private LimeAudioFormat currentAudioFormat;
    private AudioSource currentSong;
    private final byte[] buffer = new byte[16384];
    private int readBytes = 0;
    private int avail;
    private boolean usingAuxMP3Player = false;

    public LimeWirePlayer() {
        this.songBuffer = new LoadSongBuffer();
    }

    @Override
    public void addAudioPlayerListener(AudioPlayerListener audioPlayerListener) {
        this.listenerList.add(audioPlayerListener);
    }

    @Override
    public void removeAudioPlayerListener(AudioPlayerListener audioPlayerListener) {
        this.listenerList.remove(audioPlayerListener);
    }

    @Override
    public PlayerState getStatus() {
        return this.playerState;
    }

    @Override
    public void loadSong(AudioSource audioSource) {
        if (audioSource == null) {
            throw new IllegalArgumentException();
        }
        this.songBuffer.setSong(audioSource);
    }

    @Override
    public void playSong() {
        this.stop();
        this.loadSong = true;
        this.playerState = PlayerState.PLAYING;
        if (this.playerthread == null || !this.playerthread.isAlive()) {
            this.playerthread = ThreadExecutor.newManagedThread(this, "LimewirePlayer");
            this.playerthread.start();
        } else {
            if (this.currentSong != null) {
                this.loadSong(this.currentSong);
            }
            this.playing();
        }
        this.notifyEvent(PlayerState.PLAYING, -1.0);
    }

    @Override
    public void pause() {
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = PlayerState.PAUSED;
            this.notifyEvent(PlayerState.PAUSED, -1.0);
        }
    }

    @Override
    public void unpause() {
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = PlayerState.PLAYING;
            this.notifyEvent(PlayerState.PLAYING, -1.0);
        }
    }

    @Override
    public void stop() {
        this.tryStoppingAuxMP3Player();
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.STOPPED, -1.0);
            try {
                Thread.sleep(900L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void tryStoppingAuxMP3Player() {
        if (this.usingAuxMP3Player) {
            this.usingAuxMP3Player = false;
            if (AuxMP3Player.getInstance() != null) {
                AuxMP3Player.getInstance().stop();
            }
            MediaPlayerComponent.getInstance().enableControls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekLocation(long l) {
        if (this.playerState != PlayerState.UNKNOWN && this.playerState != PlayerState.STOPPED) {
            this.playerState = this.playerState == PlayerState.PAUSED || this.playerState == PlayerState.SEEKING_PAUSED ? PlayerState.SEEKING_PAUSED : PlayerState.SEEKING_PLAY;
            Object object = this.seekLock;
            synchronized (object) {
                this.seekValue = l;
            }
            this.notifyEvent(PlayerState.SEEKING, l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVolume(double d) {
        Object object = this.volumeLock;
        synchronized (object) {
            this.volume = d;
            this.setVolume = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.playerState != PlayerState.UNKNOWN) {
            if (this.playerState == PlayerState.STOPPED) {
                for (int i = 0; i < 3; ++i) {
                    if (this.playerState != PlayerState.STOPPED) continue;
                    try {
                        Object object = this.threadLock;
                        synchronized (object) {
                            this.threadLock.wait(100L);
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.playerState == PlayerState.STOPPED) {
                    this.playerState = PlayerState.UNKNOWN;
                }
            }
            if (this.currentAudioFormat != null && this.setVolume) {
                try {
                    double d = 0.0;
                    Object object = this.volumeLock;
                    synchronized (object) {
                        d = this.volume;
                        this.setVolume = false;
                    }
                    this.currentAudioFormat.setGain(d);
                    this.notifyEvent(PlayerState.GAIN, this.volume);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.loadSong) {
                if (this.currentAudioFormat != null) {
                    this.currentAudioFormat.closeStreams();
                }
                this.loadFromSongBuffer();
                if (this.currentSong != null) {
                    this.loading();
                } else {
                    this.playerState = PlayerState.STOPPED;
                }
            }
            if (this.playerState == PlayerState.PLAYING) {
                if (this.currentAudioFormat == null) {
                    this.playerState = PlayerState.STOPPED;
                    continue;
                }
                this.playing();
                continue;
            }
            if (this.playerState == PlayerState.PAUSED) {
                if (this.currentAudioFormat == null) {
                    this.playerState = PlayerState.STOPPED;
                    continue;
                }
                this.pausing();
                continue;
            }
            if (this.playerState != PlayerState.SEEKING && this.playerState != PlayerState.SEEKING_PAUSED && this.playerState != PlayerState.SEEKING_PLAY) continue;
            this.seeking();
        }
        if (this.currentAudioFormat != null) {
            this.currentAudioFormat.closeStreams();
        }
        this.currentAudioFormat = null;
        this.playerState = PlayerState.UNKNOWN;
    }

    private void loadFromSongBuffer() {
        if (this.songBuffer.hasSong()) {
            this.currentSong = this.songBuffer.getSong();
            this.loadSong = false;
        } else {
            this.loadSong = false;
            this.currentSong = null;
            this.playerState = PlayerState.STOPPED;
        }
    }

    private void loading() {
        try {
            this.tryStoppingAuxMP3Player();
            assert (this.currentSong != null);
            try {
                this.currentAudioFormat = new LimeAudioFormat(this.currentSong, 0L);
            }
            catch (IOException iOException) {
                this.usingAuxMP3Player = true;
                try {
                    AuxMP3Player.getInstance().tryPlaying(this.currentSong);
                    MediaPlayerComponent.getInstance().disableControls();
                }
                catch (Exception exception) {
                    this.usingAuxMP3Player = false;
                    MediaPlayerComponent.getInstance().enableControls();
                    exception.printStackTrace();
                    this.playerState = PlayerState.STOPPED;
                    this.notifyEvent(PlayerState.EOM, -1.0);
                }
            }
            this.readBytes = 0;
            if (this.currentAudioFormat != null) {
                this.notifyOpened(this.currentAudioFormat.getProperties());
            }
            this.playerState = PlayerState.PLAYING;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.EOM, -1.0);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.EOM, -1.0);
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.playerState = PlayerState.STOPPED;
            this.notifyEvent(PlayerState.EOM, -1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playing() {
        if (this.currentAudioFormat == null) {
            this.loading();
            if (this.currentAudioFormat == null) {
                return;
            }
        }
        assert (this.currentAudioFormat != null);
        this.currentAudioFormat.startSourceDataLine();
        this.avail = this.currentAudioFormat.getSourceDataLine().available();
        if (this.avail > 0) {
            try {
                this.readBytes = this.currentAudioFormat.getAudioInputStream().read(this.buffer, 0, Math.min(this.avail, this.buffer.length));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.playerState = PlayerState.STOPPED;
                this.notifyEvent(PlayerState.EOM, -1.0);
                this.loadSong = true;
            }
            catch (IOException iOException) {
                this.playerState = PlayerState.STOPPED;
            }
            if (this.readBytes > 0) {
                this.currentAudioFormat.getSourceDataLine().write(this.buffer, 0, this.readBytes);
                this.notifyProgress(this.currentAudioFormat.getEncodedStreamPosition());
            } else if (this.readBytes == -1) {
                this.notifyEvent(PlayerState.EOM, -1.0);
                this.loadSong = true;
                try {
                    Object object = this.threadLock;
                    synchronized (object) {
                        this.threadLock.wait(150L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            try {
                Object object = this.threadLock;
                synchronized (object) {
                    this.threadLock.wait(150L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pausing() {
        this.currentAudioFormat.stopSourceDataLine();
        try {
            Object object = this.threadLock;
            synchronized (object) {
                this.threadLock.wait(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seeking() {
        try {
            long l = 0L;
            Object object = this.seekLock;
            synchronized (object) {
                l = this.seekValue;
                this.seekValue = 0L;
            }
            if (this.currentAudioFormat != null) {
                this.currentAudioFormat.closeStreams();
            }
            this.currentAudioFormat = new LimeAudioFormat(this.currentSong, l);
            object = this.volumeLock;
            synchronized (object) {
                this.setVolume = true;
            }
            this.playerState = this.playerState == PlayerState.SEEKING_PAUSED ? PlayerState.PAUSED : PlayerState.PLAYING;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            this.playerState = PlayerState.STOPPED;
        }
        catch (IOException iOException) {
            this.playerState = PlayerState.STOPPED;
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.playerState = PlayerState.STOPPED;
        }
    }

    protected void notifyOpened(final Map<String, Object> map) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimeWirePlayer.this.fireOpened(map);
            }
        });
    }

    protected void notifyEvent(final PlayerState playerState, final double d) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimeWirePlayer.this.fireStateUpdated(new AudioPlayerEvent(playerState, d));
            }
        });
    }

    protected void notifyProgress(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimeWirePlayer.this.fireProgress(n);
            }
        });
    }

    protected void fireOpened(Map<String, Object> map) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.songOpened(map);
        }
    }

    protected void fireProgress(int n) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.progressChange(n);
        }
    }

    protected void fireStateUpdated(AudioPlayerEvent audioPlayerEvent) {
        for (AudioPlayerListener audioPlayerListener : this.listenerList) {
            audioPlayerListener.stateChange(audioPlayerEvent);
        }
    }

    @Override
    public void refresh() {
        this.notifyEvent(this.getStatus(), -1.0);
    }

    private class LoadSongBuffer {
        private AudioSource nextItem;

        private LoadSongBuffer() {
        }

        public synchronized void setSong(AudioSource audioSource) {
            this.nextItem = audioSource;
        }

        public synchronized AudioSource getSong() {
            AudioSource audioSource = this.nextItem;
            this.nextItem = null;
            return audioSource;
        }

        public synchronized boolean hasSong() {
            return this.nextItem != null;
        }
    }
}

