/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.PlayListItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayList {
    private static final Log LOG = LogFactory.getLog(PlayList.class);
    private File playListFile;
    private Vector<PlayListItem> songs;
    private boolean isDirty;
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";

    public PlayList(String string) {
        LOG.trace("PlayList(): entered.");
        this.playListFile = new File(string);
        if (this.playListFile.isDirectory()) {
            throw new IllegalArgumentException(string + " is a directory");
        }
        this.songs = new Vector();
        if (this.playListFile.exists()) {
            try {
                this.loadM3UFile();
            }
            catch (IOException iOException) {
                LOG.warn("Unable to load file: " + string, iOException);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("songs = " + this.songs);
            LOG.trace("returning.  size is now " + this.getNumSongs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadM3UFile() throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.playListFile));
            String string = null;
            string = bufferedReader.readLine();
            if (string == null) throw new IOException();
            if (!string.startsWith(M3U_HEADER) && !string.startsWith(SONG_DELIM)) {
                throw new IOException();
            }
            if (string.startsWith(M3U_HEADER)) {
                string = bufferedReader.readLine();
            }
            while (string != null) {
                if (string.startsWith(SONG_DELIM)) {
                    string = bufferedReader.readLine();
                    if (string == null) break;
                    File file = new File(string);
                    if (file.exists() && !file.isDirectory()) {
                        this.songs.add(new PlayListItem(file));
                    } else {
                        file = new File(this.playListFile.getParentFile().getAbsolutePath(), file.getPath());
                        if (file.exists() && !file.isDirectory() && FileUtils.isReallyInParentPath(this.playListFile.getParentFile(), file)) {
                            this.songs.add(new PlayListItem(file));
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            throw throwable;
        }
        IOUtils.close(bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        if (!this.isDirty) {
            return;
        }
        if (this.songs.size() == 0) {
            LOG.debug("No songs, deleting file");
            if (this.playListFile.exists()) {
                this.playListFile.delete();
            }
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(this.playListFile.getCanonicalPath(), false));
            printWriter.write(M3U_HEADER);
            printWriter.println();
            for (PlayListItem playListItem : this.songs) {
                if (!playListItem.isFile()) continue;
                File file = new File(playListItem.getURI());
                printWriter.write(SONG_DELIM);
                printWriter.write(SEC_DELIM);
                if (playListItem.getProperty("Length") != null) {
                    printWriter.write("" + playListItem.getProperty("Length") + ",");
                } else {
                    printWriter.write("-1,");
                }
                printWriter.write(playListItem.getName());
                printWriter.println();
                printWriter.write(file.getCanonicalPath());
                printWriter.println();
            }
            this.isDirty = false;
        }
        catch (Throwable throwable) {
            this.isDirty = false;
            IOUtils.close(printWriter);
            throw throwable;
        }
        IOUtils.close(printWriter);
    }

    public int getNumSongs() {
        return this.songs.size();
    }

    public synchronized List<PlayListItem> getSongs() {
        return new LinkedList<PlayListItem>(this.songs);
    }

    public synchronized void setSongs(List<? extends PlayListItem> list) {
        this.isDirty = true;
        this.songs.clear();
        this.songs.addAll(list);
    }

    public PlayListItem getSong(int n) {
        return this.songs.get(n);
    }
}

