/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.DefaultNotificationRenderer;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotificationWindow;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;
import org.limewire.util.OSUtils;

public class JDICNotifier
implements NotifyUser {
    private static final Log LOG = LogFactory.getLog(DefaultNotificationRenderer.class);
    private final SystemTray _tray = SystemTray.getDefaultSystemTray();
    private TrayIcon _icon;
    private NotificationWindow notificationWindow;

    public JDICNotifier() {
        this.buildPopupMenu();
        String string = "frosticon";
        if (OSUtils.isLinux()) {
            string = string + "_linux";
        }
        this.buildTrayIcon(I18n.tr("FrostWire"), string);
        this.buildNotificationWindow();
    }

    private void buildTrayIcon(String string, String string2) {
        this._icon = new TrayIcon(GUIMediator.getThemeImage(string2), string, GUIMediator.getTrayMenu());
        this._icon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.restoreView();
            }
        });
        this._icon.setIconAutoSize(true);
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = GUIMediator.getTrayMenu();
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Restore"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.restoreView();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(I18n.tr("About"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.showAboutWindow();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(I18n.tr("Exit after Transfers"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.shutdownAfterTransfers();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(I18n.tr("Exit"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.shutdown();
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void buildNotificationWindow() {
        this.notificationWindow = new NotificationWindow((Window)GUIMediator.getAppFrame());
        this.notificationWindow.setLocationOffset(new Dimension(2, 7));
        this.notificationWindow.setTitle("FrostWire");
        this.notificationWindow.setIcon(GUIMediator.getThemeImage("frosticon.gif"));
    }

    public boolean showTrayIcon() {
        try {
            this._tray.addTrayIcon(this._icon);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        this.notificationWindow.setParentSize(new Dimension(22, 22));
        return true;
    }

    public boolean supportsSystemTray() {
        return true;
    }

    public void hideTrayIcon() {
        this._tray.removeTrayIcon(this._icon);
        this.notificationWindow.setParentLocation(null);
        this.notificationWindow.setParentSize(null);
    }

    public void showMessage(Notification notification) {
        try {
            this.notificationWindow.addNotification(notification);
            try {
                this.notificationWindow.setParentLocation(this._icon.getLocationOnScreen());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.notificationWindow.showWindow();
        }
        catch (Exception exception) {
            LOG.error("Disabling notifications due to error", exception);
            UISettings.SHOW_NOTIFICATIONS.setValue(false);
            this.notificationWindow.hideWindowImmediately();
        }
    }

    public void hideMessage(Notification notification) {
        this.notificationWindow.removeNotification(notification);
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.notificationWindow);
    }
}

