/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneImpl;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.SaveDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import org.limewire.service.ErrorService;

class OptionsPaneFactory {
    private SaveDirPaneItem SAVE_ITEM;
    private SharedDirPaneItem SHARED_ITEM = new SharedDirPaneItem();

    OptionsPaneFactory() {
        this.SAVE_ITEM = new SaveDirPaneItem(this.SHARED_ITEM);
    }

    SharedDirPaneItem getSharedPane() {
        return this.SHARED_ITEM;
    }

    OptionsPane createOptionsPane(OptionsTreeNode optionsTreeNode) {
        Class<? extends AbstractPaneItem>[] classArray = optionsTreeNode.getClasses();
        if (classArray != null) {
            OptionsPaneImpl optionsPaneImpl = new OptionsPaneImpl(optionsTreeNode.getTitleKey());
            for (Class<? extends AbstractPaneItem> clazz : classArray) {
                if (clazz == SaveDirPaneItem.class) {
                    optionsPaneImpl.add(this.SAVE_ITEM);
                    continue;
                }
                if (clazz == SharedDirPaneItem.class) {
                    optionsPaneImpl.add(this.SHARED_ITEM);
                    continue;
                }
                try {
                    optionsPaneImpl.add(clazz.newInstance());
                }
                catch (Exception exception) {
                    ErrorService.error(exception);
                }
            }
            return optionsPaneImpl;
        }
        throw new IllegalArgumentException("no options pane for this key: " + optionsTreeNode.getTitleKey());
    }
}

