/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.gui.shell.LimeAssociations;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class AssociationPreferencePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Links and File Types");
    public static final String LABEL = I18n.tr("You can use FrostWire to open certain filetypes and protocols. You can also instruct FrostWire to always regain these associations if another program takes them.");
    private Map<JCheckBox, LimeAssociationOption> associations = new HashMap<JCheckBox, LimeAssociationOption>();
    private JRadioButton always;
    private JRadioButton never;
    private JRadioButton ask;

    public AssociationPreferencePaneItem() {
        super(TITLE, LABEL);
        Collection<LimeAssociationOption> collection = LimeAssociations.getSupportedAssociations();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        jPanel.add((Component)new JLabel(I18n.tr("Use FrostWire for...")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 4, 1, 0);
        for (LimeAssociationOption object2 : collection) {
            JCheckBox jCheckBox = new JCheckBox(object2.getDescription());
            this.associations.put(jCheckBox, object2);
            jPanel.add((Component)jCheckBox, gridBagConstraints);
        }
        gridBagConstraints.insets = new Insets(9, 0, 2, 0);
        jPanel.add((Component)new JLabel(I18n.tr("What should FrostWire do with the selected associations on startup?")), gridBagConstraints);
        int n = QuestionsHandler.GRAB_ASSOCIATIONS.getValue();
        this.always = new JRadioButton(I18n.tr("Always take the selected associations."), n == DialogOption.YES.toInt());
        this.never = new JRadioButton(I18n.tr("Ignore all missing associations."), n == DialogOption.NO.toInt());
        this.ask = new JRadioButton(I18n.tr("Ask me what to do when an association is missing."), DialogOption.parseInt(n) != DialogOption.YES && DialogOption.parseInt(n) != DialogOption.NO);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.always);
        buttonGroup.add(this.ask);
        buttonGroup.add(this.never);
        gridBagConstraints.insets = new Insets(1, 4, 1, 0);
        jPanel.add((Component)this.always, gridBagConstraints);
        jPanel.add((Component)this.ask, gridBagConstraints);
        jPanel.add((Component)this.never, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridheight = 0;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        this.add(jPanel);
    }

    public void initOptions() {
        for (JCheckBox jCheckBox : this.associations.keySet()) {
            jCheckBox.setSelected(this.associations.get(jCheckBox).isEnabled());
        }
        DialogOption dialogOption = DialogOption.parseInt(QuestionsHandler.GRAB_ASSOCIATIONS.getValue());
        switch (dialogOption) {
            case YES: {
                this.always.setSelected(true);
                break;
            }
            case NO: {
                this.never.setSelected(true);
                break;
            }
            default: {
                this.ask.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        for (Map.Entry<JCheckBox, LimeAssociationOption> entry : this.associations.entrySet()) {
            LimeAssociationOption limeAssociationOption = entry.getValue();
            if (entry.getKey().isSelected()) {
                limeAssociationOption.setAllowed(true);
                limeAssociationOption.setEnabled(true);
                continue;
            }
            if (limeAssociationOption.isEnabled()) {
                limeAssociationOption.setAllowed(false);
            }
            limeAssociationOption.setEnabled(false);
        }
        Object object = DialogOption.INVALID;
        if (this.always.isSelected()) {
            object = DialogOption.YES;
        } else if (this.never.isSelected()) {
            object = DialogOption.NO;
        }
        QuestionsHandler.GRAB_ASSOCIATIONS.setValue(((DialogOption)((Object)object)).toInt());
        return false;
    }

    public boolean isDirty() {
        for (Map.Entry<JCheckBox, LimeAssociationOption> entry : this.associations.entrySet()) {
            if (entry.getKey().isSelected() == entry.getValue().isEnabled()) continue;
            return true;
        }
        switch (DialogOption.parseInt(QuestionsHandler.GRAB_ASSOCIATIONS.getValue())) {
            case YES: {
                return !this.always.isSelected();
            }
            case NO: {
                return !this.never.isSelected();
            }
        }
        return !this.ask.isSelected();
    }
}

