/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;

public final class MaximumDownloadsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Maximum Downloads");
    public static final String LABEL = I18n.tr("You can set the maximum number of simultaneous downloads.");
    private final String OPTION_LABEL = I18nMarker.marktr("Maximum Downloads:");
    private WholeNumberField _maxDownloadsField = new SizedWholeNumberField();
    private int _maximumDownloads;

    public MaximumDownloadsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this._maxDownloadsField, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._maximumDownloads = DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
        this._maxDownloadsField.setValue(this._maximumDownloads);
    }

    public boolean applyOptions() throws IOException {
        int n = this._maxDownloadsField.getValue();
        if (n != this._maximumDownloads) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(n);
            this._maximumDownloads = n;
        }
        return false;
    }

    public boolean isDirty() {
        return DownloadSettings.MAX_SIM_DOWNLOAD.getValue() != this._maxDownloadsField.getValue();
    }
}

