/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;

public final class MaximumSearchesPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Maximum Searches");
    public static final String LABEL = I18n.tr("You can set the maximum number of simultaneous searches you can perform.");
    private final String OPTION_LABEL = I18nMarker.marktr("Maximum Searches:");
    private WholeNumberField _maxSearchesField = new SizedWholeNumberField();
    private int _maxSearchesString;

    public MaximumSearchesPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this._maxSearchesField, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._maxSearchesString = SearchSettings.PARALLEL_SEARCH.getValue();
        this._maxSearchesField.setValue(this._maxSearchesString);
    }

    public boolean applyOptions() throws IOException {
        int n = this._maxSearchesField.getValue();
        if (n != this._maxSearchesString) {
            try {
                SearchSettings.PARALLEL_SEARCH.setValue(n);
                this._maxSearchesString = n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException();
            }
        }
        return false;
    }

    public boolean isDirty() {
        return SearchSettings.PARALLEL_SEARCH.getValue() != this._maxSearchesField.getValue();
    }
}

