/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public final class ProxyPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Proxy Options");
    public static final String LABEL = I18n.tr("Configure Proxy Options for FrostWire.");
    private final String NO_PROXY_LABEL_KEY = I18nMarker.marktr("No Proxy");
    private final String SOCKS4_PROXY_LABEL_KEY = I18nMarker.marktr("Socks v4");
    private final String SOCKS5_PROXY_LABEL_KEY = I18nMarker.marktr("Socks v5");
    private final String HTTP_PROXY_LABEL_KEY = I18nMarker.marktr("HTTP");
    private final String PROXY_HOST_LABEL_KEY = I18nMarker.marktr("Proxy:");
    private final String PROXY_PORT_LABEL_KEY = I18nMarker.marktr("Port:");
    private final ButtonGroup BUTTONS = new ButtonGroup();
    private final JRadioButton NO_PROXY_BUTTON = new JRadioButton(I18n.tr(this.NO_PROXY_LABEL_KEY));
    private final JRadioButton SOCKS4_PROXY_BUTTON = new JRadioButton(I18n.tr(this.SOCKS4_PROXY_LABEL_KEY));
    private final JRadioButton SOCKS5_PROXY_BUTTON = new JRadioButton(I18n.tr(this.SOCKS5_PROXY_LABEL_KEY));
    private final JRadioButton HTTP_PROXY_BUTTON = new JRadioButton(I18n.tr(this.HTTP_PROXY_LABEL_KEY));
    private final JTextField PROXY_HOST_FIELD = new SizedTextField(12, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
    private final WholeNumberField PROXY_PORT_FIELD = new SizedWholeNumberField(8080, 5, GUIUtils.SizePolicy.RESTRICT_BOTH);

    public ProxyPaneItem() {
        super(TITLE, LABEL);
        this.BUTTONS.add(this.NO_PROXY_BUTTON);
        this.BUTTONS.add(this.SOCKS4_PROXY_BUTTON);
        this.BUTTONS.add(this.SOCKS5_PROXY_BUTTON);
        this.BUTTONS.add(this.HTTP_PROXY_BUTTON);
        this.NO_PROXY_BUTTON.addItemListener(new LocalProxyListener());
        this.add(this.NO_PROXY_BUTTON);
        this.add(this.SOCKS4_PROXY_BUTTON);
        this.add(this.SOCKS5_PROXY_BUTTON);
        this.add(this.HTTP_PROXY_BUTTON);
        this.add(this.getHorizontalSeparator());
        BoxPanel boxPanel = new BoxPanel(0);
        LabeledComponent labeledComponent = new LabeledComponent(this.PROXY_HOST_LABEL_KEY, this.PROXY_HOST_FIELD, 150, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addHorizontalComponentGap();
        labeledComponent = new LabeledComponent(this.PROXY_PORT_LABEL_KEY, this.PROXY_PORT_FIELD, 150, 10);
        boxPanel.add(labeledComponent.getComponent());
        this.add(boxPanel);
    }

    public void initOptions() {
        String string = ConnectionSettings.PROXY_HOST.getValue();
        int n = ConnectionSettings.PROXY_PORT.getValue();
        int n2 = ConnectionSettings.CONNECTION_METHOD.getValue();
        this.PROXY_PORT_FIELD.setValue(n);
        this.NO_PROXY_BUTTON.setSelected(n2 == 0);
        this.SOCKS4_PROXY_BUTTON.setSelected(n2 == 4);
        this.SOCKS5_PROXY_BUTTON.setSelected(n2 == 5);
        this.HTTP_PROXY_BUTTON.setSelected(n2 == 1);
        this.PROXY_HOST_FIELD.setText(string);
        this.updateState();
    }

    public boolean applyOptions() throws IOException {
        int n = 0;
        if (this.SOCKS4_PROXY_BUTTON.isSelected()) {
            n = 4;
        } else if (this.SOCKS5_PROXY_BUTTON.isSelected()) {
            n = 5;
        } else if (this.HTTP_PROXY_BUTTON.isSelected()) {
            n = 1;
        }
        int n2 = this.PROXY_PORT_FIELD.getValue();
        String string = this.PROXY_HOST_FIELD.getText();
        ConnectionSettings.PROXY_PORT.setValue(n2);
        ConnectionSettings.CONNECTION_METHOD.setValue(n);
        ConnectionSettings.PROXY_HOST.setValue(string);
        return false;
    }

    public boolean isDirty() {
        if (ConnectionSettings.PROXY_PORT.getValue() != this.PROXY_PORT_FIELD.getValue()) {
            return true;
        }
        if (!ConnectionSettings.PROXY_HOST.getValue().equals(this.PROXY_HOST_FIELD.getText())) {
            return true;
        }
        switch (ConnectionSettings.CONNECTION_METHOD.getValue()) {
            case 4: {
                return !this.SOCKS4_PROXY_BUTTON.isSelected();
            }
            case 5: {
                return !this.SOCKS5_PROXY_BUTTON.isSelected();
            }
            case 1: {
                return !this.HTTP_PROXY_BUTTON.isSelected();
            }
            case 0: {
                return !this.NO_PROXY_BUTTON.isSelected();
            }
        }
        return true;
    }

    private void updateState() {
        this.PROXY_HOST_FIELD.setEditable(!this.NO_PROXY_BUTTON.isSelected());
        this.PROXY_PORT_FIELD.setEditable(!this.NO_PROXY_BUTTON.isSelected());
        this.PROXY_HOST_FIELD.setEnabled(!this.NO_PROXY_BUTTON.isSelected());
        this.PROXY_PORT_FIELD.setEnabled(!this.NO_PROXY_BUTTON.isSelected());
    }

    private class LocalProxyListener
    implements ItemListener {
        private LocalProxyListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ProxyPaneItem.this.updateState();
        }
    }
}

