/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.FrostWireUtils;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.library.RecursiveSharingDialog;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.panes.AbstractDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.MediaTypeDownloadDirMediator;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Dialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.limewire.i18n.I18nMarker;

public final class SaveDirPaneItem
extends AbstractDirPaneItem {
    public static final String TITLE = I18n.tr("Save Folder");
    private MediaTypeDownloadDirMediator _mtddMediator;
    private final SharedDirPaneItem shareData;
    private final String MEDIA_OPTION_LABEL = I18nMarker.marktr("You can specify a download location for each media type.");

    public SaveDirPaneItem(SharedDirPaneItem sharedDirPaneItem) {
        super(TITLE);
        this.shareData = sharedDirPaneItem;
        this.add(this.getVerticalSeparator());
        this._mtddMediator = new MediaTypeDownloadDirMediator(this.saveField);
        LabeledComponent labeledComponent = new LabeledComponent(this.MEDIA_OPTION_LABEL, this._mtddMediator.getComponent(), 150, 13);
        this.add(labeledComponent.getComponent());
        Action[] actionArray = new AbstractAction[]{this._mtddMediator.getBrowseDirectoryAction(), this._mtddMediator.getResetDirectoryAction()};
        ButtonRow buttonRow = new ButtonRow(actionArray, 0, 12);
        this.add(this.getVerticalSeparator());
        this.add(buttonRow);
    }

    public String getDefaultPath() {
        return SharingSettings.DEFAULT_SAVE_DIR.getAbsolutePath();
    }

    public void initOptions() {
        try {
            File file = SharingSettings.getSaveDirectory();
            if (file == null) {
                throw new FileNotFoundException();
            }
            this.setDirectoryPath(file.getCanonicalPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setDirectoryPath("");
        }
        catch (IOException iOException) {
            this.setDirectoryPath("");
        }
        this._mtddMediator.initOptions();
    }

    public boolean applyOptions() throws IOException {
        String string = this.saveField.getText();
        HashSet<File> hashSet = new HashSet<File>();
        if (!string.equals(this.saveDirectory)) {
            try {
                File file = new File(string);
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw new IOException();
                }
                if (string.toLowerCase().startsWith(FrostWireUtils.getInstallationFolder().toLowerCase())) {
                    throw new IOException();
                }
                if (!this.shareData.isAlreadyGoingToBeShared(file)) {
                    hashSet.add(file);
                }
                SharingSettings.setSaveDirectory(file);
                this.saveDirectory = string;
            }
            catch (IOException iOException) {
                GUIMediator.showError(I18n.tr("Invalid folder for saving files. Please use another folder or revert to the default."));
                this.saveField.setText(this.saveDirectory);
                throw new IOException();
            }
            catch (NullPointerException nullPointerException) {
                GUIMediator.showError(I18n.tr("Invalid folder for saving files. Please use another folder or revert to the default."));
                this.saveField.setText(this.saveDirectory);
                throw new IOException();
            }
        }
        boolean bl = this._mtddMediator.applyOptions(hashSet);
        if (!hashSet.isEmpty()) {
            RecursiveSharingDialog recursiveSharingDialog = new RecursiveSharingDialog((Dialog)OptionsMediator.instance().getMainOptionsComponent(), hashSet.toArray(new File[hashSet.size()]));
            recursiveSharingDialog.setTitleText(I18n.tr("Would you like to share your new save folders? The following new folders will be shared:"));
            if (recursiveSharingDialog.showChooseDialog(OptionsMediator.instance().getMainOptionsComponent(), false) == RecursiveSharingDialog.State.OK) {
                this.shareData.addAndKeepDirtyStatus(recursiveSharingDialog.getRootsToShare(), recursiveSharingDialog.getFoldersToExclude());
            }
        }
        return bl;
    }

    public boolean isDirty() {
        return !SharingSettings.getSaveDirectory().equals(new File(this.saveField.getText())) || this._mtddMediator.isDirty();
    }
}

