/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public final class SpamFilterSensivityPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Sensitivity");
    public static final String LABEL = I18n.tr("Adjust the sensitivity of FrostWire's junk filter");
    private JSlider THRESHOLD = new JSlider(0, 50);
    private JButton RESET = new JButton();

    public SpamFilterSensivityPaneItem() {
        super(TITLE, LABEL);
        this.RESET.setText(I18n.tr("Forget Training Data"));
        this.RESET.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiCoreMediator.getSpamManager().clearFilterData();
            }
        });
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(0, new JLabel(I18n.tr("Relaxed"), 0));
        ((Dictionary)hashtable).put(50, new JLabel(I18n.tr("Strict"), 0));
        this.THRESHOLD.setLabelTable(hashtable);
        this.THRESHOLD.setPaintLabels(true);
        this.add(this.THRESHOLD);
        this.add(this.getVerticalSeparator());
        this.add(this.getVerticalSeparator());
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.RESET);
        GUIUtils.restrictSize(jPanel, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(jPanel);
    }

    public void initOptions() {
        this.THRESHOLD.setValue((int)(100.0f - 100.0f * SearchSettings.FILTER_SPAM_RESULTS.getValue()));
    }

    public boolean applyOptions() throws IOException {
        SearchSettings.FILTER_SPAM_RESULTS.setValue((float)(100 - this.THRESHOLD.getValue()) / 100.0f);
        return false;
    }

    public boolean isDirty() {
        return SearchSettings.FILTER_SPAM_RESULTS.getValue() != (float)(100 - this.THRESHOLD.getValue()) / 100.0f;
    }
}

