/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.layout.SpringUtilities;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.StoreSaveTemplateProcessor;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoreDirectoryTemplatePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("LimeWire Store - Subfolder Template");
    public static final String LABEL = I18n.tr("You can customize where store files are saved. By creating a template Lime Wire can automatically save purchased files into folders using the artists name and album title. \n\ne.g:\nPurchased song: Artist Name - Track 1\n Template: ${artist} \n How its saved: LimeWireStore/Artist Name/Artist Name - Track 1");
    private final String TEMPLATE_LABEL = I18n.tr("Template") + ":";
    private final String VARIABLES_LABEL = I18n.tr("Variables") + ":";
    private final String TEMPLATES_LABEL = I18n.tr("Templates") + ":";
    private final String artist = I18n.tr("Artist");
    private final String album = I18n.tr("Album");
    private final String artistVar = "${" + this.artist.toLowerCase() + "}";
    private final String albumVar = "${" + this.album.toLowerCase() + "}";
    private String template;
    private JTextField templateField;
    private JComboBox templateVariables;
    private JComboBox _presetTemplates;
    private JPanel templatePanel;

    public StoreDirectoryTemplatePaneItem() {
        super(TITLE, LABEL);
        this.add(this.getTemplatePanel());
        this.add(this.getVerticalSeparator());
    }

    private JPanel getTemplatePanel() {
        if (this.templatePanel == null) {
            this.templatePanel = new JPanel(new SpringLayout());
            this.templateField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.templatePanel.add(new JLabel(this.TEMPLATE_LABEL));
            this.templatePanel.add(this.templateField);
            this.templatePanel.add(new JLabel(this.VARIABLES_LABEL));
            this.templatePanel.add(this.getVariableOptions());
            this.templatePanel.add(new JLabel(this.TEMPLATES_LABEL));
            this.templatePanel.add(this.getPresetTemplates());
            SpringUtilities.makeCompactGrid(this.templatePanel, 3, 2, 6, 6, 6, 6);
        }
        return this.templatePanel;
    }

    private JComboBox getVariableOptions() {
        if (this.templateVariables == null) {
            ListNode[] listNodeArray = new ListNode[]{new ListNode("--" + I18n.tr("Insert a Variable") + "--", null), new ListNode(this.artist, this.artistVar), new ListNode(this.album, this.albumVar)};
            this.templateVariables = new JComboBox<ListNode>(listNodeArray);
            this.templateVariables.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (StoreDirectoryTemplatePaneItem.this.templateVariables.getSelectedIndex() == 0) {
                        return;
                    }
                    StoreDirectoryTemplatePaneItem.this.templateField.setText(StoreDirectoryTemplatePaneItem.this.templateField.getText() + ((ListNode)StoreDirectoryTemplatePaneItem.this.templateVariables.getSelectedItem()).displayTemplateText);
                }
            });
            this.templateVariables.setMaximumSize(new Dimension(200, 25));
        }
        return this.templateVariables;
    }

    private JComboBox getPresetTemplates() {
        if (this._presetTemplates == null) {
            ListNode[] listNodeArray = new ListNode[]{new ListNode("--" + I18n.tr("Insert a template") + "--", null), new ListNode(this.album, this.albumVar), new ListNode(this.artist, this.artistVar), new ListNode(this.artist + "-" + this.album, this.artistVar + "-" + this.albumVar), new ListNode(I18n.tr("iTunes like"), this.artistVar + File.separatorChar + this.albumVar)};
            this._presetTemplates = new JComboBox<ListNode>(listNodeArray);
            this._presetTemplates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (StoreDirectoryTemplatePaneItem.this._presetTemplates.getSelectedIndex() == 0) {
                        return;
                    }
                    StoreDirectoryTemplatePaneItem.this.templateField.setText(((ListNode)StoreDirectoryTemplatePaneItem.this._presetTemplates.getSelectedItem()).displayTemplateText);
                }
            });
            this._presetTemplates.setMaximumSize(new Dimension(200, 25));
        }
        return this._presetTemplates;
    }

    @Override
    public boolean applyOptions() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.artist.toLowerCase(), "artist");
        hashMap.put(this.album.toLowerCase(), "album");
        String string = this.convertTemplateLanguage(this.templateField.getText(), hashMap);
        try {
            new StoreSaveTemplateProcessor().isValid(string);
        }
        catch (StoreSaveTemplateProcessor.IllegalTemplateException illegalTemplateException) {
            GUIMediator.showError(I18n.tr("Invalid template {0}", illegalTemplateException.getMessage()));
            throw new IOException();
        }
        if (!string.equals(this.template)) {
            SharingSettings.setSaveLWSTemplate(string);
        }
        return false;
    }

    @Override
    public void initOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("artist", this.artist.toLowerCase());
        hashMap.put("album", this.album.toLowerCase());
        this.templateField.setText(this.convertTemplateLanguage(SharingSettings.getSaveLWSTemplate(), hashMap));
        this.template = SharingSettings.getSaveLWSTemplate();
    }

    private String convertTemplateLanguage(String string, Map<String, String> map) {
        String string2 = "";
        if (string == null || string.length() == 0) {
            return string2;
        }
        string2 = string;
        for (String string3 : map.keySet()) {
            string2 = string2.replaceAll(string3, map.get(string3));
        }
        return string2;
    }

    @Override
    public boolean isDirty() {
        return !SharingSettings.getSaveLWSTemplate().equals(this.template);
    }

    private class ListNode {
        private final String displayText;
        private final String displayTemplateText;

        public ListNode(String string, String string2) {
            this.displayText = string;
            this.displayTemplateText = string2;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public String getDisplayTemplateText() {
            return this.displayTemplateText;
        }

        public String toString() {
            return this.displayText;
        }
    }
}

