/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public class TrayIconDisplayPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("System Tray Icon");
    public static final String LABEL = I18n.tr("You can display the system tray icon while FrostWire is visible.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Show System Tray Icon:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public TrayIconDisplayPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(ApplicationSettings.DISPLAY_TRAY_ICON.getValue());
    }

    public boolean applyOptions() throws IOException {
        if (!this.isDirty()) {
            return false;
        }
        boolean bl = this.CHECK_BOX.isSelected();
        ApplicationSettings.DISPLAY_TRAY_ICON.setValue(bl);
        if (bl) {
            GUIMediator.showTrayIcon();
        } else {
            GUIMediator.hideTrayIcon();
        }
        return false;
    }

    public boolean isDirty() {
        return ApplicationSettings.DISPLAY_TRAY_ICON.getValue() != this.CHECK_BOX.isSelected();
    }
}

