/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.playlist.PlaylistDataLine;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaylistModel
extends BasicDataLineModel<PlaylistDataLine, PlayListItem> {
    private boolean _shuffle = false;
    private boolean _nextIsBefore = false;
    private PlayListItem _currentSong;
    private List<PlayListItem> _songsNotPlayed;

    PlaylistModel() {
        super(PlaylistDataLine.class);
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    @Override
    public PlaylistDataLine createDataLine() {
        return new PlaylistDataLine();
    }

    @Override
    public int add(PlayListItem playListItem) {
        return this.add(playListItem, this.getRowCount());
    }

    @Override
    public int add(PlaylistDataLine playlistDataLine, int n) {
        if (this._shuffle) {
            this._songsNotPlayed.add((PlayListItem)playlistDataLine.getInitializeObject());
            Collections.shuffle(this._songsNotPlayed);
        }
        return super.add(playlistDataLine, n);
    }

    @Override
    public void remove(int n) {
        PlayListItem playListItem = (PlayListItem)((PlaylistDataLine)this.get(n)).getInitializeObject();
        super.remove(n);
        if (this._shuffle) {
            this._songsNotPlayed.remove(playListItem);
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this._shuffle) {
            this._songsNotPlayed.clear();
        }
    }

    PlayListItem getNextSong() {
        int n = this.getRowCount();
        if (n == 0) {
            return null;
        }
        boolean bl = this._nextIsBefore;
        this._nextIsBefore = false;
        if (this._shuffle) {
            if (this._songsNotPlayed.isEmpty()) {
                for (int i = 0; i < n; ++i) {
                    this._songsNotPlayed.add((PlayListItem)((PlaylistDataLine)this.get(i)).getInitializeObject());
                }
                Collections.shuffle(this._songsNotPlayed);
            }
            this._currentSong = this._songsNotPlayed.remove(0);
        } else {
            int n2 = this.getRow(this._currentSong);
            n2 = n2 == -1 ? 0 : (bl ? (n2 - 1 + n) % n : (n2 + 1 + n) % n);
            this._currentSong = (PlayListItem)((PlaylistDataLine)this.get(n2)).getInitializeObject();
        }
        return this._currentSong;
    }

    void setCurrentSong(PlayListItem playListItem) {
        if (this._shuffle) {
            this._songsNotPlayed.remove(playListItem);
        }
        this._currentSong = playListItem;
    }

    int getCurrentSongIndex() {
        return this.getRow(this._currentSong);
    }

    List<PlayListItem> getSongs() {
        LinkedList<PlayListItem> linkedList = new LinkedList<PlayListItem>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            linkedList.add((PlayListItem)((PlaylistDataLine)this.get(i)).getInitializeObject());
        }
        return linkedList;
    }

    List<PlayListItem> getLocalFiles() {
        LinkedList<PlayListItem> linkedList = new LinkedList<PlayListItem>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((PlaylistDataLine)this.get(i)).getPlayListItem().isFile()) continue;
            linkedList.add(((PlaylistDataLine)this.get(i)).getPlayListItem());
        }
        return linkedList;
    }

    void setBackwardsMode() {
        this._nextIsBefore = true;
    }

    void addSongs(PlayList playList) {
        this.unsort();
        List<PlayListItem> list = playList.getSongs();
        for (PlayListItem playListItem : list) {
            this.add(playListItem);
        }
    }

    void setShuffle(boolean bl) {
        this._songsNotPlayed = bl ? new LinkedList<PlayListItem>() : null;
        this._shuffle = bl;
    }

    public boolean isShuffleSet() {
        return this._shuffle;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }
}

