/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchResult;
import org.limewire.collection.ApproximateMatcher;
import org.limewire.util.I18NConvert;

abstract class AbstractSearchResult
implements SearchResult {
    private String processedFilename;

    AbstractSearchResult() {
    }

    public String getFilenameNoExtension() {
        String string = this.getFileName();
        if (string == null) {
            throw new NullPointerException("getFileName() can't return a null result");
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return I18NConvert.instance().compose(string.substring(0, n));
    }

    public String getExtension() {
        String string = this.getFileName();
        if (string == null) {
            throw new NullPointerException("getFileName() can't return a null result");
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    private String getProcessedFilename(ApproximateMatcher approximateMatcher) {
        if (this.processedFilename != null) {
            return this.processedFilename;
        }
        this.processedFilename = approximateMatcher.process(this.getFilenameNoExtension());
        return this.processedFilename;
    }

    public final int match(SearchResult searchResult, ApproximateMatcher approximateMatcher) {
        long l;
        if (!(searchResult instanceof AbstractSearchResult)) {
            return 3;
        }
        AbstractSearchResult abstractSearchResult = (AbstractSearchResult)searchResult;
        if (!this.getExtension().equals(abstractSearchResult.getExtension())) {
            return 1;
        }
        long l2 = this.getSize();
        if (l2 != (l = abstractSearchResult.getSize())) {
            return 2;
        }
        this.getProcessedFilename(approximateMatcher);
        abstractSearchResult.getProcessedFilename(approximateMatcher);
        int n = Math.round(Math.min(0.1f * (float)this.getFilenameNoExtension().length(), 0.1f * (float)abstractSearchResult.getFilenameNoExtension().length()));
        n = Math.min(n, 4);
        if (!approximateMatcher.matches(this.getProcessedFilename(approximateMatcher), abstractSearchResult.getProcessedFilename(approximateMatcher), n)) {
            return 3;
        }
        return 0;
    }
}

