/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class CompositeCellTableRendererAndTableCellEditor
extends JPanel
implements TableCellRenderer,
TableCellEditor,
ThemeObserver {
    public final JLabel mainLabel;
    public final List<SmallButton> buttons = new ArrayList<SmallButton>();
    private static final int HGAP = 2;
    private static final int VGAP = 2;
    JPanel buttonPanel;
    private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();

    protected CompositeCellTableRendererAndTableCellEditor() {
        this.setLayout(new BorderLayout());
        int n = this.createActions().length;
        GridLayout gridLayout = new GridLayout(1, n);
        gridLayout.setHgap(2);
        this.buttonPanel = new JPanel(gridLayout);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mainLabel = new JLabel();
        this.add((Component)this.buttonPanel, "West");
        this.add((Component)this.mainLabel, "Center");
        for (Action action : this.createActions()) {
            SmallButton smallButton = new SmallButton(action);
            this.buttonPanel.add(smallButton);
            this.buttons.add(smallButton);
        }
        this.setOpaque(true);
    }

    protected abstract Action[] createActions();

    protected abstract String getNameForValue(Object var1);

    protected boolean buttonsVisible() {
        return true;
    }

    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.getTableCellComponent(jTable, object, bl, bl2, n, n2);
    }

    public final Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.getTableCellComponent(jTable, object, true, true, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCellEditorListener(CellEditorListener cellEditorListener) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(cellEditorListener)) {
                this.listeners.add(cellEditorListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                this.listeners.get(i).editingCanceled(new ChangeEvent(this));
            }
        }
    }

    public final Object getCellEditorValue() {
        return null;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCellEditorListener(CellEditorListener cellEditorListener) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(cellEditorListener)) {
                this.listeners.remove(cellEditorListener);
            }
        }
    }

    public final boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean stopCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                this.listeners.get(i).editingStopped(new ChangeEvent(this));
            }
        }
        return true;
    }

    protected abstract Color getFontColor(Color var1);

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.mainLabel != null) {
            this.mainLabel.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.mainLabel != null) {
            this.mainLabel.setForeground(this.getFontColor(color));
        }
    }

    private Component getTableCellComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = this.getNameForValue(object);
        this.mainLabel.setText(string);
        this.buttonPanel.setVisible(this.buttonsVisible());
        if (bl) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            LimeJTable limeJTable = (LimeJTable)jTable;
            this.setBackground(limeJTable.getBackgroundForRow(n));
            this.setForeground(limeJTable.getForeground());
        }
        return this;
    }

    public void updateTheme() {
        this.mainLabel.setFont(UIManager.getFont("Table.font"));
        this.mainLabel.setForeground(ThemeFileHandler.WINDOW8_COLOR.getValue());
    }

    private static class SmallButton
    extends JButton {
        SmallButton(Action action) {
            super(action);
            this.setFocusable(false);
            Font font = UIManager.getFont("Table.font");
            font = font.deriveFont((float)((double)font.getSize() * 0.8));
            this.setFont(font);
            this.setVerticalTextPosition(1);
        }
    }
}

