/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gnutella.gui.actions.BuyAction;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.LicenseWindow;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import com.limegroup.gnutella.gui.actions.ActionUtils;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.search.CompositeFilter;
import com.limegroup.gnutella.gui.search.DateRenderer;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.EndpointRenderer;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.PercentageRenderer;
import com.limegroup.gnutella.gui.search.QualityHolder;
import com.limegroup.gnutella.gui.search.QualityRenderer;
import com.limegroup.gnutella.gui.search.ResultNameHolder;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.ResultPanelTransferHandler;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.ResultSpeedRenderer;
import com.limegroup.gnutella.gui.search.SearchButtons;
import com.limegroup.gnutella.gui.search.SearchColumnPreferenceHandler;
import com.limegroup.gnutella.gui.search.SearchColumnSelectionMenu;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultMenu;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.search.TableRowFilter;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.metal.MetalBorders;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultPanel
extends AbstractTableMediator<TableRowFilter, TableLine, SearchResult>
implements VerificationListener,
FileDetailsProvider {
    protected static final String SEARCH_TABLE = "SEARCH_TABLE";
    protected static final GUID STOPPED_GUID = new GUID(GUID.makeGuid());
    private static final DateRenderer DATE_RENDERER = new DateRenderer();
    private static final QualityRenderer QUALITY_RENDERER = new QualityRenderer();
    private static final EndpointRenderer ENDPOINT_RENDERER = new EndpointRenderer();
    private static final ResultSpeedRenderer RESULT_SPEED_RENDERER = new ResultSpeedRenderer();
    private static final PercentageRenderer PERCENTAGE_RENDERER = new PercentageRenderer();
    static final TableSettings SEARCH_SETTINGS = new TableSettings("SEARCH_TABLE");
    private final SearchInformation SEARCH_INFO;
    private final SpamFilter SPAM_FILTER;
    protected volatile GUID guid;
    private BrowseHostHandler browseHandler = null;
    private long startTime = System.currentTimeMillis();
    CompositeFilter FILTER;
    ActionListener DOWNLOAD_LISTENER;
    ActionListener DOWNLOAD_AS_LISTENER;
    ActionListener CHAT_LISTENER;
    ActionListener BROWSE_HOST_LISTENER;
    ActionListener STOP_LISTENER;
    ActionListener MARK_AS_SPAM_LISTENER;
    ActionListener MARK_AS_NOT_SPAM_LISTENER;
    ActionListener BUY_LISTENER;
    private JButton SPAM_BUTTON;
    private JButton BUY_BUTTON;
    public BuyAction BUY_ACTION;
    protected Box SOUTH_PANEL;
    private MouseInputListener ACTION_HIGHLIGHT_LISTENER;
    @InspectablePrimitive(value="spam button clicks")
    private static volatile int spamClicks;

    ResultPanel(JPanel jPanel) {
        super(SEARCH_TABLE);
        this.setupFakeTable(jPanel);
        this.SEARCH_INFO = SearchInformation.createKeywordSearch("", null, MediaType.getAnyTypeMediaType());
        this.SPAM_FILTER = null;
        this.FILTER = null;
        this.guid = STOPPED_GUID;
        this.setButtonEnabled(2, false);
        this.TABLE.setDragEnabled(false);
        this.TABLE.setTransferHandler(null);
        this.SOUTH_PANEL.setVisible(false);
        this.BUY_ACTION = new BuyAction();
    }

    ResultPanel(String string, String string2) {
        super(string2);
        this.SPAM_FILTER = null;
        this.SEARCH_INFO = SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType());
        this.guid = STOPPED_GUID;
        this.BUY_ACTION = new BuyAction();
    }

    ResultPanel(GUID gUID, SearchInformation searchInformation) {
        super(SEARCH_TABLE);
        this.SEARCH_INFO = searchInformation;
        this.SPAM_FILTER = this.SEARCH_INFO.isBrowseHostSearch() || this.SEARCH_INFO.isWhatsNewSearch() ? null : new SpamFilter();
        this.guid = gUID;
        this.setupRealTable();
        this.resetFilters();
        this.BUY_ACTION = new BuyAction();
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(QualityHolder.class, QUALITY_RENDERER);
        this.TABLE.setDefaultRenderer(EndpointHolder.class, ENDPOINT_RENDERER);
        this.TABLE.setDefaultRenderer(ResultSpeed.class, RESULT_SPEED_RENDERER);
        this.TABLE.setDefaultRenderer(Date.class, DATE_RENDERER);
        this.TABLE.setDefaultRenderer(Float.class, PERCENTAGE_RENDERER);
        this.TABLE.setDefaultRenderer(ResultNameHolder.class, LINK_RENDERER);
    }

    @Override
    protected void updateSplashScreen() {
    }

    protected void setupDataModel() {
        this.DATA_MODEL = new TableRowFilter(this.FILTER);
    }

    @Override
    protected void setupConstants() {
        this.FILTER = new CompositeFilter(4);
        this.MAIN_PANEL = new PPP();
        this.setupDataModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL){

            protected Color getEvenRowColor(int n) {
                return ResultPanel.this.getLine(n).getEvenRowColor();
            }

            protected Color getOddRowColor(int n) {
                return ResultPanel.this.getLine(n).getOddRowColor();
            }
        };
        ((ResultPanelModel)this.DATA_MODEL).setTable(this.TABLE);
        this.BUTTON_ROW = new SearchButtons(this).getComponent();
        this.SPAM_BUTTON = new IconButton(I18n.tr("Not Junk"), "SEARCH_SPAM");
        this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
        this.SPAM_BUTTON.setEnabled(false);
        this.SPAM_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableLine[] tableLineArray = ResultPanel.this.getAllSelectedLines();
                if (tableLineArray.length > 0) {
                    spamClicks++;
                    if (SpamFilter.isAboveSpamThreshold(tableLineArray[0])) {
                        ResultPanel.this.MARK_AS_NOT_SPAM_LISTENER.actionPerformed(actionEvent);
                    } else {
                        ResultPanel.this.MARK_AS_SPAM_LISTENER.actionPerformed(actionEvent);
                    }
                }
            }
        });
        if (this.BUY_ACTION == null) {
            this.BUY_ACTION = new BuyAction();
        }
        this.BUY_BUTTON = new IconButton(this.BUY_ACTION);
        this.BUY_BUTTON.setEnabled(false);
        this.BUY_BUTTON.addActionListener(this.BUY_LISTENER);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new MulticastTransferHandler(new ResultPanelTransferHandler(this), DNDUtils.DEFAULT_TRANSFER_HANDLERS));
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = SEARCH_SETTINGS;
    }

    @Override
    protected JPopupMenu createColumnSelectionMenu() {
        return new SearchColumnSelectionMenu(this.TABLE).getComponent();
    }

    @Override
    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new SearchColumnPreferenceHandler(this.TABLE);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.TABLE.addMouseMotionListener(this.ACTION_HIGHLIGHT_LISTENER);
        this.TABLE.addMouseListener(this.ACTION_HIGHLIGHT_LISTENER);
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.ACTION_HIGHLIGHT_LISTENER = new MouseInputAdapter(){
            private final Cursor DEFAULT = Cursor.getDefaultCursor();
            private final Cursor HAND = Cursor.getPredefinedCursor(12);
            private Cursor lastCursor = Cursor.getDefaultCursor();

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = ResultPanel.this.TABLE.columnAtPoint(point);
                int n2 = ResultPanel.this.TABLE.convertColumnIndexToModel(n);
                if (n2 == 4) {
                    int n3 = ResultPanel.this.TABLE.rowAtPoint(point);
                    TableLine tableLine = (TableLine)((TableRowFilter)ResultPanel.this.DATA_MODEL).get(n3);
                    if (tableLine != null && tableLine.isLink()) {
                        if (this.lastCursor != this.HAND) {
                            this.lastCursor = this.HAND;
                            ResultPanel.this.TABLE.getTopLevelAncestor().setCursor(this.HAND);
                        }
                        return;
                    }
                }
                if (this.lastCursor != this.DEFAULT) {
                    this.lastCursor = this.DEFAULT;
                    ResultPanel.this.TABLE.getTopLevelAncestor().setCursor(this.DEFAULT);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (this.lastCursor != this.DEFAULT) {
                    this.lastCursor = this.DEFAULT;
                    ResultPanel.this.TABLE.getTopLevelAncestor().setCursor(this.DEFAULT);
                }
            }
        };
        this.DOWNLOAD_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchMediator.doDownload(ResultPanel.this);
            }
        };
        this.DOWNLOAD_AS_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchMediator.doDownloadAs(ResultPanel.this);
            }
        };
        this.CHAT_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.doChat();
            }
        };
        this.BROWSE_HOST_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchMediator.doBrowseHost(ResultPanel.this);
            }
        };
        this.STOP_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.stopSearch();
            }
        };
        this.MARK_AS_SPAM_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableLine[] tableLineArray = ResultPanel.this.getAllSelectedLines();
                for (int i = 0; i < tableLineArray.length; ++i) {
                    ResultPanel.this.SPAM_FILTER.markAsSpamUser(tableLineArray[i], true);
                }
                if (SearchSettings.hideJunk()) {
                    ResultPanel.this.filtersChanged();
                } else {
                    ((TableRowFilter)ResultPanel.this.DATA_MODEL).refresh();
                    ResultPanel.this.transformSpamButton(I18n.tr("Not Junk"), I18n.tr("Mark selected search results as Not Junk"));
                }
            }
        };
        this.MARK_AS_NOT_SPAM_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableLine[] tableLineArray = ResultPanel.this.getAllSelectedLines();
                for (int i = 0; i < tableLineArray.length; ++i) {
                    ResultPanel.this.SPAM_FILTER.markAsSpamUser(tableLineArray[i], false);
                }
                ((TableRowFilter)ResultPanel.this.DATA_MODEL).refresh();
                ResultPanel.this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
            }
        };
        this.BUY_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableLine[] tableLineArray = ResultPanel.this.getAllSelectedLines();
                if (tableLineArray.length == 1 && tableLineArray[0] != null) {
                    ResultPanel.this.BUY_ACTION.setTableLine(tableLineArray[0]);
                    ResultPanel.this.BUY_ACTION.actionPerformed(actionEvent);
                }
            }
        };
    }

    @Override
    public JPopupMenu createPopupMenu() {
        return this.createPopupMenu(this.getAllSelectedLines());
    }

    protected JPopupMenu createPopupMenu(TableLine[] tableLineArray) {
        if (!this.isKillable()) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.createSearchAgainMenu(tableLineArray.length > 0 ? tableLineArray[0] : null));
        jPopupMenu.addSeparator();
        PopupUtils.addMenuItem(SearchMediator.STOP_STRING, this.STOP_LISTENER, jPopupMenu, !this.isStopped());
        PopupUtils.addMenuItem(SearchMediator.KILL_STRING, (ActionListener)new CancelListener(), jPopupMenu, this.isKillable());
        boolean bl = true;
        boolean bl2 = true;
        if (this.SPAM_FILTER != null) {
            for (int i = 0; i < tableLineArray.length; ++i) {
                if (!SpamFilter.isAboveSpamThreshold(tableLineArray[i])) {
                    bl = false;
                    continue;
                }
                bl2 = false;
            }
        }
        return new SearchResultMenu(this).addToMenu(jPopupMenu, tableLineArray, !bl, !bl2);
    }

    protected final JMenu createSearchAgainMenu(TableLine tableLine) {
        LimeXMLDocument limeXMLDocument;
        JMenu jMenu = new JMenu(I18n.tr("Search More"));
        jMenu.add(new JMenuItem(new RepeatSearchAction()));
        jMenu.add(new JMenuItem(new RepeatSearchNoClearAction()));
        if (tableLine == null) {
            jMenu.setEnabled(this.isRepeatSearchEnabled());
            return jMenu;
        }
        jMenu.addSeparator();
        String string = QueryUtils.createQueryString(tableLine.getFilename());
        SearchInformation searchInformation = SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType());
        if (SearchMediator.validateInfo(searchInformation) == 0) {
            jMenu.add(new JMenuItem(new SearchAction(searchInformation, I18nMarker.marktr("Search for Keywords: {0}"))));
        }
        if ((limeXMLDocument = tableLine.getXMLDocument()) != null) {
            Action[] actionArray = ActionUtils.createSearchActions(limeXMLDocument);
            for (int i = 0; i < actionArray.length; ++i) {
                jMenu.add(new JMenuItem(actionArray[i]));
            }
        }
        return jMenu;
    }

    @Override
    public void removeSelection() {
    }

    @Override
    public void clearTable() {
        super.clearTable();
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
        this.SPAM_BUTTON.setEnabled(false);
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_FILTER != null) {
            this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
        }
        this.BUY_BUTTON.setEnabled(false);
    }

    @Override
    public void handleSelection(int n) {
        this.setButtonEnabled(0, true);
        TableLine tableLine = (TableLine)((TableRowFilter)this.DATA_MODEL).get(n);
        this.setButtonEnabled(1, tableLine.isBrowseHostEnabled());
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_FILTER != null) {
            this.SPAM_BUTTON.setEnabled(true);
            if (SpamFilter.isAboveSpamThreshold(tableLine)) {
                this.transformSpamButton(I18n.tr("Not Junk"), I18n.tr("Mark selected search results as Not Junk"));
            } else {
                this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
            }
        }
        this.BUY_BUTTON.setEnabled(false);
        if (this.getAllSelectedLines().length == 1) {
            this.BUY_ACTION.setTableLine(this.getAllSelectedLines()[0]);
            this.BUY_BUTTON.setEnabled(true);
        }
    }

    @Override
    public void handleActionKey() {
        this.DOWNLOAD_LISTENER.actionPerformed(null);
    }

    SearchInformation getSearchInformation() {
        return this.SEARCH_INFO;
    }

    String getQuery() {
        return this.SEARCH_INFO.getQuery();
    }

    String getTitle() {
        return this.SEARCH_INFO.getTitle();
    }

    String getRichQuery() {
        return this.SEARCH_INFO.getXML();
    }

    void stopSearch() {
        final GUID gUID = this.guid;
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                GuiCoreMediator.getSearchServices().stopQuery(gUID);
            }
        });
        this.setGUID(STOPPED_GUID);
        SearchMediator.checkToStopLime();
        this.setButtonEnabled(2, false);
    }

    void doChat() {
        TableLine tableLine = this.getSelectedLine();
        if (tableLine == null) {
            return;
        }
        if (!tableLine.isChatEnabled()) {
            return;
        }
        tableLine.doChat();
    }

    void blockHost() {
        TableLine[] tableLineArray = this.getAllSelectedLines();
        HashSet<String> hashSet = new HashSet<String>();
        for (TableLine tableLine : tableLineArray) {
            hashSet.add(tableLine.getHostname());
            for (SearchResult searchResult : tableLine.getOtherResults()) {
                hashSet.add(searchResult.getHost());
            }
        }
        int n = GUIMediator.showConfirmListMessage(I18n.tr("Do you want to block search results from the following list of hosts?"), hashSet.toArray(), 0, null);
        if (n == 0) {
            String[] stringArray = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
            hashSet.addAll(Arrays.asList(stringArray));
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(hashSet.toArray(new String[hashSet.size()]));
            GuiCoreMediator.getSpamServices().reloadIPFilter();
        }
    }

    void showLicense() {
        TableLine tableLine = this.getSelectedLine();
        if (tableLine == null) {
            return;
        }
        URN uRN = tableLine.getSHA1Urn();
        LimeXMLDocument limeXMLDocument = tableLine.getXMLDocument();
        LicenseWindow licenseWindow = LicenseWindow.create(tableLine.getLicense(), uRN, limeXMLDocument, this);
        GUIUtils.centerOnScreen(licenseWindow);
        licenseWindow.setVisible(true);
    }

    @Override
    public void licenseVerified(License license) {
        if (license.isValid(null)) {
            ((ResultPanelModel)this.DATA_MODEL).slowRefresh();
        }
    }

    boolean isStopped() {
        return this.guid.equals(STOPPED_GUID);
    }

    boolean isEmpty() {
        return ((TableRowFilter)this.DATA_MODEL).getRowCount() == 0;
    }

    boolean isKillable() {
        return this.FILTER != null;
    }

    boolean filterChanged(TableLineFilter tableLineFilter, int n) {
        int n2;
        if (!this.FILTER.setFilter(n, tableLineFilter)) {
            return false;
        }
        int[] nArray = this.TABLE.getSelectedRows();
        TableLine[] tableLineArray = new TableLine[nArray.length];
        LinkedList<TableLine> linkedList = new LinkedList<TableLine>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            TableLine tableLine;
            int n3 = nArray[n2];
            tableLineArray[n2] = tableLine = (TableLine)((TableRowFilter)this.DATA_MODEL).get(n3);
            if (!this.TABLE.isRowVisible(n3)) continue;
            linkedList.add(tableLine);
        }
        ((TableRowFilter)this.DATA_MODEL).filtersChanged();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            TableLine tableLine = tableLineArray[n2];
            int n4 = ((TableRowFilter)this.DATA_MODEL).getRow(tableLine);
            if (n4 == -1) continue;
            this.TABLE.addRowSelectionInterval(n4, n4);
            if (linkedList == null || !linkedList.contains(tableLine)) continue;
            this.TABLE.ensureRowVisible(n4);
            linkedList = null;
        }
        SearchMediator.setTabDisplayCount(this);
        return true;
    }

    int totalSources() {
        return ((ResultPanelModel)this.DATA_MODEL).getTotalSources();
    }

    int filteredSources() {
        return ((TableRowFilter)this.DATA_MODEL).getFilteredSources();
    }

    boolean isRepeatSearchEnabled() {
        return this.FILTER != null;
    }

    void repeatSearch() {
        this.repeatSearch(true);
    }

    void repeatSearch(boolean bl) {
        if (bl) {
            this.clearTable();
            this.resetFilters();
        }
        this.startTime = System.currentTimeMillis();
        SearchMediator.setTabDisplayCount(this);
        SearchMediator.repeatSearch(this, this.SEARCH_INFO, bl);
        this.setButtonEnabled(2, true);
    }

    void resetFilters() {
        this.FILTER.reset();
        if (!this.SEARCH_INFO.isBrowseHostSearch() && !this.SEARCH_INFO.isWhatsNewSearch()) {
            ((TableRowFilter)this.DATA_MODEL).setJunkFilter(this.SPAM_FILTER);
        } else {
            ((TableRowFilter)this.DATA_MODEL).setJunkFilter(null);
        }
    }

    private void filtersChanged() {
        ((TableRowFilter)this.DATA_MODEL).filtersChanged();
        SearchMediator.setTabDisplayCount(this);
    }

    MetadataModel getMetadataModel() {
        return ((ResultPanelModel)this.DATA_MODEL).getMetadataModel();
    }

    boolean matches(GUID gUID) {
        return this.guid.equals(gUID);
    }

    void setGUID(GUID gUID) {
        this.guid = gUID;
    }

    byte[] getGUID() {
        return this.guid.bytes();
    }

    MediaType getMediaType() {
        return this.SEARCH_INFO.getMediaType();
    }

    void setBrowseHostHandler(BrowseHostHandler browseHostHandler) {
        this.browseHandler = browseHostHandler;
    }

    TableLine[] getAllSelectedLines() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray == null) {
            return new TableLine[0];
        }
        TableLine[] tableLineArray = new TableLine[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            tableLineArray[i] = (TableLine)((TableRowFilter)this.DATA_MODEL).get(nArray[i]);
        }
        return tableLineArray;
    }

    TableLine getSelectedLine() {
        int n = this.TABLE.getSelectedRow();
        if (n != -1) {
            return (TableLine)((TableRowFilter)this.DATA_MODEL).get(n);
        }
        return null;
    }

    final TableLine getLine(int n) {
        return (TableLine)((TableRowFilter)this.DATA_MODEL).get(n);
    }

    double calculatePercentage(long l) {
        if (this.guid.equals(STOPPED_GUID)) {
            return 1.0;
        }
        if (this.SEARCH_INFO.isBrowseHostSearch()) {
            if (this.browseHandler != null) {
                return this.browseHandler.getPercentComplete(l);
            }
            return 0.0;
        }
        int n = 150;
        double d = (double)this.totalSources() / (double)n;
        long l2 = l - this.startTime;
        double d2 = (double)l2 / 200000.0;
        if (d >= 1.0) {
            return 1.0;
        }
        return d + (d2 *= 1.0 - d);
    }

    private void setupRealTable() {
        SearchTableColumns searchTableColumns = ((ResultPanelModel)this.DATA_MODEL).getColumns();
        LimeTableColumn limeTableColumn = searchTableColumns.getColumn(1);
        if (this.SETTINGS.REAL_TIME_SORT.getValue() && this.TABLE.isColumnVisible(limeTableColumn.getId())) {
            ((TableRowFilter)this.DATA_MODEL).sort(1);
            ((TableRowFilter)this.DATA_MODEL).sort(1);
        }
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isConsumed()) {
                    return;
                }
                mouseEvent.consume();
                SearchMediator.panelSelected(ResultPanel.this);
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
        this.MAIN_PANEL.addMouseListener(mouseListener);
        this.SCROLL_PANE.addMouseListener(mouseListener);
        this.TABLE.addMouseListener(mouseListener);
        this.TABLE.getTableHeader().addMouseListener(mouseListener);
    }

    protected void setupMainPanelBase() {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            this.addButtonRow();
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        } else {
            super.setupMainPanel();
        }
    }

    @Override
    protected void setupMainPanel() {
        this.setupMainPanelBase();
    }

    protected JPanel createWarningDitherPanel() {
        return new DitherPanel(new Ditherer(6, new Color(255, 209, 86), new Color(255, 183, 44))){

            public void updateUI() {
                super.updateUI();
                Border border = UIManager.getBorder("ScrollPane.border");
                if (border != null && border.getClass() == MetalBorders.ScrollPaneBorder.class) {
                    this.setBorder(new WarningBorder(UIManager.getColor("SplitPane.darkShadow"), 1));
                } else if (OSUtils.isMacOSX()) {
                    this.setBorder(new WarningBorder(Color.lightGray, 0));
                } else {
                    this.setBorder(new WarningBorder(UIManager.getColor("TextField.darkShadow"), 0));
                }
            }
        };
    }

    private void setupFakeTable(JPanel jPanel) {
        this.MAIN_PANEL.removeAll();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new OverlayLayout(jPanel2));
        BoxPanel boxPanel = new BoxPanel(1);
        boxPanel.setOpaque(false);
        boxPanel.add(Box.createVerticalStrut(20));
        boxPanel.add(jPanel);
        boxPanel.setMinimumSize(new Dimension(0, 0));
        JComponent jComponent = this.getScrolledTablePane();
        jComponent.setOpaque(false);
        jPanel2.add(boxPanel);
        jPanel2.add(jComponent);
        this.MAIN_PANEL.add(jPanel2);
        this.addButtonRow();
        this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
    }

    private void addButtonRow() {
        if (this.BUTTON_ROW != null) {
            this.SOUTH_PANEL = Box.createVerticalBox();
            this.SOUTH_PANEL.setOpaque(false);
            this.SOUTH_PANEL.add(Box.createVerticalStrut(6));
            if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_BUTTON != null) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = null;
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = -1;
                jPanel.add((Component)this.BUY_BUTTON, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.weightx = 1.0;
                jPanel.add((Component)this.BUTTON_ROW, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 13;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 0;
                jPanel.add((Component)this.SPAM_BUTTON, gridBagConstraints);
                jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 64));
                this.SOUTH_PANEL.add(jPanel);
            } else {
                this.SOUTH_PANEL.add(this.BUTTON_ROW);
            }
            this.MAIN_PANEL.add(this.SOUTH_PANEL);
        }
    }

    @Override
    public FileDetails[] getFileDetails() {
        int[] nArray = this.TABLE.getSelectedRows();
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            TableLine tableLine = (TableLine)((TableRowFilter)this.DATA_MODEL).get(nArray[i]);
            RemoteFileDesc remoteFileDesc = tableLine.getNonFirewalledRFD();
            if (remoteFileDesc != null) {
                arrayList.add(remoteFileDesc);
                continue;
            }
            remoteFileDesc = tableLine.getRemoteFileDesc();
            if (remoteFileDesc == null) continue;
            arrayList.add(remoteFileDesc);
        }
        if (arrayList.isEmpty()) {
            return new FileDetails[0];
        }
        return arrayList.toArray(new FileDetails[0]);
    }

    public void cleanup() {
    }

    private void transformSpamButton(String string, String string2) {
        Dimension dimension = this.SPAM_BUTTON.getPreferredSize();
        this.SPAM_BUTTON.setText(string);
        this.SPAM_BUTTON.setToolTipText(string2);
        Dimension dimension2 = this.SPAM_BUTTON.getPreferredSize();
        dimension2.width = Math.max(dimension.width, dimension2.width);
        this.SPAM_BUTTON.setPreferredSize(dimension2);
    }

    protected final class CancelListener
    extends AbstractAction {
        protected CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchMediator.killSearch();
        }
    }

    private final class RepeatSearchNoClearAction
    extends AbstractAction {
        public RepeatSearchNoClearAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_NO_CLEAR_STRING);
            this.setEnabled(ResultPanel.this.isRepeatSearchEnabled());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResultPanel.this.repeatSearch(false);
        }
    }

    private final class RepeatSearchAction
    extends AbstractAction {
        public RepeatSearchAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_STRING);
            this.setEnabled(ResultPanel.this.isRepeatSearchEnabled());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResultPanel.this.repeatSearch(true);
        }
    }

    public class WarningBorder
    extends AbstractBorder {
        private Color lineColor;
        private int offset;

        public WarningBorder(Color color, int n) {
            this.lineColor = color;
            this.offset = n;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.lineColor);
            graphics.drawLine(n, n2, n + n3 - 1 - this.offset, n2);
            graphics.drawLine(n, n2, n, n2 + n4);
            graphics.drawLine(n + n3 - 1 - this.offset, n2, n + n3 - 1 - this.offset, n2 + n4);
            if (this.offset > 0) {
                graphics.setColor(component.getParent().getBackground());
                for (int i = 0; i < this.offset; ++i) {
                    graphics.drawLine(n + n3 - 1 - i, n2, n + n3 - 1 - i, n2 + n4);
                }
            }
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 0, 1 + this.offset);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class PPP
    extends PaddedPanel
    implements ProgTabUIFactory.Progressor {
        private PPP() {
        }

        public double calculatePercentage(long l) {
            return ResultPanel.this.calculatePercentage(l);
        }
    }
}

