/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.gui.search.ThirdPartySearchResult;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultPanelModel
extends BasicDataLineModel<TableLine, SearchResult> {
    protected final MetadataModel METADATA;
    private LimeJTable TABLE;
    protected final SearchTableColumns COLUMNS = new SearchTableColumns();
    protected boolean _useMetadata = true;
    private final Map<URN, Integer> _indexes = new HashMap<URN, Integer>();
    private TableLineGrouper _grouper;
    private int _numSources;

    ResultPanelModel() {
        this(new MetadataModel());
    }

    ResultPanelModel(MetadataModel metadataModel) {
        super(TableLine.class);
        this.METADATA = metadataModel;
    }

    void setUseMetadata(boolean bl) {
        this._useMetadata = bl;
    }

    void setTable(LimeJTable limeJTable) {
        this.TABLE = limeJTable;
    }

    SearchTableColumns getColumns() {
        return this.COLUMNS;
    }

    @Override
    public TableLine createDataLine() {
        return new TableLine(this.COLUMNS);
    }

    @Override
    public LimeTableColumn getTableColumn(int n) {
        return this.COLUMNS.getColumn(n);
    }

    @Override
    public int compare(TableLine tableLine, TableLine tableLine2) {
        int n = this.compareSpam(tableLine, tableLine2);
        if (n != 0) {
            return n;
        }
        SearchResult searchResult = tableLine.getSearchResult();
        SearchResult searchResult2 = tableLine2.getSearchResult();
        if (searchResult instanceof ThirdPartySearchResult && !(searchResult2 instanceof ThirdPartySearchResult)) {
            return -1;
        }
        if (searchResult2 instanceof ThirdPartySearchResult && !(searchResult instanceof ThirdPartySearchResult)) {
            return 1;
        }
        if (!this.isSorted() || this._activeColumn != 1) {
            return super.compare(tableLine, tableLine2);
        }
        return this.compareCount(tableLine, tableLine2, false);
    }

    MetadataModel getMetadataModel() {
        return this.METADATA;
    }

    @Override
    public void remove(int n) {
        TableLine tableLine = (TableLine)this.get(n);
        URN uRN = this.getSHA1(n);
        if (uRN != null) {
            this._indexes.remove(uRN);
        }
        super.remove(n);
        this._numSources -= tableLine.getLocationCount();
        this.remapIndexes(n);
    }

    @Override
    public int add(SearchResult searchResult) {
        return this.add(searchResult, this.getRowCount());
    }

    @Override
    public int add(TableLine tableLine) {
        return super.add(tableLine);
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    public void slowRefresh() {
        super.refresh();
    }

    @Override
    public TableLine getNewDataLine(SearchResult searchResult) {
        URN uRN = searchResult.getSHA1Urn();
        int n = -1;
        if (UISettings.UI_GROUP_RESULTS.getValue()) {
            n = uRN == null ? this.slowMatch(searchResult) : this.fastMatch(uRN);
        }
        if (n != -1) {
            TableLine tableLine = (TableLine)this.get(n);
            int n2 = this.addNewResult(tableLine, searchResult);
            if (n2 != 0 && this.isSorted() && this.TABLE.getTableSettings().REAL_TIME_SORT.getValue() && this.getSortColumn() == 1) {
                this.move(tableLine, n);
            } else if (n2 != 0) {
                this.fireTableRowsUpdated(n, n);
            }
            return null;
        }
        return (TableLine)super.getNewDataLine(searchResult);
    }

    protected int addNewResult(TableLine tableLine, SearchResult searchResult) {
        int n = tableLine.getLocationCount();
        tableLine.addNewResult(searchResult, this.METADATA);
        int n2 = tableLine.getLocationCount();
        int n3 = n2 - n;
        this._numSources += n3;
        return n3;
    }

    @Override
    public int add(TableLine tableLine, int n) {
        this._numSources += tableLine.getLocationCount();
        URN uRN = tableLine.getSHA1Urn();
        if (uRN != null) {
            this._indexes.put(uRN, new Integer(n));
        }
        int n2 = super.add(tableLine, n);
        this.remapIndexes(n2 + 1);
        if (this._useMetadata) {
            this.METADATA.addNew(tableLine);
        }
        return n2;
    }

    @Override
    public int getRow(TableLine tableLine) {
        URN uRN = tableLine.getSHA1Urn();
        if (uRN != null) {
            return this.fastMatch(uRN);
        }
        return super.getRow(tableLine);
    }

    @Override
    public int getRow(SearchResult searchResult) {
        URN uRN = searchResult.getSHA1Urn();
        if (uRN != null) {
            return this.fastMatch(uRN);
        }
        return super.getRow(searchResult);
    }

    int getTotalSources() {
        return this._numSources;
    }

    @Override
    protected void doResort() {
        super.doResort();
        this._indexes.clear();
        this.remapIndexes(0);
    }

    @Override
    public void clear() {
        if (this.METADATA != null) {
            this.METADATA.clear();
        }
        if (this._grouper != null) {
            this._grouper.clear();
        }
        this.simpleClear();
    }

    @Override
    protected void cleanup() {
    }

    protected void simpleClear() {
        this._numSources = 0;
        this._indexes.clear();
        super.clear();
    }

    private void move(TableLine tableLine, int n) {
        TableLine tableLine2;
        int n2;
        int n3;
        if (!this.isSortAscending()) {
            if (n == 0) {
                this.fireTableRowsUpdated(0, 0);
                return;
            }
            n3 = 0;
            while (n2 > 0 && this.compareCount(tableLine, tableLine2 = (TableLine)this.get(n2 - 1), true) < 0) {
                --n2;
                ++n3;
            }
        } else {
            n3 = this.getRowCount() - 1;
            if (n == n3) {
                this.fireTableRowsUpdated(n3, n3);
                return;
            }
            for (n2 = n; n2 < n3 && this.compareCount(tableLine, tableLine2 = (TableLine)this.get(n2 + 1), true) < 0; ++n2) {
            }
        }
        if (n == n2) {
            this.fireTableRowsUpdated(n2, n2);
            return;
        }
        n3 = this.TABLE.isRowSelected(n) ? 1 : 0;
        boolean bl = this.TABLE.isSelectionVisible();
        super.remove(n);
        super.add(tableLine, n2);
        if (n3 != 0) {
            this.TABLE.clearSelection();
            this.TABLE.addRowSelectionInterval(n2, n2);
            if (bl) {
                this.TABLE.ensureSelectionVisible();
            }
        } else {
            this.TABLE.removeRowSelectionInterval(n2, n2);
            int n4 = this.TABLE.getSelectedRow();
            if (n4 != -1) {
                this.TABLE.addRowSelectionInterval(n4, n4);
                if (bl) {
                    this.TABLE.ensureSelectionVisible();
                }
            }
        }
        if (n < n2) {
            this.remapIndexes(n, n2 + 1);
        } else {
            this.remapIndexes(n2, n + 1);
        }
    }

    private void remapIndexes(int n) {
        this.remapIndexes(n, this.getRowCount());
    }

    private void remapIndexes(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            URN uRN = this.getSHA1(i);
            if (uRN == null) continue;
            this._indexes.put(uRN, new Integer(i));
        }
    }

    private URN getSHA1(int n) {
        if (n >= this.getRowCount()) {
            return null;
        }
        return ((TableLine)this.get(n)).getSHA1Urn();
    }

    private int compareSpam(TableLine tableLine, TableLine tableLine2) {
        if (SearchSettings.moveJunkToBottom()) {
            if (SpamFilter.isAboveSpamThreshold(tableLine)) {
                if (!SpamFilter.isAboveSpamThreshold(tableLine2)) {
                    return 1;
                }
            } else if (SpamFilter.isAboveSpamThreshold(tableLine2)) {
                return -1;
            }
        }
        return 0;
    }

    private int compareCount(TableLine tableLine, TableLine tableLine2, boolean bl) {
        int n;
        if (bl && (n = this.compareSpam(tableLine, tableLine2)) != 0) {
            return n;
        }
        n = this.normalizeLocationCount(tableLine.getLocationCount(), tableLine.getQuality());
        int n2 = this.normalizeLocationCount(tableLine2.getLocationCount(), tableLine2.getQuality());
        return (n - n2) * this._ascending;
    }

    private int normalizeLocationCount(int n, int n2) {
        switch (n2) {
            case 5: {
                return Integer.MAX_VALUE;
            }
            case 999: {
                return 0x7FFFFFFE;
            }
            case 4: {
                return 0x7FFFFFFD;
            }
        }
        return n;
    }

    private int slowMatch(SearchResult searchResult) {
        SearchResult searchResult2;
        if (this._grouper == null) {
            this._grouper = new TableLineGrouper();
        }
        if ((searchResult2 = this._grouper.match(searchResult)) == null) {
            this._grouper.add(searchResult);
        }
        return super.getRow(searchResult2);
    }

    private int fastMatch(URN uRN) {
        Integer n = this._indexes.get(uRN);
        if (n == null) {
            return -1;
        }
        return n;
    }
}

