/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.banner.Ad;
import com.limegroup.gnutella.gui.banner.Banner;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.gui.download.SearchResultDownloaderFactory;
import com.limegroup.gnutella.gui.search.GnutellaSearchResult;
import com.limegroup.gnutella.gui.search.RemoteStringBasicSpecialResultsDatabaseImpl;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchInputManager;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.ThirdPartyResultsDatabase;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.service.ErrorService;
import org.limewire.setting.AbstractSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchMediator {
    public static final int QUERY_VALID = 0;
    public static final int QUERY_EMPTY = 1;
    public static final int QUERY_TOO_SHORT = 2;
    public static final int QUERY_TOO_LONG = 3;
    public static final int QUERY_XML_TOO_LONG = 4;
    public static final int QUERY_INVALID_CHARACTERS = 5;
    static final String DOWNLOAD_STRING = I18n.tr("Download");
    static final String KILL_STRING = I18n.tr("Close Search");
    static final String STOP_STRING = I18n.tr("Stop Search");
    static final String LAUNCH_STRING = I18n.tr("Launch Action");
    static final String BROWSE_STRING = I18n.tr("Browse Host");
    static final String CHAT_STRING = I18n.tr("Chat With Host");
    static final String REPEAT_SEARCH_STRING = I18n.tr("Repeat Search");
    static final String BROWSE_HOST_STRING = I18n.tr("Browse Host");
    static final String BITZI_LOOKUP_STRING = I18n.tr("Lookup File with Bitzi");
    static final String BLOCK_STRING = I18n.tr("Block Hosts");
    static final String MARK_AS_STRING = I18n.tr("Mark As");
    static final String SPAM_STRING = I18n.tr("Junk");
    static final String NOT_SPAM_STRING = I18n.tr("Not Junk");
    static final String REPEAT_SEARCH_NO_CLEAR_STRING = I18n.tr("Get More Results");
    public static final String SEARCH_INFORMATION_KEY = "searchInformationMap";
    private static final SearchInputManager INPUT_MANAGER = new SearchInputManager();
    private static final RemoteStringBasicSpecialResultsDatabaseImpl thirdPartyDatabase = new RemoteStringBasicSpecialResultsDatabaseImpl(GuiCoreMediator.getLimeXMLDocumentFactory());
    public static final SearchResultDisplayer RESULT_DISPLAYER = new SearchResultDisplayer();
    private static volatile Banner banner;

    public SearchMediator() {
        String string = I18n.tr("Loading Search Window...");
        GUIMediator.setSplashScreenString(string);
        GUIMediator.addRefreshListener(RESULT_DISPLAYER);
        RESULT_DISPLAYER.setSearchListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ResultPanel resultPanel = RESULT_DISPLAYER.getSelectedResultPanel();
                if (resultPanel == null) {
                    INPUT_MANAGER.clearFilters();
                } else {
                    INPUT_MANAGER.setFiltersFor(resultPanel);
                }
            }
        });
        SearchMediator.initBanner();
    }

    private static void initBanner() {
        SearchMediator.reloadBanner();
        SearchSettings.SEARCH_WARNING.addSettingListener(new SettingListener(){

            public void settingChanged(SettingEvent settingEvent) {
                if (settingEvent.getEventType() == SettingEvent.EventType.VALUE_CHANGED) {
                    SearchMediator.reloadBanner();
                }
            }
        });
    }

    private static void reloadBanner() {
        Banner banner = SearchMediator.banner;
        try {
            banner = new Banner(SearchSettings.SEARCH_WARNING.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (banner == null) {
            banner = Banner.getDefaultBanner();
        }
        SearchMediator.banner = banner;
    }

    public static void rebuildInputPanel() {
        INPUT_MANAGER.rebuild();
    }

    public static void addressChanged() {
        INPUT_MANAGER.addressChanged();
    }

    public static void showSearchInput() {
        INPUT_MANAGER.goToSearch();
    }

    public static void requestSearchFocus() {
        INPUT_MANAGER.requestSearchFocus();
    }

    public static void updateResults() {
        RESULT_DISPLAYER.updateResults();
    }

    static byte[] repeatSearch(ResultPanel resultPanel, SearchInformation searchInformation) {
        return SearchMediator.repeatSearch(resultPanel, searchInformation, true);
    }

    static byte[] repeatSearch(ResultPanel resultPanel, SearchInformation searchInformation, boolean bl) {
        if (!SearchMediator.validate(searchInformation)) {
            return null;
        }
        byte[] byArray = GuiCoreMediator.getSearchServices().newQueryGUID();
        GUID gUID = new GUID(byArray);
        GuiCoreMediator.getSearchServices().stopQuery(new GUID(resultPanel.getGUID()));
        resultPanel.setGUID(gUID);
        if (bl) {
            INPUT_MANAGER.panelReset(resultPanel);
        }
        if (searchInformation.isBrowseHostSearch()) {
            IpPort ipPort = searchInformation.getIpPort();
            String string = ipPort.getAddress();
            int n = ipPort.getPort();
            if (string != null && n != 0) {
                GUIMediator.instance().setSearching(true);
                SearchMediator.reBrowseHost(new ConnectableImpl(ipPort, false), resultPanel);
            }
        } else {
            GUIMediator.instance().setSearching(true);
            SearchMediator.doSearch(byArray, searchInformation);
        }
        return byArray;
    }

    static void doBrowseHost(ResultPanel resultPanel) {
        TableLine tableLine = resultPanel.getSelectedLine();
        if (tableLine == null) {
            return;
        }
        RemoteFileDesc remoteFileDesc = tableLine.getBrowseHostEnabledRFD();
        if (remoteFileDesc == null) {
            return;
        }
        byte[] byArray = remoteFileDesc.getClientGUID();
        Set<IpPort> set = remoteFileDesc.isReplyToMulticast() ? IpPort.EMPTY_SET : remoteFileDesc.getPushProxies();
        GUID gUID = new GUID(byArray);
        SearchMediator.doBrowseHost2(remoteFileDesc, gUID, set, remoteFileDesc.supportsFWTransfer());
    }

    public static void doBrowseHost(RemoteFileDesc remoteFileDesc) {
        SearchMediator.doBrowseHost2(remoteFileDesc, new GUID(remoteFileDesc.getClientGUID()), remoteFileDesc.getPushProxies(), remoteFileDesc.supportsFWTransfer());
    }

    public static void doBrowseHost(Connectable connectable, GUID gUID) {
        if (gUID == null) {
            SearchMediator.doBrowseHost2(connectable, null, null, false);
        } else {
            SearchMediator.doBrowseHost2(connectable, new GUID(gUID.bytes()), null, false);
        }
    }

    private static void reBrowseHost(Connectable connectable, ResultPanel resultPanel) {
        GUID gUID = new GUID(GUID.makeGuid());
        resultPanel.setGUID(gUID);
        BrowseHostHandler browseHostHandler = GuiCoreMediator.getSearchServices().doAsynchronousBrowseHost(connectable, gUID, new GUID(GUID.makeGuid()), null, false);
        resultPanel.setBrowseHostHandler(browseHostHandler);
        INPUT_MANAGER.panelReset(resultPanel);
    }

    public static void doBrowseHost(PushEndpoint pushEndpoint) {
        InetSocketAddress inetSocketAddress = pushEndpoint.getInetSocketAddress();
        ConnectableImpl connectableImpl = inetSocketAddress != null ? new ConnectableImpl(inetSocketAddress, false) : null;
        SearchMediator.doBrowseHost2(connectableImpl, new GUID(pushEndpoint.getClientGUID()), pushEndpoint.getProxies(), pushEndpoint.supportsFWTVersion() >= 1);
    }

    private static void doBrowseHost2(Connectable connectable, GUID gUID, Set<? extends IpPort> set, boolean bl) {
        GUID gUID2 = new GUID(GUID.makeGuid());
        String string = connectable != null ? connectable.getAddress() + ":" + connectable.getPort() : I18n.tr("Firewalled Host");
        ResultPanel resultPanel = SearchMediator.addBrowseHostTab(gUID2, string);
        BrowseHostHandler browseHostHandler = GuiCoreMediator.getSearchServices().doAsynchronousBrowseHost(connectable, gUID2, gUID, set, bl);
        resultPanel.setBrowseHostHandler(browseHostHandler);
    }

    public static void browseHostFailed(GUID gUID) {
        RESULT_DISPLAYER.browseHostFailed(gUID);
    }

    public static byte[] triggerSearch(final SearchInformation searchInformation) {
        if (!SearchMediator.validate(searchInformation)) {
            return null;
        }
        final byte[] byArray = GuiCoreMediator.getSearchServices().newQueryGUID();
        if (!searchInformation.isBrowseHostSearch()) {
            SearchMediator.addResultTab(new GUID(byArray), searchInformation);
        }
        SearchMediator.doSearch(byArray, searchInformation);
        GuiCoreMediator.getCoreBackgroundExecutor().execute(new Runnable(){

            public void run() {
                thirdPartyDatabase.find(searchInformation, new ThirdPartyResultsDatabase.SearchResultsCallback(){

                    @Override
                    public void process(final List<SearchResult> list, SearchInformation searchInformation) {
                        if (list == null) {
                            return;
                        }
                        final ResultPanel resultPanel = SearchMediator.getResultPanelForGUID(new GUID(byArray));
                        if (resultPanel == null) {
                            return;
                        }
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    for (SearchResult searchResult : list) {
                                        RESULT_DISPLAYER.addQueryResult(byArray, searchResult, resultPanel);
                                    }
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            ErrorService.error(interruptedException, "invokeAndWait for store song result");
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            ErrorService.error(invocationTargetException, "invokeAndWait for store song result");
                        }
                    }
                });
            }
        });
        return byArray;
    }

    public static byte[] triggerSearch(String string) {
        return SearchMediator.triggerSearch(SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType()));
    }

    public static void showMyFiles(String string) {
        SearchMediator.addMyFilesResultTab(string);
    }

    private static boolean validate(SearchInformation searchInformation) {
        switch (SearchMediator.validateInfo(searchInformation)) {
            case 1: {
                return false;
            }
            case 2: {
                GUIMediator.showError(I18n.tr("Your search must be at least three characters to avoid congesting the network."));
                return false;
            }
            case 3: {
                String string = searchInformation.getXML();
                if (string == null || string.length() == 0) {
                    GUIMediator.showError(I18n.tr("Your search is too long. Please make your search smaller and try again."));
                } else {
                    GUIMediator.showError(I18n.tr("Your search is too specific. Please make your search smaller and try again."));
                }
                return false;
            }
            case 4: {
                GUIMediator.showError(I18n.tr("Your search is too specific. Please make your search smaller and try again."));
                return false;
            }
        }
        if (!GuiCoreMediator.getLifecycleManager().isStarted()) {
            GUIMediator.showMessage(I18n.tr("Please wait, FrostWire must finish loading before a search can be started."));
            return false;
        }
        if (!searchInformation.isBrowseHostSearch() && !GuiCoreMediator.getConnectionServices().isConnected()) {
            if (!GuiCoreMediator.getConnectionServices().isConnecting()) {
                GUIMediator.showMessage(I18n.tr("You are not connected to the network. To connect, select \"Connect\" from the \"File\" menu. Your search may not return any results until you connect."), QuestionsHandler.NO_NOT_CONNECTED);
            } else {
                GUIMediator.showMessage(I18n.tr("FrostWire is currently connecting to the network. Your search may not return many results until you are fully connected to the network."), QuestionsHandler.NO_STILL_CONNECTING);
            }
        }
        return true;
    }

    public static int validateInfo(SearchInformation searchInformation) {
        String string = I18NConvert.instance().getNorm(searchInformation.getQuery());
        String string2 = searchInformation.getXML();
        if (string.length() == 0) {
            return 1;
        }
        if (!(string.length() > 2 || string.length() == 2 && (Character.isDigit(string.charAt(0)) && Character.isLetter(string.charAt(1)) || Character.isLetter(string.charAt(0)) && Character.isDigit(string.charAt(1))))) {
            return 2;
        }
        if (string.length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            return 3;
        }
        if (string2 != null && string2.length() > SearchSettings.MAX_XML_QUERY_LENGTH.getValue()) {
            return 4;
        }
        if (StringUtils.containsCharacters(string, SearchSettings.ILLEGAL_CHARS.getValue())) {
            return 5;
        }
        return 0;
    }

    private static void doSearch(byte[] byArray, SearchInformation searchInformation) {
        String string = searchInformation.getQuery();
        String string2 = searchInformation.getXML();
        MediaType mediaType = searchInformation.getMediaType();
        if (searchInformation.isXMLSearch()) {
            GuiCoreMediator.getSearchServices().query(byArray, string, string2, mediaType);
        } else if (searchInformation.isKeywordSearch()) {
            GuiCoreMediator.getSearchServices().query(byArray, string, mediaType);
        } else if (searchInformation.isWhatsNewSearch()) {
            GuiCoreMediator.getSearchServices().queryWhatIsNew(byArray, mediaType);
        } else if (searchInformation.isBrowseHostSearch()) {
            IpPort ipPort = searchInformation.getIpPort();
            SearchMediator.doBrowseHost(new ConnectableImpl(ipPort, false), null);
        }
    }

    private static ResultPanel addResultTab(GUID gUID, SearchInformation searchInformation) {
        return RESULT_DISPLAYER.addResultTab(gUID, searchInformation);
    }

    private static ResultPanel addMyFilesResultTab(String string) {
        return RESULT_DISPLAYER.addMyFilesResultTab(string);
    }

    private static ResultPanel addBrowseHostTab(GUID gUID, String string) {
        return RESULT_DISPLAYER.addResultTab(gUID, SearchInformation.createBrowseHostSearch(string));
    }

    public static void handleQueryResult(RemoteFileDesc remoteFileDesc, HostData hostData, Set<? extends IpPort> set) {
        byte[] byArray = hostData.getMessageGUID();
        ResultPanel resultPanel = SearchMediator.getResultPanelForGUID(new GUID(byArray));
        if (resultPanel != null) {
            GnutellaSearchResult gnutellaSearchResult = new GnutellaSearchResult(remoteFileDesc, hostData, set);
            RESULT_DISPLAYER.addQueryResult(byArray, gnutellaSearchResult, resultPanel);
        }
    }

    public static void downloadFromPanel(ResultPanel resultPanel, TableLine[] tableLineArray) {
        SearchMediator.downloadAll(tableLineArray, new GUID(resultPanel.getGUID()), resultPanel.getSearchInformation());
        resultPanel.refresh();
    }

    static void doDownload(final ResultPanel resultPanel) {
        final TableLine[] tableLineArray = resultPanel.getAllSelectedLines();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.downloadAll(tableLineArray, new GUID(resultPanel.getGUID()), resultPanel.getSearchInformation());
                resultPanel.refresh();
            }
        });
    }

    static void doDownloadAs(ResultPanel resultPanel) {
        TableLine[] tableLineArray = resultPanel.getAllSelectedLines();
        if (tableLineArray.length != 1) {
            throw new IllegalStateException("There should only be one search result selected: " + tableLineArray.length);
        }
        SearchMediator.downloadLine(tableLineArray[0], new GUID(resultPanel.getGUID()), null, null, true, resultPanel.getSearchInformation());
    }

    private static void downloadAll(TableLine[] tableLineArray, GUID gUID, SearchInformation searchInformation) {
        for (int i = 0; i < tableLineArray.length; ++i) {
            SearchMediator.downloadLine(tableLineArray[i], gUID, null, null, false, searchInformation);
        }
    }

    private static void downloadLine(TableLine tableLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        if (tableLine == null) {
            throw new NullPointerException("Tried to download null line");
        }
        tableLine.takeAction(tableLine, gUID, file, string, bl, searchInformation);
    }

    public static void downloadGnutellaLine(TableLine tableLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        IpPort ipPort;
        if (tableLine == null) {
            throw new NullPointerException("Tried to download null line");
        }
        IpPortSet ipPortSet = new IpPortSet();
        LinkedList<RemoteFileDesc> linkedList = new LinkedList<RemoteFileDesc>();
        RemoteFileDesc[] remoteFileDescArray = tableLine.getAllRemoteFileDescs();
        ipPortSet.addAll(tableLine.getAlts());
        RemoteFileDesc remoteFileDesc = null;
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            ipPort = remoteFileDescArray[i];
            ipPort.setRetryAfter(0);
            if (ipPort.getSHA1Urn() != null) {
                remoteFileDesc = ipPort;
            }
            ipPortSet.remove(ipPort);
        }
        if (remoteFileDesc == null) {
            remoteFileDesc = remoteFileDescArray[0];
        }
        Object object = ipPortSet.iterator();
        while (object.hasNext()) {
            ipPort = (IpPort)object.next();
            linkedList.add(GuiCoreMediator.getRemoteFileDescFactory().createRemoteFileDesc(remoteFileDesc, ipPort));
        }
        if (file == null && tableLine.getNamedMediaType() != null && !((AbstractSetting)(object = SharingSettings.getFileSettingForMediaType(tableLine.getNamedMediaType().getMediaType()))).isDefault()) {
            file = ((FileSetting)object).getValue();
        }
        SearchMediator.downloadWithOverwritePrompt(remoteFileDescArray, linkedList, gUID, file, string, bl, searchInformation);
    }

    private static void downloadWithOverwritePrompt(RemoteFileDesc[] remoteFileDescArray, List<? extends RemoteFileDesc> list, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        Object object;
        Object object2;
        int n;
        if (remoteFileDescArray.length < 1) {
            return;
        }
        if (SearchMediator.containsExe(remoteFileDescArray) && !SearchMediator.userWantsExeDownload()) {
            return;
        }
        boolean bl2 = false;
        for (n = 0; n < remoteFileDescArray.length; ++n) {
            if (remoteFileDescArray[n].getIndex() != 0xFFFFFFFFL) continue;
            bl2 = true;
            break;
        }
        if (bl2 && (object2 = remoteFileDescArray[n].getXMLDocument()) != null && (object = ((LimeXMLDocument)object2).getAction()) != null && !((String)object).equals("")) {
            if (((LimeXMLDocument)object2).actionDetailRequested()) {
                object = LimeWireUtils.addLWInfoToUrl((String)object, GuiCoreMediator.getApplicationServices().getMyGUID());
            }
            if (((String)object).length() > 255) {
                object = ((String)object).substring(0, 255);
            }
            GUIMediator.openURL((String)object);
            return;
        }
        object2 = new SearchResultDownloaderFactory(remoteFileDescArray, list, gUID, file, string);
        Object object3 = object = bl ? DownloaderUtils.createDownloaderAs((GuiDownloaderFactory)object2) : DownloaderUtils.createDownloader((GuiDownloaderFactory)object2);
        if (object != null) {
            SearchMediator.setAsDownloading(remoteFileDescArray);
            if (SearchMediator.validateInfo(searchInformation) == 0) {
                object.setAttribute(SEARCH_INFORMATION_KEY, searchInformation.toMap(), false);
            }
        }
    }

    private static void setAsDownloading(RemoteFileDesc[] remoteFileDescArray) {
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            remoteFileDescArray[i].setDownloading(true);
        }
    }

    private static boolean containsExe(RemoteFileDesc[] remoteFileDescArray) {
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            if (!remoteFileDescArray[i].getFileName().toLowerCase(Locale.US).endsWith("exe")) continue;
            return true;
        }
        return false;
    }

    private static boolean userWantsExeDownload() {
        DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("One of the selected files is an executable program and could contain a virus. Are you sure you want to download it?"), QuestionsHandler.PROMPT_FOR_EXE, DialogOption.NO);
        return dialogOption == DialogOption.YES;
    }

    static void setTabDisplayCount(ResultPanel resultPanel) {
        RESULT_DISPLAYER.setTabDisplayCount(resultPanel);
    }

    static void killSearch() {
        RESULT_DISPLAYER.killSearch();
    }

    static void panelSelected(ResultPanel resultPanel) {
        INPUT_MANAGER.setFiltersFor(resultPanel);
    }

    static void searchKilled(ResultPanel resultPanel) {
        INPUT_MANAGER.panelRemoved(resultPanel);
        ResultPanel resultPanel2 = RESULT_DISPLAYER.getSelectedResultPanel();
        if (resultPanel2 != null) {
            INPUT_MANAGER.setFiltersFor(resultPanel2);
        }
        resultPanel.cleanup();
    }

    static void checkToStopLime() {
        RESULT_DISPLAYER.checkToStopLime();
    }

    static ResultPanel getResultPanelForGUID(GUID gUID) {
        return RESULT_DISPLAYER.getResultPanelForGUID(gUID);
    }

    public static boolean queryIsAlive(GUID gUID) {
        return SearchMediator.getResultPanelForGUID(gUID) != null;
    }

    public static JComponent getSearchComponent() {
        return INPUT_MANAGER.getComponent();
    }

    public static JComponent getResultComponent() {
        return RESULT_DISPLAYER.getComponent();
    }

    public static synchronized Ad getAd() {
        if (banner == null) {
            SearchMediator.initBanner();
        }
        return banner.getAd();
    }
}

